<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Terceros</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body text-center">
                            <h3><b>CIERRE</b></h3>
                            <span><b>Cierre de mercancia enviada de mas.</b></span>
                        </div>
                    </div>



                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase"></h6>
                            <hr/>
                            <div class=" mt-2" style="overflow: auto">
                                <table class="table align-middle table-hover table-striped mb-0" id="example2" style="width: 100%; font-size: 14px;">
                                    <thead>
                                        <tr class="bg-tianzi-claro text-dark">
                                            <th class="">NOMBRE</th>
                                            <th class="text-center">DESPACHADO DE MAS</th>
                                            <th class="text-center">DETALLE</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT nombre_tercero FROM alm_venta 
                                                UNION
                                                SELECT nombre_tercero FROM alm_pedido 
                                                UNION
                                                SELECT nombre_tercero FROM alm_cierre_detalle 
                                                UNION
                                                SELECT nombre_tercero FROM alm_referencia_cierre GROUP BY nombre_tercero ORDER BY nombre_tercero asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {

                                                $sql1 = "SELECT SUM(cantidad) as cantidad FROM alm_referencia_cierre WHERE nombre_tercero='" . $row['nombre_tercero'] . "'";
                                                $query1 = $conn->query($sql1);
                                                $row1 = $query1->fetch_assoc();
                                                
                                                if(isset($row1['cantidad'])){
                                                    $row1['cantidad'] = $row1['cantidad'];
                                                }else{
                                                    $row1['cantidad'] = 0;
                                                }
                                                
                                                
                                                ?>


                                                <tr>
                                                    <td class=""><strong><?php echo $row['nombre_tercero']; ?></strong></td>
                                                    <td class="text-center">
                                                        <?php echo number_format($row1['cantidad'], 0); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="cierre-tercero.php?nombre_tercero=<?php echo $row['nombre_tercero']; ?>">
                                                            <i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="text-center mt-5">
                                <a href="sincronizar-tercero.php" class="btn btn-primary radius-30 px-5 ">SINCORNIZAR</a>
                            </div>

                        </div>
                    </div>



                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

  
        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": [[1, 'asc']],
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>