<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="compra.php"> 
                                    Compras        
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Comparativo</li>
                        </ol>
                    </nav>



                    <div class="card">
                        <div class="card-body bg-tianzi-claro">


                            <h4 class="text-center"><b>COMPARATIVO DE COMPRAS</b></h4>
                        </div>
                    </div>




                    <div class="row">
                        <div class="col-xl-12">

                            <div class="card">
                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <h6 class="mb-0 text-uppercase">Lista de compras</h6>

                                        </div>
                                    </div>

                                    <hr/>

                                    <style>
                                        #hover_enlace:hover{
                                            color: purple;
                                            border-radius: 10px;
                                            box-shadow: 0px 0px 10px 0px purple;
                                        }

                                    </style>

                                    <div class="table-responsive mt-2">
                                          <table class="table table-bordered table-striped table-hover" id="example2">
                                            <thead class="">
                                                <tr class="bg-pink text-white">
                                                    <th class="text-center ">CONSECUTIVO</th>
                                                    <th class="text-center ">FECHA</th>
                                                    <th class=" ">NOMBRE TERCERO</th>
                                                    <th class="text-center ">NUMERO FACTURA</th>
                                                    <th class=" ">CANTIDAD</th>
                                                    <th class="text-center ">DESCRIPCION</th>
                                                    <th class="text-center ">TOTAL</th>
                                                    <th class="text-center ">TOTAL DETALLE</th>

                                                    <th class="text-center ">ESTADO</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $total = 0;
                                                $sql4 = "SELECT * FROM alm_compra ORDER BY fecha desc, id desc";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {



                                                        $sql6 = "SELECT SUM(total) as total_detalle FROM alm_compra_detalle WHERE id_compra='" . $row4['id'] . "'";
                                                        $query6 = $conn->query($sql6);
                                                        $row6 = $query6->fetch_assoc();

                                                        
                                                        $total_v = round($row4['total_compra']);
                                                        
                                                        
                                                        if (isset($row6['total_detalle'])) {
                                                            $total_detalle = round($row6['total_detalle']);
                                                        } else {
                                                            $total_detalle = 0;
                                                        }



                                                        if ($total_v == $total_detalle) {
                                                            
                                                        } else {
                                                            ?> 
                                                            <tr class="align-middle" id="hover_enlace" 
                                                                style="cursor: pointer;"

                                                                onclick=" window.location = 'compra-detalle.php?id_compra=<?php echo $row4['id']; ?> ';">

                                                                <td class="text-center">
                                                                    <strong class="text-dark"><?php echo $row4['numero_compra']; ?></strong><br>
                                                                </td>
                                                                <td>
                                                                    <strong class="text-dark"><?php echo $row4['fecha']; ?></strong><br>
                                                                </td>
                                                                <td class="">
                                                                    <?php echo $row4['nombre_tercero']; ?>
                                                                </td> 
                                                                <td class="text-center">
                                                                    <?php echo $row4['numero_factura']; ?>
                                                                </td>
                                                                <td class="text-center">
                                                                    <?php
                                                                    $sql5 = "SELECT SUM(cantidad) as cantidad FROM alm_compra_detalle WHERE id_compra='" . $row4['id'] . "'";
                                                                    $query5 = $conn->query($sql5);
                                                                    $row5 = $query5->fetch_assoc();

                                                                    if (isset($row5['cantidad'])) {
                                                                        $cantidad = $row5['cantidad'];
                                                                    } else {
                                                                        $cantidad = 0;
                                                                    }
                                                                    ?>

                                                                    <?php echo $cantidad; ?>
                                                                </td>

                                                                <td class="" style="width: 20%;">
                                                                    <?php echo $row4['observacion']; ?>
                                                                </td>
                                                                <td class="text-end">
                                                                    <b class="text-secondary float-start">$</b><b><?php echo $total_v; ?></b>
                                                                </td> 
                                                                
                                                                <td><?php echo $total_detalle;?></td>
                                                                
                                                                <td class="text-center">
                                                                    <?php
                                                                    if ($row4['estado'] == 'Proceso') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-info';
                                                                    } elseif ($row4['estado'] == 'Confirmado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-pink';
                                                                    } elseif ($row4['estado'] == 'Finalizado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-success';
                                                                    } elseif ($row4['estado'] == 'Cancelado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-secondary';
                                                                    } else {
                                                                        $text = 'text-dark';
                                                                    }
                                                                    ?>
                                                                    <span class="badge <?php echo $alert; ?>"><?php echo $row4['estado']; ?></span>

                                                                </td>
                                                            </tr>

                                                            <?php
                                                        }
                                                        ?>

                                                        <?php
                                                        $total += $row4['total_compra'];
                                                    }
                                                }
                                                ?>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->




                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>