<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>

        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                             <li class="breadcrumb-item">
                                <a href="empresa.php"> 
                                    Fabrica
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Pendiente</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center bg-gradient-royal text-white">
                            <h3><b>PENDIENTE</b></h3>
                        </div>
                    </div>

                    <div class="card ">
                        <div class="card-body">


                            <style>
                                th, td { white-space: nowrap; }

                                div.dataTables_wrapper {
                                    width: 100%;
                                    margin: 0 auto;
                                }


                            </style>

                            <?php
                            $nombre_tercero = 'INNOVASUELAS ALMACEN';
                            ?>


                            <div class=" mt-3">
                                <h5 class="mt-3 text-decoration-underline"><b><?php echo $nombre_tercero; ?></b></h5>

                                <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                    <thead class="bg-gradient-royal text-white">
                                        <tr class=" ">
                                            <th class="bg-gradient-royal" >REFERENCIAS</th>
                                            <?php
                                            $sql = "SELECT talla FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY talla ORDER BY talla asc";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {
                                                    ?>
                                                    <th class="text-center" ><?php echo $row['talla']; ?></th>
                                                    <?php
                                                }
                                            }
                                            ?>


                                            <th class="text-center">TOTAL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql1 = "SELECT referencia_producto FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY referencia_producto ORDER BY referencia_producto asc";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {
                                                ?>
                                                <tr class="" >
                                                    <td class="">
                                                        <b class="text-primary"><?php echo $row1['referencia_producto']; ?></b>
                                                    </td>

                                                    <?php
                                                    $total_talla = 0;
                                                    $sql2 = "SELECT talla FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY talla ORDER BY talla asc";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {

                                                            $sql3 = "SELECT SUM(cantidad) as cantidad FROM referencia_despacho WHERE referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $row2['talla'] . "' AND nombre_tercero='$nombre_tercero'";
                                                            $query3 = $conn->query($sql3);
                                                            $row3 = $query3->fetch_assoc();

                                                            $talla = number_format($row3['cantidad'], 0);

                                                            if ($talla < 0) {
                                                                $bg_color_talla = 'bg-danger';
                                                                $text_color = 'text-white';
                                                            } elseif ($talla > 0) {
                                                                $bg_color_talla = 'bg-info';
                                                                $text_color = 'text-white';
                                                            } else {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                            }
                                                            ?>
                                                            <td class="text-center <?php echo $bg_color_talla; ?>" >
                                                                <b class="<?php echo $text_color; ?>"><?php echo $talla; ?></b>
                                                           </td>
                                                            <?php
                                                            $total_talla += $talla;
                                                        }
                                                    }
                                                    ?> 
                                                    <td class="text-center">
                                                        <?php
                                                        if ($total_talla < 0) {
                                                            $text_total_color = 'text-danger';
                                                        } elseif ($total_talla > 0) {
                                                            $text_total_color = 'text-info';
                                                        } else {
                                                            $text_total_color = '';
                                                        }
                                                        ?>

                                                        <h6><b class="<?php echo $text_total_color; ?>"><?php echo $total_talla; ?></b></h6>
                                                    </td>

                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>


                            <div class="text-end">
                                <span>Mercancia por despachar</span> <i class="fa-solid fa-square  text-info"></i>
                                <br>
                                <span>Mercancia que se despacho de mas</span>  <i class="fa-solid fa-square  text-danger"></i> 
                            </div>

                        </div>
                    </div>


                    <style>
                        #hover_enlace:hover{
                            box-shadow: 0px 0px 20px 0px #3C3D6B;
                        }

                    </style>

                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
            <!--end wrapper-->
            <?php echo include '../general/libreria-js.php'; ?>

    </body>
</html>
