<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];

    $sqlfecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
} else {
    $fecha_desde = '';
    $fecha_hasta = '';
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">


                <nav aria-label="breadcrumb" class="d-print-none">

                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item">Reporte de vendedores</li>
                    </ol>


                </nav>


                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded">

                                    <form method="GET" action="rpt-cartera.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Tercero</label>
                                                    <select class="form-select single-select"  required="" name="nombre_tercero">                                           
                                                        <option selected="" disabled="" value="">Seleccione</option>
                                                        <?php
                                                        $sqlt = "SELECT * FROM tercero";
                                                        $queryt = $conn->query($sqlt);
                                                        if ($queryt->num_rows > 0) {
                                                            while ($rowt = $queryt->fetch_assoc()) {
                                                                ?>
                                                                <option class="text-sm" value="<?php echo $rowt['nombre']; ?>"><?php echo $rowt['nombre']; ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>         
                                                </div>
                                            </div>

                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card d-print-none">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-4">


                            </div>
                            <div class="col-sm-4">
                                <h6 class=" mb-3 text-center"><b>Ventas <br><?php echo strftime("%d - %B - %Y", strtotime(date($fecha_desde))); ?> <strong class="text-info">al</strong> <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_hasta))); ?></b></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <style>
                    #hover_enlace:hover{
                        color: orange;
                        border-radius: 10px; border: #3fc3ee 1px solid;
                        box-shadow: 0px 0px 5px 0px #3fc3ee;
                    }

                </style>


                <?php
                if (isset($_GET['filtro'])) {
                    ?>



                    <div class="bg-white rounded" style="box-shadow: 0px 0px 5px 1px #C3C3C3;">

                        <?php
                        //ARRASTRE DIA////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //Facturas
                        $sql3a = "SELECT SUM(total) as total_compra FROM compra WHERE fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero'";
                        $query3a = $conn->query($sql3a);
                        $row3a = $query3a->fetch_assoc();
                        $comprasa = $row3a['total_compra'];

                        //cruce origen
                        $sql6a = "SELECT SUM(monto) as cruce_origen FROM cruce_cuenta WHERE fecha<'$fecha_desde' AND nombre_tercero_origen='$nombre_tercero'";
                        $query6a = $conn->query($sql6a);
                        $row6a = $query6a->fetch_assoc();
                        $cruce_origena = $row6a['cruce_origen'];

                        //debo
                        $sql8a = "SELECT SUM(monto) as debo FROM arrastre WHERE fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero' AND movimiento='debo'";
                        $query8a = $conn->query($sql8a);
                        $row8a = $query8a->fetch_assoc();
                        $deboa = $row8a['debo'];

                        //flete
                        $sql9a = "SELECT SUM(flete_empresa + flete_cliente) as flete FROM venta WHERE fecha<'$fecha_desde' AND tercero_transportadora='$nombre_tercero' AND  (estado='Entregado' OR estado='Devolucion')";
                        $query9a = $conn->query($sql9a);
                        $row9a = $query9a->fetch_assoc();
                        $fletea = $row9a['flete'];
                        $total_compra_serviciosa = $comprasa + $cruce_origena + $deboa + $fletea;

                        //Egresos
                        $sql2a = "SELECT SUM(monto) as caja_egreso FROM caja_detalle WHERE fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero' AND movimiento='egreso' AND tipo='normal'";
                        $query2a = $conn->query($sql2a);
                        $row2a = $query2a->fetch_assoc();
                        $egresos_normala = $row2a['caja_egreso'];

                        $subtotal_deudaa = $total_compra_serviciosa - $egresos_normala;

                        //***********************************************************************************************************//
                        //venta
                        $sql4a = "SELECT SUM(total_venta-abono_venta) as venta FROM venta WHERE fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero' AND estado='Entregado' AND modo_pago='Credito'";
                        $query4a = $conn->query($sql4a);
                        $row4a = $query4a->fetch_assoc();
                        $ventaa = $row4a['venta'];

                        //cruce destino
                        $sql7a = "SELECT SUM(monto) as cruce_destino FROM cruce_cuenta WHERE fecha<'$fecha_desde' AND nombre_tercero_destino='$nombre_tercero'";
                        $query7a = $conn->query($sql7a);
                        $row7a = $query7a->fetch_assoc();
                        $cruce_destinoa = $row7a['cruce_destino'];

                        //debe
                        $sql10a = "SELECT SUM(monto) as debe FROM arrastre WHERE fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero' AND movimiento='debe'";
                        $query10a = $conn->query($sql10a);
                        $row10a = $query10a->fetch_assoc();
                        $debea = $row10a['debe'];

                        //recaudadora
                        $sql11a = "SELECT SUM(total_venta-abono_venta) as recaudadora FROM venta WHERE fecha<'$fecha_desde' AND tercero_recaudadora='$nombre_tercero' AND estado='Entregado'";
                        $query11a = $conn->query($sql11a);
                        $row11a = $query11a->fetch_assoc();
                        $recaudadoraa = $row11a['recaudadora'];

                        $total_venta_serviciosa = $ventaa + $cruce_destinoa + $debea + $recaudadoraa;

                        //Ingresos
                        $sql1a = "SELECT SUM(monto) as caja_ingreso FROM caja_detalle WHERE  fecha<'$fecha_desde' AND nombre_tercero='$nombre_tercero' AND movimiento='ingreso' AND tipo='normal'";
                        $query1a = $conn->query($sql1a);
                        $row1a = $query1a->fetch_assoc();
                        $ingresos_normala = $row1a['caja_ingreso'];

                        $subtotal_deudora = $total_venta_serviciosa - $ingresos_normala;

                        $arrastre = $subtotal_deudora - $subtotal_deudaa;
                        ?>

                        <div class="d-print-none">
                            <div class="float-end">
                                <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                    <i class="fas fa-print"> Imprimir</i>
                                </a>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div class="p-2 rounded" style="background-color:#F2F2F2 ">
                            <div class="row">
                                <div class="col-sm-12 text-center">
                                    <h2 class="azul"><b><?php echo $nombre_tercero; ?></b></h2>  

                                    <button class="btn btn-info"><b style="font-size: 20px;"><?php echo number_format($arrastre); ?></b></button>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive rounded mt-3 p-2">
                            <table class="table rounded table-bordered table-hover"  style="font-size: 12px;">

                                <thead>

                                    <tr class="bg-light-primaryi text-primary">
                                        <th class="">Movimiento</th>
                                        <th class="text-center">Usuario | Cod</th>
                                        <th class="text-center">Descripcion</th>
                                        <th class="text-center">Cant. Item</th>
                                        <th class="text-center">Monto</th>
                                        <th class="text-center">Arrastre</th>
                                    </tr>
                                </thead>
                                <?php
                                $total_arrastre = $arrastre;

                                $sqlfa = "SELECT fecha FROM compra WHERE nombre_tercero='$nombre_tercero' AND $sqlfecha
                                        UNION 
                                        SELECT fecha FROM venta WHERE nombre_tercero='$nombre_tercero' AND modo_pago='Credito' AND estado='Entregado'  AND $sqlfecha
                                        UNION
                                        SELECT fecha FROM venta WHERE tercero_transportadora='$nombre_tercero' AND (estado='Entregado' OR estado='Devolucion') AND $sqlfecha 
                                        UNION 
                                        SELECT fecha FROM venta WHERE tercero_recaudadora='$nombre_tercero' AND estado='Entregado' AND $sqlfecha
                                        UNION 
                                        SELECT fecha FROM arrastre WHERE nombre_tercero='$nombre_tercero' AND $sqlfecha
                                        UNION
                                        SELECT fecha FROM cruce_cuenta WHERE (nombre_tercero_origen='$nombre_tercero' OR nombre_tercero_destino='$nombre_tercero') AND $sqlfecha
                                        UNION 
                                        SELECT fecha FROM caja_detalle WHERE nombre_tercero='$nombre_tercero' AND tipo='normal' AND $sqlfecha ORDER BY fecha asc";
                                $queryfa = $conn->query($sqlfa);
                                if ($queryfa->num_rows > 0) {
                                    while ($rowfa = $queryfa->fetch_assoc()) {
                                        ?>
                                        <thead>
                                            <tr class="text-center" style="background-color: #e2e3e5" >
                                                <th class=" p-1" colspan="9"><b style=""><?php echo $rowfa['fecha']; ?></b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            //COMPRAS
                                            $t_compras = 0;
                                            $sql = "SELECT * FROM compra WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero'";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {
                                                    $sql1 = "SELECT SUM(cantidad) as cantidad FROM compra_detalle WHERE id_compra='" . $row['id'] . "'";
                                                    $query1 = $conn->query($sql1);
                                                    $row1 = $query1->fetch_assoc();
                                                    ?>
                                                    <tr>
                                                        <td><b class="text-danger">COMPRA</b></td>
                                                        <td><b><?php echo $row['nombre_usuario']; ?> | C <?php echo $row['id'] ?></b></td>
                                                        <td><b><?php echo $row['numero_factura']; ?></b> | <?php echo $row['descripcion']; ?></td>
                                                        <td class="text-center"><?php echo $row1['cantidad']; ?></td>
                                                        <td class="text-end">
                                                            <?php echo number_format($row['total'], 0); ?> 
                                                            <i class="fas fa-minus-circle text-danger"></i>
                                                        </td>
                                                        <td class='text-center'>
                                                            <a href="../compra/compra-detalle.php?id_compra=<?php echo $row['id']; ?>" target="_blank">
                                                                <i class="fas fa-globe"></i>
                                                            </a>
                                                        </td> 
                                                    </tr>
                                                    <?php
                                                    $t_compras += $row['total'];
                                                }
                                            }
                                            ?>

                                            <?php
                                            //VENTAS CREDITO
                                            $t_ventas = 0;
                                            $sql4 = "SELECT * FROM venta WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero' AND (estado='Enviado' OR estado='Novedad' OR estado='Entregado' OR estado='Devolucion') AND modo_pago='Credito'";
                                            $query4 = $conn->query($sql4);
                                            if ($query4->num_rows > 0) {
                                                while ($row4 = $query4->fetch_assoc()) {
                                                    $sql5 = "SELECT SUM(cantidad) as cantidad FROM venta_detalle WHERE id_venta='" . $row4['id'] . "'";
                                                    $query5 = $conn->query($sql5);
                                                    $row5 = $query5->fetch_assoc();
                                                    ?>
                                                    <tr>
                                                        <td>                                   
                                                            <b class="text-success">VENTA CREDITO</b>

                                                        <td>
                                                            <b><?php echo $row4['nombre_usuario']; ?> | </b>
                                                            <b class="text-primary">ODP <?php echo $row4['id'] ?></b>
                                                        <?php
                                                        if ($row4['estado'] == 'Proceso') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-info';
                                                        } elseif ($row4['estado'] == 'Confirmado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-pink';
                                                        } elseif ($row4['estado'] == 'Alistamiento') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-primary';
                                                        } elseif ($row4['estado'] == 'Enviado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-warning';
                                                        } elseif ($row4['estado'] == 'Novedad') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-bronze';
                                                        } elseif ($row4['estado'] == 'Entregado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-success';
                                                        } elseif ($row4['estado'] == 'Cancelado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-secondary';
                                                        } elseif ($row4['estado'] == 'Devolucion') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-dark';
                                                        } else {
                                                            $text = 'text-dark';
                                                        }
                                                        ?>

                                                <span class="badge <?php echo $alert; ?> float-end"><?php echo $row4['estado']; ?></span>
                                                </td>
                                                <td> 
                                                    <b><?php echo $row4['cedula']; ?></b> | <?php echo $row4['nombre']; ?>
                                                    <b class="text-secondary float-end"><i class="fas fa-file-alt"></i> <?php echo $row4['numero_guia']; ?></b>
                                                </td>
                                                <td class="text-center"><?php echo $row5['cantidad']; ?></td>
                                                <td class="text-end">
                                                    <?php echo number_format($row4['total_venta'], 0); ?> 
                                                    <i class="fas fa-plus-circle text-success"></i>
                                                </td>
                                                <td class='text-center'>
                                                    <a href="../venta/venta-detalle.php?id_venta=<?php echo $row4['id']; ?>" target="_blank">
                                                        <i class="fas fa-globe"></i>
                                                    </a>
                                                </td> 
                                                </tr>
                                                <?php
                                                $t_ventas += $row4['total_venta'];
                                            }
                                        }
                                        ?>

                                        <?php
                                        //FLETES
                                        $t_fletes = 0;
                                        $sql2 = "SELECT * FROM venta WHERE fecha='" . $rowfa['fecha'] . "' AND tercero_transportadora='$nombre_tercero' AND (estado='Enviado' OR estado='Novedad' OR estado='Entregado' OR estado='Devolucion') ";
                                        $query2 = $conn->query($sql2);
                                        if ($query2->num_rows > 0) {
                                            while ($row2 = $query2->fetch_assoc()) {

                                                $sql3 = "SELECT SUM(cantidad) as cantidad FROM venta_detalle WHERE id_venta='" . $row2['id'] . "'";
                                                $query3 = $conn->query($sql3);
                                                $row3 = $query3->fetch_assoc();
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="text-danger">FLETE</b>
                                                    <td>
                                                        <b><?php echo $row2['nombre_usuario']; ?> | </b><b class="text-primary">ODP <?php echo $row2['id'] ?></b></td>

                                                    <?php
                                                    if ($row2['estado'] == 'Proceso') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-info';
                                                    } elseif ($row2['estado'] == 'Confirmado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-pink';
                                                    } elseif ($row2['estado'] == 'Alistamiento') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-primary';
                                                    } elseif ($row2['estado'] == 'Enviado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-warning';
                                                    } elseif ($row2['estado'] == 'Novedad') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-bronze';
                                                    } elseif ($row2['estado'] == 'Entregado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-success';
                                                    } elseif ($row2['estado'] == 'Cancelado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-secondary';
                                                    } elseif ($row2['estado'] == 'Devolucion') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-dark';
                                                    } else {
                                                        $text = 'text-dark';
                                                    }
                                                    ?>

                                                <span class="badge <?php echo $alert; ?> float-end"><?php echo $row2['estado']; ?></span>
                                                </td>
                                                <td>
                                                    <b><?php echo $row2['cedula']; ?></b> | <?php echo $row2['nombre']; ?>
                                                    <b class="text-secondary float-end"><i class="fas fa-file-alt"></i> <?php echo $row2['numero_guia']; ?></b>
                                                </td>
                                                <td class="text-center"><?php echo $row3['cantidad']; ?></td>
                                                <td class="text-end">
                                                    <?php echo number_format($row2['flete_cliente'] + $row2['flete_empresa'], 0); ?> 
                                                    <i class="fas fa-minus-circle text-danger"></i>
                                                </td>
                                                <td class='text-center'>
                                                    <a href="../venta/venta-detalle.php?id_venta=<?php echo $row2['id']; ?>" target="_blank">
                                                        <i class="fas fa-globe"></i>
                                                    </a>
                                                </td> 
                                                </tr>
                                                <?php
                                                $t_fletes += $row2['flete_cliente'] + $row2['flete_empresa'];
                                            }
                                        }
                                        ?>



                                        <?php
                                        //RECAUDADORA
                                        $t_ventas_redes = 0;
                                        $sql6 = "SELECT * FROM venta WHERE fecha='" . $rowfa['fecha'] . "' AND tercero_recaudadora='$nombre_tercero' AND estado='Entregado'";
                                        $query6 = $conn->query($sql6);
                                        if ($query6->num_rows > 0) {
                                            while ($row6 = $query6->fetch_assoc()) {

                                                $sql7 = "SELECT SUM(cantidad) as cantidad FROM venta_detalle WHERE id_venta='" . $row6['id'] . "'";
                                                $query7 = $conn->query($sql7);
                                                $row7 = $query7->fetch_assoc();
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="text-success">VENTA RECAUDAR</b>
                                                    <td>
                                                        <b><?php echo $row6['nombre_usuario']; ?> | </b><b class="text-primary">ODP <?php echo $row6['id'] ?></b></td>

                                                    <?php
                                                    if ($row6['estado'] == 'Proceso') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-info';
                                                    } elseif ($row6['estado'] == 'Confirmado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-pink';
                                                    } elseif ($row6['estado'] == 'Alistamiento') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-primary';
                                                    } elseif ($row6['estado'] == 'Enviado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-warning';
                                                    } elseif ($row6['estado'] == 'Novedad') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-bronze';
                                                    } elseif ($row6['estado'] == 'Entregado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-success';
                                                    } elseif ($row6['estado'] == 'Cancelado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-secondary';
                                                    } elseif ($row6['estado'] == 'Devolucion') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-dark';
                                                    } else {
                                                        $text = 'text-dark';
                                                    }
                                                    ?>

                                                <span class="badge <?php echo $alert; ?> float-end"><?php echo $row6['estado']; ?></span>
                                                </td>
                                                <td>
                                                    <b><?php echo $row6['cedula']; ?></b> | <?php echo $row6['nombre']; ?>
                                                    <b class="text-secondary float-end"><i class="fas fa-file-alt"></i> <?php echo $row6['numero_guia']; ?></b>
                                                </td>
                                                <td class="text-center"><?php echo $row7['cantidad']; ?></td>
                                                <td class="text-end">
                                                    <?php echo number_format($row6['total_venta'] - $row6['abono_venta'], 0); ?> 
                                                    <i class="fas fa-plus-circle text-success"></i>
                                                </td>
                                                <td class='text-center'>
                                                    <a href="../venta/venta-detalle.php?id_venta=<?php echo $row6['id']; ?>" target="_blank">
                                                        <i class="fas fa-globe"></i>
                                                    </a>
                                                </td> 
                                                </tr>
                                                <?php
                                                $t_ventas_redes += $row6['total_venta'] - $row6['abono_venta'];
                                            }
                                        }
                                        ?>


                                        <?php
                                        //ARRASTRE
                                        $tarrastre_debo = 0;
                                        $sql8 = "SELECT * FROM arrastre WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero' AND movimiento='debo'";
                                        $query8 = $conn->query($sql8);
                                        if ($query8->num_rows > 0) {
                                            while ($row8 = $query8->fetch_assoc()) {

                                                if ($row8['movimiento'] == 'debe') {
                                                    $color_arrastre = 'text-success';
                                                    $text_arrastre = 'DEBE';
                                                    $icono_arrastre = ' <i class="fas fa-plus-circle text-success"></i>';
                                                } else {
                                                    $color_arrastre = 'text-danger';
                                                    $text_arrastre = 'DEBO';
                                                    $icono_arrastre = ' <i class="fas fa-minus-circle text-danger"></i>';
                                                }
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="">ARRASTRE | </b>
                                                        <b class="<?php echo $color_arrastre; ?>"><?php echo $text_arrastre; ?></b>
                                                    </td>
                                                    <td>
                                                        <b>---- | </b><b class="text-primary">ARR <?php echo $row8['id'] ?></b>
                                                    </td>
                                                    <td>
                                                        <i class="fas fa-circle <?php echo $color_arrastre ?>"></i> <?php echo $row8['descripcion']; ?>
                                                    </td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row8['monto'], 0); ?> 
                                                        <?php echo $icono_arrastre; ?>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $tarrastre_debo += $row8['monto'];
                                            }
                                        }
                                        ?>


                                        <?php
                                        //ARRASTRE
                                        $tarrastre_debe = 0;
                                        $sql8t = "SELECT * FROM arrastre WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero' AND movimiento='debe'";
                                        $query8t = $conn->query($sql8t);
                                        if ($query8t->num_rows > 0) {
                                            while ($row8t = $query8t->fetch_assoc()) {

                                                if ($row8t['movimiento'] == 'debe') {
                                                    $color_arrastre = 'text-success';
                                                    $text_arrastre = 'DEBE';
                                                    $icono_arrastre = ' <i class="fas fa-plus-circle text-success"></i>';
                                                } else {
                                                    $color_arrastre = 'text-danger';
                                                    $text_arrastre = 'DEBO';
                                                    $icono_arrastre = ' <i class="fas fa-minus-circle text-danger"></i>';
                                                }
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="<?php echo $color_arrastre; ?>"><?php echo $text_arrastre; ?></b>
                                                        <b class=""> | ARRASTRE</b>
                                                    </td>
                                                    <td><b>---- | </b><b class="text-primary">ARR <?php echo $row8t['id'] ?></b></td>
                                                    <td>
                                                        <i class="fas fa-circle <?php echo $color_arrastre ?>"></i> <?php echo $row8t['descripcion']; ?>
                                                    </td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row8t['monto'], 0); ?> 
                                                        <?php echo $icono_arrastre; ?>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $tarrastre_debe += $row8t['monto'];
                                            }
                                        }
                                        ?>


                                        <?php
                                        //CAJA DETALLE
                                        $t_egreso = 0;
                                        $sql9t = "SELECT * FROM caja_detalle WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero' AND movimiento='egreso' AND tipo='normal'";
                                        $query9t = $conn->query($sql9t);
                                        if ($query9t->num_rows > 0) {
                                            while ($row9t = $query9t->fetch_assoc()) {

                                                if ($row9t['movimiento'] == 'ingreso') {
                                                    $color_caja = 'text-success';
                                                    $text_caja = 'INGRESO';
                                                    $icono_caja = ' <i class="fas fa-plus-circle text-warning"></i>';
                                                } else {
                                                    $color_caja = 'text-danger';
                                                    $text_caja = 'EGRESO';
                                                    $icono_caja = ' <i class="fas fa-minus-circle text-warning"></i>';
                                                }
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="<?php echo $color_caja; ?>"><?php echo $text_caja; ?></b>
                                                        <b class=""><i class="fas fa-cash-register"></i> | <?php echo $row9t['nombre_caja']; ?></b>
                                                    </td>
                                                    <td><b>---- | </b><b class="text-primary">CJ <?php echo $row9t['id'] ?></b></td>
                                                    <td> <?php echo $row9t['descripcion']; ?></td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row9t['monto'], 0); ?> 
                                                        <?php echo $icono_caja; ?>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $t_egreso += $row9t['monto'];
                                            }
                                        }
                                        ?>

                                        <?php
                                        //CAJA DETALLE
                                        $t_ingreso = 0;
                                        $sql9 = "SELECT * FROM caja_detalle WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero='$nombre_tercero' AND movimiento='ingreso' AND tipo='normal'";
                                        $query9 = $conn->query($sql9);
                                        if ($query9->num_rows > 0) {
                                            while ($row9 = $query9->fetch_assoc()) {

                                                if ($row9['movimiento'] == 'ingreso') {
                                                    $color_caja = 'text-success';
                                                    $text_caja = 'INGRESO';
                                                    $icono_caja = ' <i class="fas fa-plus-circle text-warning"></i>';
                                                } else {
                                                    $color_caja = 'text-danger';
                                                    $text_caja = 'EGRESO';
                                                    $icono_caja = ' <i class="fas fa-minus-circle text-warning"></i>';
                                                }
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="<?php echo $color_caja; ?>"><?php echo $text_caja; ?></b>
                                                        <b class=""><i class="fas fa-cash-register"></i> | <?php echo $row9['nombre_caja']; ?></b>
                                                    </td>
                                                    <td><b>---- | </b><b class="text-primary">CJ <?php echo $row9['id'] ?></b></td>
                                                    <td> <?php echo $row9['descripcion']; ?></td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row9['monto'], 0); ?> 
                                                        <?php echo $icono_caja; ?>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $t_ingreso += $row9['monto'];
                                            }
                                        }
                                        ?> 

                                        <?php
                                        //CRUCE CUENTA ORIGEN
                                        $t_cruce_origen = 0;
                                        $sql10 = "SELECT * FROM cruce_cuenta WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero_origen='$nombre_tercero'";
                                        $query10 = $conn->query($sql10);
                                        if ($query10->num_rows > 0) {
                                            while ($row10 = $query10->fetch_assoc()) {
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="text-success">CRUCE CUENTA</b>
                                                        <b class=""> | <?php echo $row10['nombre_tercero_origen']; ?>
                                                            <i class="fas fa-random text-success"></i> 
                                                            <?php echo $row10['nombre_tercero_destino']; ?></b>

                                                    </td>
                                                    <td><b>---- | </b><b class="text-primary">CRC <?php echo $row10['id'] ?></b></td>

                                                    <td> <?php echo $row10['descripcion']; ?></td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row10['monto'], 0); ?> 
                                                        <i class="fas fa-plus-circle text-warning"></i>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $t_cruce_origen += $row10['monto'];
                                            }
                                        }
                                        ?>

                                        <?php
                                        //CRUCE CUENTA DESTINO
                                        $t_cruce_destino = 0;
                                        $sql11 = "SELECT * FROM cruce_cuenta WHERE fecha='" . $rowfa['fecha'] . "' AND nombre_tercero_destino='$nombre_tercero'";
                                        $query11 = $conn->query($sql11);
                                        if ($query11->num_rows > 0) {
                                            while ($row11 = $query11->fetch_assoc()) {
                                                ?>
                                                <tr>
                                                    <td>
                                                        <b class="text-danger">CRUCE CUENTA</b>
                                                        <b class=""> | <?php echo $row11['nombre_tercero_origen']; ?>
                                                            <i class="fas fa-random text-danger"></i> 
                                                            <?php echo $row11['nombre_tercero_destino']; ?></b>
                                                    </td>
                                                    <td><b>---- | </b><b class="text-primary">CRC <?php echo $row11['id'] ?></b></td>

                                                    <td> <?php echo $row11['descripcion']; ?></td>
                                                    <td class="text-center">---</td>
                                                    <td class="text-end">
                                                        <?php echo number_format($row11['monto'], 0); ?> 
                                                        <i class="fas fa-minus-circle text-warning"></i>
                                                    </td>
                                                    <td class='text-center'>
                                                        ---
                                                    </td> 
                                                </tr>
                                                <?php
                                                $t_cruce_destino += $row11['monto'];
                                            }
                                        }

                                        $balance = ($t_ventas + $t_cruce_destino + $tarrastre_debe + $t_ventas_redes - $t_ingreso) - ($t_compras + $t_cruce_origen + $t_fletes + $tarrastre_debo - $t_egreso);
                                        ?>

                                        <tr>
                                            <td class="p-1 text-end" colspan="4"><b>BALANCE DIA</b></td>
                                            <td class="p-1 text-end"><b><?php echo number_format($balance, 2); ?></b></td>
                                            <td class="p-1 text-end">
                                                <b class="h5"><?php echo number_format($total_arrastre += $balance, 2); ?></b> 
                                                <i class="fas fa-arrow-down text-info"></i>
                                            </td>
                                        </tr>  



                                        </tbody>

                                        <?php
                                    }
                                }
                                ?>  
                            </table>
                        </div>
                    </div>

                    <?php
                } else {
                    
                }
                ?>




            </div><!-- end col -->
            <!-- end page content-->
        </div>
        <!--end page content wrapper-->

        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

     

    </body>
</html>