<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_caja = $_GET['nombre_caja'];
    $nombre_categoria = $_GET['nombre_categoria'];

    if ($nombre_caja == 'Todos') {
        $sqlcaja = '';
    } else {
        $sqlcaja = " AND nombre_caja='" . $nombre_caja . "' ";
    }

    if ($nombre_categoria == 'Todos') {
        $nombre_categoria = '';
    } else {
        $nombre_categoria = " AND nombre_categoria='" . $nombre_categoria . "' ";
    }


    $sqlfecha = " WHERE fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

    $sql_consult = $sqlfecha . $sqlcaja . $nombre_categoria;
} else {
    $fecha_desde = '';
    $fecha_hasta = '';
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
                <title>Gastos - </title>

        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">


                <nav aria-label="breadcrumb" class="d-print-none">

                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item">Reporte de gastos</li>
                    </ol>


                </nav>


                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded">

                                    <form method="GET" action="rpt-gastos.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Categoria de gastos</label>
                                                    <select class="form-select single-select"  required="" name="nombre_categoria">                                           
                                                        <option selected=""  value="Todos">Todos</option>
                                                        <?php
                                                        $sqlt1 = "SELECT * FROM categoria_gasto";
                                                        $queryt1 = $conn->query($sqlt1);
                                                        if ($queryt1->num_rows > 0) {
                                                            while ($rowt1 = $queryt1->fetch_assoc()) {
                                                                ?>
                                                                <option class="text-sm" value="<?php echo $rowt1['categoria']; ?>"><?php echo $rowt1['categoria']; ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>         
                                                </div>
                                            </div>

                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Cajas</label>
                                                    <select class="form-select single-select"  required="" name="nombre_caja">                                           
                                                        <option selected="" value="Todos">Todos</option>
                                                        <?php
                                                        $sqlt = "SELECT * FROM caja";
                                                        $queryt = $conn->query($sqlt);
                                                        if ($queryt->num_rows > 0) {
                                                            while ($rowt = $queryt->fetch_assoc()) {
                                                                ?>
                                                                <option class="text-sm" value="<?php echo $rowt['nombre']; ?>"><?php echo $rowt['nombre']; ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>         
                                                </div>
                                            </div>


                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card d-print-none">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-4">

                            </div>
                            <div class="col-sm-4">
                                <h6 class=" mb-3 text-center"><b>Gastos <br><?php echo strftime("%d - %B - %Y", strtotime(date($fecha_desde))); ?> <strong class="text-info">al</strong> <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_hasta))); ?></b></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page title -->
                <style>
                    #hover_enlace:hover{
                        color: orange;
                        border-radius: 10px; border: #3fc3ee 1px solid;
                        box-shadow: 0px 0px 5px 0px #3fc3ee;
                    }

                </style>


                <?php
                if (isset($_GET['filtro'])) {
                    ?>



                    <div class="bg-white rounded" style="box-shadow: 0px 0px 5px 1px #C3C3C3;">

                        <div class="d-print-none">
                            <div class="float-end">
                                <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                    <i class="fas fa-print"> Imprimir</i>
                                </a>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div class="p-2 rounded" style="background-color:#F2F2F2 ">
                            <div class="row">
                                <div class="col-sm-12 text-center">



                                </div>
                            </div>
                        </div>

                        <div class="table-responsive rounded mt-3 bg-white p-2">
                            <table  class="table table-striped  table-bordered table-sm table-hover" id="example2">
                                <thead>
                                    <tr class="bg-light-primary text-primary">
                                        <th class="text-center" style="width: 15%; ">Fecha</th>
                                        <th class="text-center">Clasificacion</th>
                                        <th class="text-center" style="width: 30%; ">Descripcion</th>
                                        <th class="text-center">Caja</th>
                                        <th class="text-center bg-warning text-white" >Monto</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $total_gasto = 0;
                                    $sqld3 = "SELECT * FROM gasto  $sql_consult ORDER BY fecha desc";
                                    $queryd3 = $conn->query($sqld3);
                                    if ($queryd3->num_rows > 0) {
                                        while ($rowd3 = $queryd3->fetch_assoc()) {
                                            ?>
                                            <tr>
                                                <td class="text-center"><strong><?php echo $rowd3['fecha']; ?></strong></td>
                                                <td class=""><strong><?php echo $rowd3['nombre_categoria']; ?></strong></td>
                                                <td class=""><?php echo $rowd3['descripcion']; ?></td>
                                                <td class="text-center"><?php echo $rowd3['nombre_caja']; ?></td>
                                                <td class="text-end"><?php echo number_format($rowd3['monto'], 0) ?></td> 
                                            </tr>                              
                                            <?php
                                            $total_gasto += $rowd3['monto'];
                                        }
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr class="h5">
                                        <td class="text-end" colspan="4"><b>TOTAL</b></td>
                                        <td class="text-end"><strong>$ <?php echo number_format($total_gasto, 0); ?></strong></td>
                                    </tr> 
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <?php
                } else {
                    
                }
                ?>
            </div><!-- end col -->
            <!-- end page content-->
        </div>
        <!--end page content wrapper-->

        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                    'pageLength': 50,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>
    </body>
</html>