<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Reporte de ventas por criterios</li>
                        </ol>
                    </nav>

                    <?php
                    if (isset($_POST['filtro'])) {
                        $nombre = $_POST['nombre'];

                        $nombre = trim($nombre);
                    } else {
                        $nombre = '';
                    }
                    ?>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="GET" action="rpt-tallas.php" class=" d-print-none">
                                            <div class="row">
                                                <div class="col-6 col-sm-4">
                                                    <div class="form-group">
                                                        <label>Seleccione la talla a consultar</label>
                                                        <select class="form-select custom-select" id="validationCustom04" required="" name="talla">
                                                            <option selected="" disabled="" value="">Seleccione</option>
                                                            <?php
                                                            for ($i = 4; $i < 23; $i++) {
                                                                ?>
                                                                <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                                <?php
                                                            }
                                                            ?>
                                                        </select>                                                    </div>
                                                </div>
                                                <div class="col-5 col-sm-1 pt-3">
                                                    <div class="form-group">
                                                        <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    if (isset($_GET['filtro'])) {
                        $talla = $_GET['talla'];
                        ?>


                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table align-middle mb-0 table-bordered table-striped" id="example2">
                                                <thead>
                                                    <tr class="bg-tianzi text-dark">
                                                        <th class="text-center" data-priority="1">FOTO</th>
                                                        <th class="text-center">REFERENCIAS</th>
                                                        <th class="text-center">CATEGORIA</th>
                                                        <th class="text-center" data-priority="1">CANTIDAD DISPONIBLE EN TALLA <b class=""><?php echo $talla; ?></b></th>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $sql = "SELECT * FROM producto_disponible WHERE talla='$talla' ORDER BY referencia_producto desc";
                                                    $query = $conn->query($sql);
                                                    if ($query->num_rows > 0) {
                                                        while ($row = $query->fetch_assoc()) {

                                                            $sql1 = "SELECT * FROM producto WHERE referencia='" . $row['referencia_producto'] . "'";
                                                            $query1 = $conn->query($sql1);
                                                            $row1 = $query1->fetch_assoc();

                                                            $disponibilidad = $row['cantidad'];

                                                            if ($disponibilidad > 0) {
                                                                ?>
                                                                <tr> 
                                                                    <td class="text-center">
                                                                        <div class="inbox-item-img "  id="hover_enlace">
                                                                            <?php
                                                                            if ($row1['foto1'] == 'No aplica') {
                                                                                ?>
                                                                                <img src="../../img-producto/camara.jpg"  class="img-thumbnail" alt="" width="50">

                                                                                <?php
                                                                            } else {
                                                                                ?>
                                                                                <a href="javascript:window.open('../../img-producto/<?php echo $row1['foto1']; ?>','','width=1200,height=700,left=100,top=10,toolbar=yes');void 0" >
                                                                                    <img src="../../img-producto/<?php echo $row1['foto1']; ?>" class="img-thumbnail" alt="" width="50">
                                                                                </a>
                                                                                <?php
                                                                            }
                                                                            ?>
                                                                        </div>
                                                                    </td>
                                                                    <td class="text-center"><strong><?php echo $row['referencia_producto']; ?></strong></td>
                                                                    <td class="text-center"><?php echo $row1['nombre_categoria']; ?></td>
                                                                    <td class="text-center text-success" style="background-color: #EFFFEE; font-size: 18px;">
                                                                        <strong><?php echo $disponibilidad; ?></strong>
                                                                    </td>
                                                                </tr>
                                                                <?php
                                                            } elseif ($disponibilidad < 0) {
                                                                
                                                            } else {
                                                                
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    } else {
                        ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <h5> No hay resultados para mostrar</h5>
                            </div>
                        </div>

                        <?php
                    }
                    ?>
                </div>


                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: [ 'excel', 'pdf'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>