<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];
    $estado = $_GET['estado'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Despacho</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> VENTAS POR CLIENTE</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-venta.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="single-select form-control-sm" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>

                                                            <?php
                                                        }



                                                        $sql6m = "SELECT * FROM alm_tercero";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>ESTADO</label>
                                                    <select class="form-control  form-control-sm" name="estado" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($estado != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $estado; ?>"><?php echo $estado; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>
                                                            <?php
                                                        }
                                                        ?>
                                                        <option value="Proceso">Proceso</option>
                                                        <option value="Entregado">Finalizado</option>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">


                        <style>
                            th, td {
                                white-space: nowrap;
                            }

                            div.dataTables_wrapper {
                                width: 100%;
                                margin: 0 auto;
                            }


                        </style>




                        <?php
                        if (isset($_GET['filtro'])) {

                            $fecha_desde = $_GET['fecha_desde'];
                            $fecha_hasta = $_GET['fecha_hasta'];
                            $nombre_tercero = $_GET['nombre_tercero'];

                            if ($nombre_tercero == 'TODO') {
                                $sql_nombre_tercero = "";
                            } else {
                                $sql_nombre_tercero = " AND nombre_tercero='" . $nombre_tercero . "'";
                            }

                            if ($estado == 'TODO') {
                                $sql_estado = "";
                            } else {
                                $sql_estado = " AND estado='" . $estado . "'";
                            }


                            $sql_fecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

                            $sql = $sql_fecha . $sql_nombre_tercero . $sql_estado;
                            ?>
                            <div class=" mt-3">
                                <div class="d-print-none">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <?php
                                if ($nombre_tercero == 'TODO') {
                                    $nit = 'No aplica';
                                } else {
                                    $sqlter = "SELECT * FROM alm_tercero WHERE nombre='$nombre_tercero'";
                                    $queryter = $conn->query($sqlter);
                                    $rowter = $queryter->fetch_assoc();

                                    $nit = $rowter['nit'];
                                }
                                ?>
                                <div class="p-2 rounded">




                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>REPORTE DE VENTAS</b></h6>

                                            <h6 class="text-dark mt-0 mb-1"><b> <?php echo $nombre_tercero; ?></b></h6>  
                                            <h6 class="text-dark mt-0 mb-1"><b>NIT: </b><?php echo $nit; ?></h6> 
                                            <h6 class="text-dark mt-0 mb-0">
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> 
                                                <b class="ms-3 me-3">|</b> 
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>
                                            </h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px;
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>

                                <div class=" mt-2 " style="overflow: auto;"> 
                                    <table class="table  table-striped table-bordered table-sm"  border="1" id="example2" style="width: 100%;">
                                        <thead class="">
                                            <tr class="bg-success text-white">
                                                <th class="text-center" >FECHA</th>
                                                <th class="text-center ">No VENTA</th>
                                                <th class=" ">TERCERO</th>
                                                <th class="text-center">CANT.</th>
                                                <th class="text-center">TOTAL</th>
                                                <th class="text-center">ESTADO</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_pares = 0;
                                            $total_paquetes = 0;
                                            $total = 0;
                                            $sql4 = "SELECT * FROM alm_venta WHERE $sql ORDER BY fecha desc, id desc";
                                            $query4 = $conn->query($sql4);
                                            if ($query4->num_rows > 0) {
                                                while ($row4 = $query4->fetch_assoc()) {

                                                    $sql5 = "SELECT SUM(cantidad) as cantidad FROM alm_venta_detalle WHERE id_venta='" . $row4['id'] . "'";
                                                    $query5 = $conn->query($sql5);
                                                    $row5 = $query5->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle" id="hover_enlace" >
                                                        <td class="text-center">
                                                            <b><?php echo date('d-m-Y', strtotime($row4['fecha'])); ?></b>
                                                        </td>

                                                        <td class="text-center">
                                                            <b><?php echo $row4['numero_venta']; ?></b>
                                                        </td>
                                                        <td class="" style="">
            <?php echo $row4['nombre_tercero']; ?>
                                                        </td>  
                                                        <td class="text-center">
            <?php echo number_format($row5['cantidad']); ?>
                                                        </td>
                                                        <td class="text-end">
                                                            <b class="float-start">$</b>  <b><?php echo number_format($row4['total_venta'], 0); ?></b>
                                                        </td>
                                                        <td class="text-center">
            <?php
            if ($row4['estado'] == 'Proceso') {
                $alert_text = 'text-white';
                $alert = 'bg-info';
            } elseif ($row4['estado'] == 'Confirmado') {
                $alert_text = 'text-white';
                $alert = 'bg-pink';
            } elseif ($row4['estado'] == 'Alistamiento') {
                $alert_text = 'text-white';
                $alert = 'bg-primary';
            } elseif ($row4['estado'] == 'Enviado') {
                $alert_text = 'text-white';
                $alert = 'bg-warning';
            } elseif ($row4['estado'] == 'Novedad') {
                $alert_text = 'text-white';
                $alert = 'bg-bronze';
            } elseif ($row4['estado'] == 'Entregado') {
                $alert_text = 'text-white';
                $alert = 'bg-success';
            } elseif ($row4['estado'] == 'Finalizado') {
                $alert_text = 'text-white';
                $alert = 'bg-primary';
            } elseif ($row4['estado'] == 'Cancelado') {
                $alert_text = 'text-white';
                $alert = 'bg-secondary';
            } elseif ($row4['estado'] == 'Devolucion') {
                $alert_text = 'text-white';
                $alert = 'bg-dark';
            } else {
                $text = 'text-dark';
            }
            ?>
                                                            <span class="badge <?php echo $alert; ?>"><?php echo $row4['estado']; ?></span>

                                                        </td>
                                                    </tr>
            <?php
            $total_pares += $row5['cantidad'];
            $total += $row4['total_venta'];
        }
    }
    ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-light-dark">
                                                <td colspan="3"></td>
                                                <td class="text-center"><b><?php echo number_format($total_pares, 0); ?></b></td>
                                                <td class="text-end"><b class="float-start">$</b><b><?php echo number_format($total, 0); ?></b></td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                </div>



                            </div>
    <?php
} else {
    
}
?>


                    </div>
                </div>
            </div>

        </div>


<?php echo include '../general/libreria-js.php'; ?>
        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    paging: false,
                    lengthChange: false,
                    "columnDefs": [
                        {"orderable": false, "targets": "_all"}, // Desactiva ordenamiento para todas las columnas
                    ],

                    order: [[3, 'desc']],

                    buttons: [
                        {
                            extend: 'excel',
                            text: 'EXCEL',
                            filename: 'PEDIDO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            filename: 'PEDIDO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        }
                    ],

                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


    </body>
</html>