<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Inicio</li>
                        </ol>
                    </nav>

                    <style>
                        .loader {
                            border: 16px solid #f3f3f3; /* Light grey */
                            border-top: 16px solid #3498db; /* Blue */
                            border-radius: 50%;
                            width: 120px;
                            height: 120px;
                            animation: spin 2s linear infinite;
                            display: none;
                            margin: auto
                        }

                        @keyframes spin {
                            0% { transform: rotate(0deg); }
                            100% { transform: rotate(360deg); }
                        }

                    </style>

                    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>

                    <div class="card radius-10 w-100">
                        <div class="card-body text-center">

                            <?php
                            $sql = "SELECT COUNT(id) as contar FROM producto";
                            $query = $conn->query($sql);
                            $row = $query->fetch_assoc();
                            ?>
                            <div class="text-center" style="font-size: 20px;">
                                <span>SE ENCONTRARON <b><?php echo $row['contar']; ?> PRODUCTOS</b> PARA SINCRONIZAR</span>
                            </div>

                            <br>
                            <div class="text-center">
                                <a href="script/sincronizar.php" class="btn btn-tianzi radius-30 px-5 " id="btn">CONTINUAR</a>
                            </div>
                            <br>
                            <br>
                            <div class="text-center">
                                <div class="data text-center"></div>
                                <div class="loader text-center"></div> 
                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>

            <?php echo include '../general/libreria-js.php'; ?>

            <script>

                $(document).ready(function () {
                    var $btn = $('#btn');
                    var $data = $('.data');
                    var $loader = $('.loader');


                    $btn.click(function () {

                        $.ajax({
                            // ejemplo url
                            url: 'script/sincronizar.php',
                            method: 'GET',
                            beforeSend: function () {
                                // aquí puedes poner el código para que te muestre el gif
                                $data.html("");
                                $loader.show();
                            }
                        }).done(function (resp) {
                            setTimeout(function () {
                                $loader.hide();
                                $data.html(resp[0].about);
                            }, 5000);
                        }).fail(function (err) {
                            $loader.hide();
                            alert(err);
                        })
                        return;
                    });

                });
            </script>

    </body>
</html>