<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Terceros</li>
                        </ol>
                    </nav>





                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">NUEVO TERCERO</h6>
                                    <hr/>

                                    <form class="row g-3 needs-validation" method="POST" action="script/tercero-guardar.php">
                                        <div class="col-md-4">
                                            <label>Nit</label>
                                            <input class="form-control" type="text" required="" name="nit" value="Opcional">
                                        </div>
                                        <div class="col-md-8">
                                            <label>Nombre</label>
                                            <input class="form-control" type="text"  required="" name="nombre">
                                        </div>
                                        <div class="col-md-4">
                                            <label>Telefono</label>
                                            <input class="form-control" type="text"  required="" name="telefono">
                                        </div>
                                        <div class="col-md-8">
                                            <label>Direccion</label>
                                            <input class="form-control" type="text"  required="" name="direccion">
                                        </div>
                                        <div class="col-md-12 text-end">
                                            <button type="submit" class="btn btn-success px-5 radius-30" >Guardar</button>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Lista de terceros</h6>
                                    <hr/>
                                    <div class="table-responsive mt-2">
                                        <table class="table table-bordered table-striped table-hover" id="example2">
                                            <thead class="">
                                                <tr class="bg-tianzi text-dark">
                                                    <th class="text-center">Nit</th>
                                                    <th class="">Nombre</th>
                                                    <th class="">Telefono</th>
                                                    <th class="">Direccion</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql = "SELECT * FROM alm_tercero";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr>
                                                            <td><?php echo $row['nit']; ?></td>
                                                            <td class=""><strong><?php echo $row['nombre']; ?></strong></td>
                                                            <td class=""><?php echo $row['telefono']; ?></td>

                                                            <td class=""><?php echo $row['direccion']; ?></td>
                                                            <td class="text-center">
                                                                <a  href="#editar"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#editar<?php echo $row['id']; ?>">
                                                                    <i class="far fa-edit text-warning"></i>
                                                                </a>

                                                                <div class="modal fade text-start" id="editar<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-warning text-white">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">EDITAR TERCERO</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class="" method="POST" action="script/tercero-editar.php">
                                                                                <input class="form-control" type="text" required="" name="id" value="<?php echo $row['id']; ?>" hidden="">

                                                                                <div class="modal-body ">
                                                                                    <div class="row ">
                                                                                        <div class="col-md-4 mb-3">
                                                                                            <label>Nit</label>
                                                                                            <input class="form-control" type="text" required="" name="nit" value="<?php echo $row['nit']; ?>">
                                                                                        </div>
                                                                                        <div class="col-md-8 mb-3">
                                                                                            <label>Nombre</label>
                                                                                            <input class="form-control" type="text"  required="" name="nombre" value="<?php echo $row['nombre']; ?>" >
                                                                                        </div>

                                                                                        <div class="col-md-4 mb-3">
                                                                                            <label>Telefono</label>
                                                                                            <input class="form-control" type="text"  required="" name="telefono" value="<?php echo $row['telefono']; ?>">
                                                                                        </div>
                                                                                        <div class="col-md-8 mb-3">
                                                                                            <label>Direccion</label>
                                                                                            <input class="form-control" type="text"  required="" name="direccion" value="<?php echo $row['direccion']; ?>">
                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="submit" class="btn btn-warning  radius-30" name="editar" >Guardar cambios</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>




                                                                <a href="#" class="ms-4" 
                                                                   data-bs-toggle="modal" data-bs-target="#eliminar<?php echo $row['id']; ?>">
                                                                    <i class="far fa-trash-alt opacity-5 text-danger"></i>
                                                                </a>

                                                                <div class="modal fade" id="eliminar<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-sm">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-danger">
                                                                                <h5 class="modal-title card-heading text-white" id="exampleModalLabel">Eliminar</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/tercero-eliminar.php">
                                                                                <input class="form-control" type="text" required="" name="id" value="<?php echo $row['id']; ?>" hidden>
                                                                                <div class="modal-body ">
                                                                                    ¿Seguro deseas eliminar este registro?

                                                                                </div>
                                                                                <div class="modal-footer ">
                                                                                    <button type="submit" class="btn btn-danger" name="eliminar" >Eliminar</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>



                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>