<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Terceros</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body text-center">
                            <h3><b>CIERRE</b></h3>
                            <span><b>Mercancia enviada de mas.</b></span>
                        </div>
                    </div>



                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase"></h6>
                            <hr/>
                            <div class=" mt-2" style="overflow: auto">
                                <table class="table align-middle table-hover table-striped mb-0" id="example2" style="width: 100%; font-size: 14px;">
                                    <thead>
                                        <tr class="bg-gradient-info text-white">
                                            <th class="">NOMBRE</th>
                                            <th class="text-center">DESPACHADO DE MAS</th>
                                            <th class="text-center">DETALLE</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT nombre_tercero FROM despacho 
                                                UNION
                                                SELECT nombre_tercero FROM pedido 
                                                UNION
                                                SELECT nombre_tercero FROM cierre_detalle 
                                                UNION
                                                SELECT nombre_tercero FROM referencia_cierre GROUP BY nombre_tercero ORDER BY nombre_tercero asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {

                                                $sql1 = "SELECT SUM(cantidad) as cantidad FROM referencia_cierre WHERE nombre_tercero='" . $row['nombre_tercero'] . "'";
                                                $query1 = $conn->query($sql1);
                                                $row1 = $query1->fetch_assoc();
                                                ?>


                                                <tr>
                                                    <td class=""><strong><?php echo $row['nombre_tercero']; ?></strong></td>
                                                    <td class="text-center">
                                                        <?php echo number_format($row1['cantidad'], 0); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="cierre-tercero.php?nombre_tercero=<?php echo $row['nombre_tercero']; ?>">
                                                            <i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="text-center mt-5">
                                <a href="sincronizar-tercero.php" class="btn btn-primary radius-30 px-5 ">SINCORNIZAR</a>
                            </div>

                        </div>
                    </div>



                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Editar tercero</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/tercero-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id" id="edit_id" hidden>
                        <div class="modal-body ">
                            <div class="row">
                                <div class="col-md-3 mt-2">
                                    <label>Nit</label>
                                    <input class="form-control" type="text" required="" name="edit_nit" id="edit_nit">
                                </div>
                                <div class="col-md-6 mt-2">
                                    <label>Nombre</label>
                                    <input class="form-control" type="text"  required="" name="edit_nombre" id="edit_nombre">
                                </div>
                                <div class="col-md-3 mt-2">
                                    <label>Telefono</label>
                                    <input class="form-control" type="text"  required="" name="edit_telefono" id="edit_telefono">
                                </div>
                                <div class="col-md-5 mt-2">
                                    <label>Correo</label>
                                    <input class="form-control" type="text"  required="" name="edit_correo" id="edit_correo">
                                </div>
                                <div class="col-md-7 mt-2">
                                    <label>Ubicacion</label>
                                    <input class="form-control" type="text"  required="" name="edit_ubicacion" id="edit_ubicacion">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Tipo</label>
                                    <select class="form-select"  required="" name="edit_tipo" id="edit_tipo">
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <option value="General">General</option>
                                        <option value="Cliente">Cliente</option>
                                        <option value="Proveedor">Proveedor</option>
                                        <option value="Empleado">Empleado</option>
                                    </select>
                                </div>
                                <div class="col-md-8 mt-2">
                                    <label>Direccion</label>
                                    <input class="form-control" type="text"  required="" name="edit_direccion" id="edit_direccion">
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger px-5 radius-30" name="eliminar" 
                                    onclick="if (!confirm('Seguro deseas eliminar este registro?')) {
                                                return false

                                            }">Eliminar</button>
                            <button type="submit" class="btn btn-warning px-5 radius-30" name="editar" >Editar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var nit = button.data('nit')
                var nombre = button.data('nombre')
                var telefono = button.data('telefono')
                var correo = button.data('correo')
                var ubicacion = button.data('ubicacion')
                var direccion = button.data('direccion')
                var tipo = button.data('tipo')

                $('#edit_id').val(id)
                $('#edit_nit').val(nit)
                $('#edit_nombre').val(nombre)
                $('#edit_telefono').val(telefono)
                $('#edit_correo').val(correo)
                $('#edit_ubicacion').val(ubicacion)
                $('#edit_direccion').val(direccion)
                $('#edit_tipo').val(tipo)
            });
        </script>
        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": [[1, 'asc']],
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>