<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Color</li>
                        </ol>
                    </nav>





                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">

                                </div>
                                <div class="col-sm-4 text-center">
                                    <h3><b>COLOR</b></h3>

                                </div>
                                <div class="col-sm-4 text-end">
                                    <a href="#!" class="btn btn-primary px-5 radius-30"  data-bs-toggle="modal" data-bs-target="#exampleModal" autofocus>
                                        Nuevo color
                                    </a> 
                                </div>
                            </div>




                            <!-- Modal -->
                            <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-sm">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title card-heading" id="exampleModalLabel">Registro de color</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/color-guardar.php">

                                            <div class="modal-body ">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <label class="form-label" for="validationCustom01">Color</label>
                                                        <input class="form-control" id="validationCustom01" type="text" required="" name="color">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, digite un color.</div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <label class="form-label" for="validationCustom01">Rgb</label>
                                                        <input class="form-control" id="validationCustom01" type="color" required="" name="rgb">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, digite un color.</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                <button type="submit" class="btn btn-success" >Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>


                    <div class="row">
                        <div class="col-sm-3"></div>
                        <div class="col-sm-6">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Lista | Colores</h6>
                                    <hr/>
                                    <div class="table-responsive mt-2">
                                        <table class="table align-middle table-hover table-striped mb-0" id="example2" style="width: 100%;">
                                            <thead>
                                                <tr class="bg-light-primary text-primary">
                                                    <th class="text-center">Nombre color</th>
                                                    <th class="text-center">RGB</th>
                                                    <th class="text-center">Vista previa</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql = "SELECT * FROM color";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td class="" style="min-width: 125px;">
                                                                <strong><?php echo $row['color']; ?></strong>
                                                            </td>
                                                            <td class="">
                                                                <strong><?php echo $row['rgb']; ?></strong>
                                                            </td>
                                                            <td class="text-center" >
                                                                <i class="fa-solid fa-circle fa-3x" style="color: <?php echo $row['rgb']; ?>"></i>
                                                            </td>
                                                            <td class="text-center" style="max-width: 120px">
                                                                <a class="" style="margin-right: 12px;"  href="#!" data-bs-toggle="modal" data-bs-target="#editar"
                                                                   data-id="<?php echo $row['id']; ?>"
                                                                   data-color="<?php echo $row['color']; ?>"
                                                                   data-rgb="<?php echo $row['rgb']; ?>">
                                                                    <i class="far fa-edit opacity-5 text-primary fa-2x"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Editar color</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/color-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id" id="edit_id" hidden>
                        <div class="modal-body ">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label class="form-label" for="validationCustom01">Color</label>
                                    <input class="form-control" type="text" required="" name="edit_color" id="edit_color">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, digite un color.</div>
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label" for="validationCustom01">Rgb</label>
                                    <input class="form-control" type="color" required="" name="edit_rgb" id="edit_rgb">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, digite un color.</div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger" name="eliminar" 
                                    onclick="if (!confirm('Seguro deseas eliminar este registro?')) {
                                                return false

                                            }">Eliminar</button>  
                            <button type="submit" name="editar"  class="btn btn-warning" >Editar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <script>




            // PASO DE PARAMETROS EDITAR
            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var color = button.data('color')
                var rgb = button.data('rgb')

                $('#edit_id').val(id)
                $('#edit_color').val(color)
                $('#edit_rgb').val(rgb)
            });


            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>