
<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <div class="card-body d-print-none">

            <nav aria-label="breadcrumb" class="d-print-none">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="../inicio/inicio.php"> 
                            <ion-icon name="home-outline"></ion-icon>
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="consultar.php"> 
                            Consultar
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="confirmacion.php"> 
                            Confirmar
                        </a>
                    </li>
                    <li class="breadcrumb-item active">                     
                        Impresion
                    </li> 
                </ol>
            </nav>

            <style>
                #hover_enlace:hover{
                    color: orange;
                    border-radius: 10px; border: #3fc3ee 1px solid;
                    box-shadow: 0px 0px 5px 0px #3fc3ee;
                }

            </style>

            <div class="card bg-gradient-warning">
                <div class="card-body">

                    <h3 class=""><b class="">PEDIDOS</b> <b class="float-end">PANEL DE IMPRESION</b></h3>
                </div>
            </div>

            <div class="row d-print-none">
                <div class="col-sm-8 ">
                </div>
                <?php
                if (isset($_GET['venta_hoja'])) {
                    $venta_hoja = $_GET['venta_hoja'];
                } else {
                    $venta_hoja = 3;
                }
                ?>



                <div class="col-sm-3 fa-3x text-end">

                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">ventas por hoja</button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item" href="impresion.php?venta_hoja=2">2</a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="impresion.php?venta_hoja=3">3</a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="impresion.php?venta_hoja=4">4</a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="impresion.php?venta_hoja=5">5</a>
                            </li>
                        </ul>
                    </div>


                </div>



                <div class="col-sm-1 fa-3x text-end">
                    <div class="d-print-none">
                        <div class="float-right">
                            <a href="javascript:window.print()" class="btn btn-dark waves-effect waves-light"><i class="fas fa-print"></i></a>
                        </div>
                        <div class="clearfix"></div>
                    </div>

                </div>
            </div>



            <hr class=" d-print-none" style="border-top: 2px dotted orange;">
            <div class="row mb-2 d-print-none">
                <div class="col-sm-4">
                    <a href="consultar.php">
                        <div class="alert alert-success fade show mb-0 ">
                            <strong class="alert-heading">PASO 1:</strong> Selecionar ventas a imprimir.
                        </div>
                    </a>
                </div>
                <div class="col-sm-4">
                    <a href="confirmacion.php">
                        <div class="alert alert-success fade show mb-0 ">
                            <strong class="alert-heading">PASO 2:</strong> Confirmar ventas a imprimir.
                        </div>
                    </a>
                </div>
                <div class="col-sm-4">
                    <a href="#">
                        <div class="alert alert-success fade show mb-0 ">
                            <strong class="alert-heading">PASO 3:</strong> Imprimir ventas seleccionadas.
                        </div>
                    </a>
                </div>
            </div>



        </div>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                // Invocamos cada 5 segundos ;)
                const milisegundos = 5 * 1000;
                setInterval(function () {
                    // No esperamos la respuesta de la petición porque no nos importa
                    fetch("../general/refresh.php");
                }, milisegundos);
            });
        </script>

        <section class="mb-3 mb-lg-5 ">


            <div class="card-box">


                <?php
//////////////////////

                $contar = 0;
                $sql = "SELECT * FROM pedido WHERE panel_impresion='Si' ORDER BY fecha desc";
                $query = $conn->query($sql);
                if ($query->num_rows > 0) {
                    while ($row = $query->fetch_assoc()) {

                        $sqlp = "SELECT * FROM tercero WHERE nombre='" . $row['nombre_tercero'] . "'";
                        $queryp = $conn->query($sqlp);
                        $rowp = $queryp->fetch_assoc();
                        ?>
                        <div class="card card-table mb-2 p-2">
                            <div class="card-body mb-0 "  >

                                <div class="row">
                                    <div class="col-sm-8">

                                    </div>
                                    <div class="col-sm-4 text-end">
                                        <a href="script/impresion-quitar.php?id_pedido=<?php echo $row['id']; ?>"
                                           class="text-dark d-print-none ">

                                            <strong class="text-danger">
                                                Quitar
                                            </strong>
                                        </a>
                                    </div>
                                </div>


                                <div class="row p-2 ">
                                    <div class="col-sm-12">
                                        <div class="row bg-light-warning p-0 h6" style="" >
                                            <div class="col-sm-3" >
                                                <strong class="text-uppercase ">ORDEN DE PEDIDO :  
                                                    <strong class="text-body text-primary" >ODP <?php echo $row['id']; ?></strong>
                                                </strong>
                                            </div>
                                            <div class="col-sm-5">
                                                <strong class="text-uppercase " style="color: black;">QUIEN REGISTRA:  
                                                    <strong class="text-body " style="color: gray"><?php echo $row['nombre_usuario']; ?></strong>
                                                </strong>
                                            </div>
                                            <div class="col-sm-2 text-end" >

                                            </div>

                                            <div class="col-sm-2 text-end">
                                                <strong class="text-uppercase ">  
                                                    <?php echo $row['fecha']; ?>
                                                </strong>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive  mb-0">

                                    <table class="table  table-sm table-striped table-bordered">
                                        <thead>
                                            <tr class="bg-gradient-warning text-dark" style="border-color: black;">
                                                <th class="text-center p-0 " style="width: 5%;">INNOVASUELAS</th>
                                                <th class="text-center p-0 " style="width: 30%;">DATOS DE PEDIDO</th>
                                                <th class="text-center p-0 " style="width: 30%;">OBSERVACION</th>
                                                <th class="text-center p-0 " style="width: 5%;">No PEDIDO</th>         
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="border-color: black;">
                                                <td class="text-center">
                                                    <img src="../../img/logo.png" width="60" height="" alt="alt"/>
                                                </td>
                                                <td>

                                                    <span class="text-dark">CLIENTE:</span> <mark><b><?php echo $row['nombre_tercero']; ?></b></mark><br>
                                                    <span class="text-dark">TEL:</span> <mark><b><?php echo $rowp['telefono']; ?></b></mark><br>
                                                </td>
                                                <td>
                                                    <mark><?php echo $row['observacion']; ?></mark>
                                                </td>
                                                <td class="align-middle text-center"> 
                                                    <h3><b><?php echo $row['numero_pedido']; ?></b></h3>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>


                                <style>
                                    .ancho{
                                        width: 3%;
                                        text-align: center;
                                    }

                                    #hover_enlace:hover{
                                        color: orange;
                                        border-radius: 10px; border: lightcoral 1px solid;
                                        box-shadow: 0px 0px 5px 0px lightcoral;
                                    }


                                </style>
                                <div class="table-responsive mt-0">

                                    <table class="table table-hover text-sm table-sm table-striped table-bordered">
                                        <thead>

                                            <tr class="bg-gradient-warning text-dark">
                                                <th class=" p-1 " style="width: 5%;" >FOTO</th>
                                                <th class=" p-1 " style="width: 12%;" >REFERENCIA</th>
                                                <th class="text-center p-1 "  style="width: 6%;" >CATEGORIA</th>
                                                <th class="text-center p-1 "  style="width: 5%;" >COLOR</th>

                                                <?php
                                                $item = 0;
                                                $sqlt1 = "SELECT * FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "' GROUP BY talla ORDER BY talla asc";
                                                $queryt1 = $conn->query($sqlt1);
                                                if ($queryt1->num_rows > 0) {
                                                    while ($rowt1 = $queryt1->fetch_assoc()) {
                                                        ?>
                                                        <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                                        <?php
                                                        $item++;
                                                    }
                                                }
                                                ?>
                                                <th class="text-center p-1" style="width: 5%;">T. Prda</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_cantidad = 0;
                                            $total_venta = 0;
                                            $sql1 = "SELECT * FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "' GROUP BY referencia_producto";
                                            $query1 = $conn->query($sql1);
                                            if ($query1->num_rows > 0) {
                                                while ($row1 = $query1->fetch_assoc()) {

                                                    $sql2 = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                                    $query2 = $conn->query($sql2);
                                                    $row2 = $query2->fetch_assoc();

                                                    ////CANTIDAD POR REFERENCIA
                                                    $sqlCANT = "SELECT SUM(cantidad) as cantidad_referencia FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "' AND referencia_producto='" . $row1['referencia_producto'] . "'";
                                                    $queryCANT = $conn->query($sqlCANT);
                                                    $rowCANT = $queryCANT->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td class="text-center"> 
                                                            <?php
                                                            if ($row2['foto1'] == 'NO APLICA') {
                                                                ?>
                                                            <img class="img-thumbnail" src="../../img/camara.jpg" width="40" alt="alt"/>
                                                                <?php
                                                            } else {
                                                                ?>
                                                                <img class="" src="../../img-producto/<?php echo $row2['foto1']; ?>" width="40" height="40" alt="alt"/>
                                                                <?php
                                                            }
                                                            ?>
                                                        </td>
                                                        <td> 
                                                            <strong class="text-dark"><?php echo $row2['referencia']; ?></strong>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="text-muted text-sm"><?php echo $row2['categoria']; ?></span><br>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="text-muted text-sm"><?php echo $row2['color']; ?></span><br>
                                                        </td>

                                                        <?php
                                                        $queryt2 = $conn->query($sqlt1);
                                                        if ($queryt2->num_rows > 0) {
                                                            while ($rowt2 = $queryt2->fetch_assoc()) {

                                                                $sqlt4 = "SELECT SUM(cantidad) as suma_talla FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "' AND referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $rowt2['talla'] . "'";
                                                                $queryt4 = $conn->query($sqlt4);
                                                                $rowt4 = $queryt4->fetch_assoc();

                                                                $suma_talla = $rowt4['suma_talla'];
                                                                ?>
                                                                <td class="ancho">
                                                                    <b><?php echo $suma_talla; ?></b>
                                                                </td>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                        <td class="text-center">
                                                            <h6>
                                                                <b><?php echo $rowCANT['cantidad_referencia']; ?></b>
                                                            </h6>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $total_cantidad += $rowCANT['cantidad_referencia'];
                                                }
                                            }
                                            ?>


                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-light-dark">
                                                <th colspan="<?php echo $item + 4; ?>" class="text-end">TOTAL</th>                                                                          
                                                <th colspan="3" class="text-center"><?php echo $total_cantidad; ?></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>    

                        <hr class="mt-0 mb-0 bg-white" style="border-top: 2px dotted orangered;">


                    <?php
                    $contar++;

                    if ($contar == $venta_hoja) {
                        ?>
                        <div class="saltopagina"></div>
                        <?php
                    } else {
                        
                    }
                }
            }
            ?>
        </div>
    </section>


    <style>

        @media print{
            div.saltopagina{
                display:block;
                page-break-before:always;
            }
        }


    </style>

<?php echo include '../general/libreria-js.php'; ?>

</body>
</html>

