<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['year'])) {
    $year = $_GET['year'];
} else {
    $year = date('Y');
}

include './recaudo-grafico-mes.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Inicio</li>
                        </ol>
                    </nav>

                    <div class="row">
                        <div class="col-12 col-sm-9">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-warning">
                                                <a href="../pedido/pedido.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fa-solid fa-file-lines"></i>
                                                            </div>
                                                            <h5 class="mb-0">Pedidos</h5>
                                                            <?php
                                                            $sql = "SELECT COUNT(id) as contar_pedido FROM pedido";
                                                            $query = $conn->query($sql);
                                                            $row = $query->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row['contar_pedido'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-info">
                                                <a href="../despacho/despacho.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fa-solid fa-truck-fast"></i>
                                                            </div>
                                                            <h5 class="mb-0">Despachos</h5>
                                                            <?php
                                                            $sql1 = "SELECT COUNT(id) as contar_despacho FROM despacho";
                                                            $query1 = $conn->query($sql1);
                                                            $row1 = $query1->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row1['contar_despacho'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-success">
                                                <a href="../inventario/inventario.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fa-solid fa-box-open"></i>
                                                            </div>
                                                            <h5 class="mb-0">Inventario</h5>
                                                            <?php
                                                            $sql2 = "SELECT SUM(cantidad) as suma_disponible FROM referencia_disponible";
                                                            $query2 = $conn->query($sql2);
                                                            $row2 = $query2->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row2['suma_disponible'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-danger">
                                                <a href="../tercero/tercero.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <ion-icon name="people"></ion-icon>
                                                            </div>
                                                            <h5 class="mb-0">Terceros</h5>
                                                            <?php
                                                            $sql3 = "SELECT COUNT(id) as contar_tercero FROM tercero";
                                                            $query3 = $conn->query($sql3);
                                                            $row3 = $query3->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row3['contar_tercero'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-royal">
                                                <a href="../producto/producto.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="fab fa-product-hunt"></i>
                                                            </div>
                                                            <h5 class="mb-0">Productos</h5>

                                                            <?php
                                                            $sql4 = "SELECT COUNT(id) as contar_productos FROM producto";
                                                            $query4 = $conn->query($sql4);
                                                            $row4 = $query4->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row4['contar_productos'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="col-sm-4 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="../produccion/produccion-panel.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">Produccion</h5>
                                                            <?php
                                                            $sql5 = "SELECT SUM(rp.cantidad) as suma_produccion FROM referencia_produccion rp, producto p
                                                             WHERE p.referencia=rp.referencia_producto  AND p.bloqueo='No'";
                                                            $query5 = $conn->query($sql5);
                                                            $row5 = $query5->fetch_assoc();
                                                            ?>
                                                            <div class="ms-auto"><?php echo number_format($row5['suma_produccion'], 0); ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>                                                                       
                                </div>
                            </div>




                            <div class="row">
                                <div class="col-sm-6 mt-2">
                                    <div class="card radius-10 w-100">
                                        <div class="card-body" style="height: 730px;">
                                            <h6><b>Produccion de <?php echo ucfirst(strftime("%B", strtotime(date("F")))); ?></b> </h6>

                                            <hr>
                                            <span><i class="fa-solid fa-boxes-stacked"></i> | Acumulado del mes por empleado</span><br>
                                            <span><i class="fa-solid fa-flag-checkered"></i> | Meta del mes: <?php echo number_format($meta, 0); ?> pares</span>
                                            <br>
                                            <br>


                                            <div class="overflow-auto"  style="height: 500px; ">



                                                <?php
                                                $total_monto = 0;
                                                $total_ordenes = 0;
                                                $total_prendas = 0;

                                                $fecha_desde = date('Y-m-01');
                                                $fecha_hasta = date('Y-m-t');

                                                $sql7 = "SELECT * FROM tercero WHERE tipo='Empleado'";
                                                $query7 = $conn->query($sql7);
                                                if ($query7->num_rows > 0) {
                                                    while ($row7 = $query7->fetch_assoc()) {

                                                        $nombre_tercero = $row7['nombre'];

                                                        $sql8 = "SELECT SUM(pd.cantidad) as total_produccion "
                                                                . "FROM produccion p, produccion_detalle pd "
                                                                . "WHERE p.id=pd.id_produccion AND MONTH(p.fecha)='" . date("m") . "' AND "
                                                                . "(p.nombre_tercero_1='$nombre_tercero' OR p.nombre_tercero_2='$nombre_tercero' OR p.nombre_tercero_3='$nombre_tercero')";
                                                        $query8 = $conn->query($sql8);
                                                        $row8 = $query8->fetch_assoc();

                                                        $sql9 = "SELECT COUNT(id) as contar_produccion "
                                                                . "FROM produccion "
                                                                . "WHERE  MONTH(fecha)='" . date("m") . "' AND "
                                                                . "(nombre_tercero_1='$nombre_tercero' OR nombre_tercero_2='$nombre_tercero' OR nombre_tercero_3='$nombre_tercero')";
                                                        $query9 = $conn->query($sql9);
                                                        $row9 = $query9->fetch_assoc();

                                                        if ($row8['total_produccion'] <= 0) {
                                                            $porcentaje1 = 0;
                                                        } else {
                                                            $porcentaje1 = 100 / ($meta / $row8['total_produccion']);
                                                        }




                                                        $porcentaje1 = number_format($porcentaje1, 1);

                                                        if ($porcentaje1 > 0 && $porcentaje1 < 20) {
                                                            $porcentaje_color = 'bg-danger';
                                                        } elseif ($porcentaje1 > 19 && $porcentaje1 < 80) {
                                                            $porcentaje_color = 'bg-warning';
                                                        } elseif ($porcentaje1 > 79 && $porcentaje1 < 100) {
                                                            $porcentaje_color = 'bg-info';
                                                        } elseif ($porcentaje1 > 99) {
                                                            $porcentaje_color = 'bg-success';
                                                        }
                                                        ?>

                                                        <style>
                                                            #panel_estado_progreso:hover{
                                                                border-radius: 10px; border: #8ab0e9 2px solid;
                                                            }

                                                        </style>


                                                        <div class = "p-2" id = "panel_estado_progreso">
                                                            <a href = "rpt-empleado.php?empleado=<?php echo $row7['nombre']; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>" >
                                                                <div class = "card radius-10 shadow-none mb-0 text-dark" >
                                                                    <div class = "d-flex align-items-center gap-3">

                                                                        <h6 class = "mb-0"><strong><?php echo $row7['nombre']; ?></strong></h6>
                                                                        <div class="ms-auto"><b> <?php echo number_format($row8['total_produccion']); ?> </b><b class="text-secondary"> | Pares</b></div>
                                                                    </div>
                                                                    <span class="text-secondary " style="font-size: 12px;">Ordenes de produccion <b><?php echo $row9['contar_produccion']; ?></b> </span>
                                                                    <div class="progress">
                                                                        <div class="progress-bar progress-bar-striped progress-bar-animated <?php echo $porcentaje_color; ?>" role="progressbar" style="width: <?php echo $porcentaje1; ?>%;" aria-valuenow="<?php echo $porcentaje1; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $porcentaje1; ?>%</div>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                        <hr>




                                                        <?php
                                                        $total_monto += $row8['total_produccion'];
                                                        $total_ordenes += $row9['contar_produccion'];
                                                    }
                                                }
                                                ?>
                                            </div>         

                                            <div class="inbox-item mt-3 p-2" id="hover_enlace" style="font-size: 12px;">
                                                <div class="row mb-0">
                                                    <div class="col-7">
                                                        <p class="inbox-item-text"><?php echo $total_ordenes; ?> Ordenes </p>

                                                    </div>
                                                    <div class="col-5 text-end">
                                                    </div>
                                                </div>
                                            </div>




                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-6 mt-2">
                                    <div class="card radius-10 w-100">
                                        <div class="card-body "  style="height: 730px;">
                                            <style>
                                                #hover_enlace:hover{
                                                    box-shadow: 0px 0px 20px 0px #3C3D6B;
                                                }

                                            </style>


                                            <h6><b>En produccion </b> </h6>

                                            <hr>

                                            <div class="overflow-auto"  style="height: 650px; ">

                                                <?php
                                                $sqlp1 = "SELECT * FROM orden_sugerencia WHERE estado='Confirmado'";
                                                $queryp1 = $conn->query($sqlp1);
                                                if ($queryp1->num_rows > 0) {
                                                    while ($rowp1 = $queryp1->fetch_assoc()) {

                                                        $sqlp2 = "SELECT * FROM orden_trabajo WHERE id='" . $rowp1['id_orden_trabajo'] . "'";
                                                        $queryp2 = $conn->query($sqlp2);
                                                        $rowp2 = $queryp2->fetch_assoc();
                                                        ?>
                                                        <div class="card radius-10  mb-0 " style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">
                                                            <a href="orden_trabajo_detalle.php?id_orden_trabajo=<?php echo $rowp1['id_orden_trabajo']; ?>" id="hover_enlace" style="border-radius: 15px;">
                                                                <div class="card-body ">
                                                                    <div class="d-flex align-items-center gap-3">
                                                                        <h6 class="mb-0 text-dark"><?php echo $rowp2['nombre_maquina']; ?></h6>
                                                                        <div class="ms-auto"> <b><?php echo $rowp2['numero_orden_trabajo']; ?></b></div>
                                                                    </div>

                                                                    <hr class="">

                                                                    <ul class="list-unstyled mb-0 categories-list">
                                                                        <li>
                                                                            <span> 
                                                                                <b class='text-secondary'>Hora inicio</b>
                                                                                <span class="float-end badge rounded-pill bg-primary"><?php echo date("H:i:s A", strtotime($rowp2['hora_desde'])); ?></span>
                                                                            </span>
                                                                        </li>
                                                                        <li>
                                                                            <span> 
                                                                                <b class='text-secondary'>Hora fin</b>
                                                                                <span class="float-end badge rounded-pill bg-primary"><?php echo date("H:i:s A", strtotime($rowp2['hora_hasta'])); ?></span>
                                                                            </span>
                                                                        </li>
                                                                    </ul>

                                                                    <div class="">
                                                                        <ul class="list-unstyled mb-0 categories-list">
                                                                            <li>
                                                                                <span><b>ENCARGADO</b> <br>
                                                                                    <span class=" badge rounded-pill bg-dark"><?php echo $rowp2['nombre_empleado']; ?></span></span>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>

                                                            </a>
                                                        </div>
                                                        <br>

                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="col-12 col-sm-3">
                            <div class="card radius-10 w-100">
                                <div class="card-body ">
                                    <h6 class="text-center"><b>REPORTES</b></h6>
                                    <hr>

                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>TERCEROS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-kardex.php" class="text-dark">RPT - Kardex</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-pedido.php" class="text-dark">RPT - Pedidos</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-pedido-detalle.php" class="text-dark">RPT - Pedidos por detalle</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-despacho.php" class="text-dark">RPT - Despachos</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-despacho-detalle.php" class="text-dark">RPT - Despachos por detalle</a></li>
                                    </ul>


                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>EMPLEADOS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-general-empleados.php?fecha_desde=<?php echo date('Y-m-d'); ?>&&fecha_hasta=<?php echo date('Y-m-d'); ?>" class="text-dark">RPT - Empleado</a></li>


                                    </ul>


                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>MERCANCIA</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-prioridad-despacho.php" class="text-dark">RPT - Orden de prioridad</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-produccion.php" class="text-dark">RPT - Produccion</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-produccion-detalle.php" class="text-dark">RPT - Produccion por detalle</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-mercancia-despachar.php" class="text-dark">RPT - Mercancia por despachar</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-mercancia-despachar-cliente.php" class="text-dark">RPT - Mercancia por despachar a cliente</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-mercancia-producir.php" class="text-dark">RPT - Mercancia por producir</a></li>
                                    </ul>

                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>SEGUIMINETO DE REFERENCIAS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-seguimiento-referencia-talla.php" class="text-dark">RPT - Seguimiento por talla</a></li>
                                    </ul>

                                    <br>

                                    <div class="text-center">
                                        <a href="sincronizar.php" class="btn btn-primary radius-30 px-5 ">SINCORNIZAR</a>
                                    </div>

                                </div>
                            </div><!-- end col -->
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-sm-4">

                            <div class="card radius-10 w-100">
                                <div class="card-body" id="hover_enlace">
                                    <div class="d-flex align-items-center mb-3">
                                        <h6 class="mb-0">Grafica pares | <b><?php echo $year; ?></b></h6>
                                        <div class="dropdown options ms-auto">
                                            <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                                                <ion-icon name="ellipsis-horizontal-sharp"></ion-icon>
                                            </div>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item" href="#">2023</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="row  justify-content-start align-items-center mb-3">
                                        <div class="col-sm-12 text-center">

                                            <?php
                                            $total_despacho_pares_vector = 0;
                                            for ($i = 0; $i < 12; $i++) {
                                                $despacho_pares_vector[$i];
                                                $total_despacho_pares_vector += $despacho_pares_vector[$i];
                                            }
                                            ?>

                                            <h5 class="mb-0"><?php echo number_format($total_despacho_pares_vector); ?></h5>
                                            <p class="mb-0 text-info"><b>PARES</b></p>
                                        </div>
                                    </div><!--end row-->

                                    <div class="chart-container7">
                                        <canvas id="chart_recaudo"></canvas>
                                    </div>




                                </div>
                            </div>

                        </div>

                        <div class="col-sm-8">
                            <div class="card radius-10 w-100">
                                <div class="card-body" id="hover_enlace">
                                    <div class="d-flex align-items-center mb-3">
                                        <h6 class="mb-0">Grafica Despachos | <b><?php echo $year; ?></b></h6>
                                        <div class="dropdown options ms-auto">
                                            <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                                                <ion-icon name="ellipsis-horizontal-sharp"></ion-icon>
                                            </div>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item" href="#">2023</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="row  justify-content-start align-items-center mb-3">
                                        <div class="col-sm-12 text-center">

                                            <?php
                                            $total_despacho_vector = 0;
                                            for ($i = 0; $i < 12; $i++) {
                                                $despacho_pares_vector[$i];
                                                $total_despacho_vector += $despacho_vector[$i];
                                            }
                                            ?>

                                            <h5 class="mb-0">$ <?php echo number_format($total_despacho_vector); ?></h5>
                                            <p class="mb-0 text-success"><b>DESPACHOS DINERO</b></p>
                                        </div>
                                    </div><!--end row-->

                                    <div class="chart-container4">
                                        <canvas id="chart7"></canvas>
                                    </div>
                                </div>
                                <div class="col-sm-4">

                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>

        <?php echo include '../general/libreria-js.php'; ?>


        <script>

            // chart_recaudo
            var ctx = document.getElementById('chart_recaudo').getContext('2d');

            var gradientStroke1 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke1.addColorStop(0, '#06ABED');
            gradientStroke1.addColorStop(1, '#2AF5C7');



            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                    datasets: [{
                            label: 'Pares',
                            data: [
<?php
for ($i = 0; $i < 12; $i++) {
    echo $despacho_pares_vector[$i];

    if ($i == 12) {
        
    } else {
        echo ",";
    }
}
?>
                            ],
                            backgroundColor: [
                                gradientStroke1
                            ],
                            borderColor: [
                                gradientStroke1
                            ],
                            borderWidth: 0,
                            borderRadius: 20
                        }

                    ]
                },
                options: {
                    maintainAspectRatio: false,
                    barPercentage: 0.9,
                    categoryPercentage: 0.4,
                    plugins: {
                        legend: {
                            maxWidth: 20,
                            boxHeight: 20,
                            position: 'bottom',
                            display: true,
                        }
                    },
                    scales: {
                        x: {
                            stacked: false,
                            beginAtZero: true
                        },
                        y: {
                            stacked: false,
                            beginAtZero: true
                        }
                    }
                }
            });



        </script>




        <script>
// chart7
            var ctx = document.getElementById('chart7').getContext('2d');

            var gradientStroke1 = ctx.createLinearGradient(0, 0, 0, 300);
            gradientStroke1.addColorStop(0, '#17ad37');
            gradientStroke1.addColorStop(1, '#98ec2d');


            var myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                    datasets: [{
                            label: 'Despachos',
                            data: [<?php
for ($i = 0; $i < 12; $i++) {
    echo $despacho_vector[$i];

    if ($i == 12) {
        
    } else {
        echo ",";
    }
}
?>],
                            backgroundColor: [
                                gradientStroke1
                            ],
                            fill: {
                                target: 'origin',
                                above: 'rgb(23 173 55 / 7%)', // Area will be red above the origin
                                below: 'rgb(23 173 55 / 7%)'    // And blue below the origin
                            },
                            //tension: 0.4,
                            borderColor: [
                                gradientStroke1
                            ],
                            borderWidth: 3
                        }]
                },
                options: {
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false,
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: false
                        }
                    }
                }
            });



        </script>



    </body>
</html>