<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- loader-->
        <link href="../../assets/css/pace.min.css" rel="stylesheet" />
        <script src="../../assets/js/pace.min.js"></script>

        <!--plugins-->
        <link href="../../assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
        <link href="../../assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
        <link href="../../assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
        <!-- SELECT 2 -->
        <link href="../../assets/plugins/select2/css/select2.min.css" rel="stylesheet" />
        <link href="../../assets/plugins/select2/css/select2-bootstrap4.css" rel="stylesheet" />

        <!-- DATATABLE -->
        <link href="../../assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

        <!-- CSS Files -->
        <link href="../../assets/css/bootstrap.min.css" rel="stylesheet">




        <link href="../../assets/css/bootstrap-extended.css" rel="stylesheet">
        <link href="../../assets/css/style.css" rel="stylesheet">
        <link href="../../assets/css/icons.css" rel="stylesheet">
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;700&amp;display=swap" rel="stylesheet">

        <!--Theme Styles-->
        <link href="../../assets/css/dark-theme.css" rel="stylesheet" />
        <link href="../../assets/css/semi-dark.css" rel="stylesheet" />
        <link href="../../assets/css/header-colors.css" rel="stylesheet" />

        <link href="../../assets/css/dropify.min.css" rel="stylesheet" type="text/css"/>

        <link rel="stylesheet" href="../../dist/css/dd.css?v=4.0">

        <!-- Favicon-->
        <link rel="shortcut icon" href="../../img/logo.png">





        <link href="ejemplo/colReorder.dataTables.min.css" rel="stylesheet" type="text/css"/>
        <link href="ejemplo/jquery.dataTables.min.css" rel="stylesheet" type="text/css"/>


        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">


    </head>
    <body>

        <div class=" mt-2 " style="overflow: auto;"> 
            <table class="table  table-striped table-bordered "  border="1" id="example" style="width: 100%;">
                <thead >
                    <tr >
                        <th class="text-center " >FECHA</th>

                        <th class="text-center">No PEDIDO</th>
                        <th class="" style="">TERCERO</th>

                        <th class="">OBSERVACION</th>
                        <th class="text-center">CANT.</th>
                        <th class="text-center">ESTADO</th>
                        <th class="text-center">DETALLE</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sql = "SELECT * FROM pedido ORDER BY fecha desc, id desc";
                    $query = $conn->query($sql);
                    if ($query->num_rows > 0) {
                        while ($row = $query->fetch_assoc()) {
                            ?>
                            <tr class="align-middle" id="hover_enlace" >
                                <td class="text-center">
                                    <?php echo date('d-m-Y', strtotime($row['fecha'])); ?>
                                </td>
                                <td class="text-center">
                                    <b><?php echo $row['numero_pedido']; ?></b>
                                </td> 

                                <td class="">
                                    <?php echo $row['nombre_tercero']; ?>
                                </td>    


                                <td class="">
                                    <?php echo $row['observacion']; ?>
                                </td>
                                <td class="text-center">
                                    <?php
                                    $sql3 = "SELECT SUM(cantidad) as cantidad_pedido FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "'";
                                    $query3 = $conn->query($sql3);
                                    $row3 = $query3->fetch_assoc();

                                    echo number_format($row3['cantidad_pedido'], 0);
                                    ?>
                                </td>
                                <td class="text-center">
                                    <?php
                                    if ($row['estado'] == 'Proceso') {
                                        $alert_text = 'text-white';
                                        $alert = 'bg-info';
                                    } elseif ($row['estado'] == 'Confirmado') {
                                        $alert_text = 'text-white';
                                        $alert = 'bg-pink';
                                    } elseif ($row['estado'] == 'Recibido') {
                                        $alert_text = 'text-white';
                                        $alert = 'bg-success';
                                    } elseif ($row['estado'] == 'Cancelado') {
                                        $alert_text = 'text-white';
                                        $alert = 'bg-secondary';
                                    } else {
                                        $text = 'text-dark';
                                    }
                                    ?>
                                    <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>

                                </td>
                                <td class="text-center">
                                    <a href="pedido-detalle.php?id_pedido=<?php echo $row['id']; ?>">
                                        <i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>
                </tbody>
                 <tfoot>
                    <tr>
                         <th class="text-center " >FECHA</th>

                        <th class="text-center">No PEDIDO</th>
                        <th class="" style="">TERCERO</th>

                        <th class="">OBSERVACION</th>
                        <th class="text-center">CANT.</th>
                        <th class="text-center">ESTADO</th>
                        <th class="text-center">DETALLE</th>
                    </tr>
                </tfoot>
            </table>
        </div>




        <script src="ejemplo/jquery-3.7.0.js" type="text/javascript"></script>


        <!-- JS Files-->


        <script src="../../assets/js/jquerynuevo.js" type="text/javascript"></script>
        <script src="../../assets/plugins/simplebar/js/simplebar.min.js"></script>
        <script src="../../assets/plugins/metismenu/js/metisMenu.min.js"></script>
        <script src="../../assets/js/bootstrap.bundle.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <!--plugins-->
        <script src="../../assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
        <script src="../../assets/js/component-popovers-tooltips.js"></script>
        <script src="../../assets/plugins/chartjs/chart.min.js"></script>
        <script src="../../assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
        <script src="../../assets/js/index2.js"></script>

        <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
        <script src="https://cdn.datatables.net/fixedcolumns/4.2.2/js/dataTables.fixedColumns.min.js"></script>

        <script src="../../assets/plugins/select2/js/select2.min.js"></script>
        <script src="../../assets/js/form-select2.js"></script>



        <!--plugins-->
        <script src="../../fontawesome-free-6.2.1-web/js/fontawesome.js" type="text/javascript"></script>
        <script src="../../fontawesome-free-6.2.1-web/js/regular.js" type="text/javascript"></script>
        <script src="../../fontawesome-free-6.2.1-web/js/solid.js" type="text/javascript"></script>
        <script src="../../fontawesome-free-6.2.1-web/js/brands.js" type="text/javascript"></script>






        <!-- Main JS-->
        <script src="../../assets/js/main.js"></script>


        <script src="ejemplo/jquery.dataTables.min.js" type="text/javascript"></script>
        <script src="ejemplo/dataTables.colReorder.min.js" type="text/javascript"></script>




        <script>
            new DataTable('#example', {
                colReorder: true,

                initComplete: function () {
                    let api = this.api();

                    api.columns().every(function () {
                        let column = this;
                        let title = column.footer().textContent;
                        let th = column.footer();

                        // Create input element
                        let input = document.createElement('input');
                        input.placeholder = title;
                        th.replaceChildren(input);

                        // Event listener for user input
                        input.addEventListener('keyup', () => {
                            if (column.search() !== this.value) {
                                let idx = [...th.parentNode.children].indexOf(th);

                                api.column(idx + ':visible')
                                        .search(input.value)
                                        .draw();
                            }
                        });
                    });
                }



            });

        </script>

    </body>
</html>