<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Panel produccion</li>
                        </ol>
                    </nav>



                    <div class="card">
                        <div class="card-body">
                            <h3><b>INVENTARIO DE MOLDES</b></h3>
                        </div>
                    </div>



                    <div class="row">
                        <div class="col-sm-4 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Nuevo molde</h6>
                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form method="POST" action="script/molde-guardar.php" class="row g-3 needs-validation " >

                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom02">Segmento</label>
                                                <select class="single-select" id="single-select1" required="" name="referencia_segmento" autofocus="">
                                                    <option selected="" disabled="" value="">Seleccione</option>

                                                    <?php
                                                    $sql6 = "SELECT * FROM segmento";
                                                    $query6 = $conn->query($sql6);
                                                    if ($query6->num_rows > 0) {
                                                        while ($row6 = $query6->fetch_assoc()) {
                                                            ?>
                                                            <option value="<?php echo $row6['referencia'] ?>"><?php echo $row6['referencia'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite un codigo.</div>
                                            </div> 
                                            <div class="col-md-6">
                                                <label class="form-label" for="validationCustom02">Talla</label>
                                                <select class="form-select " id="single-select2" required="" name="talla">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    for ($i = 10; $i < 50; $i++) {
                                                        ?>
                                                        <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite un codigo.</div>
                                            </div>        
                                            <div class="col-md-6">
                                                <label class="form-label" for="validationCustom02">Cantidad</label>
                                                <input class="form-control" id="validationCustom02" type="number" required="" name="cantidad">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, Digite la informacio necesaria.</div>
                                            </div>
                                            <div class="col-12 text-end">
                                                <button class="btn btn-success" type="submit">Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end page content-->
                    </div>



                    <div class="card ">
                        <div class="card-body">


                            <style>
                                th, td { white-space: nowrap; }

                                div.dataTables_wrapper {
                                    width: 100%;
                                    margin: 0 auto;
                                }


                            </style>


                            <div class=" mt-3">
                                <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                    <thead class="">
                                        <tr class=" bg-light-dark">
                                            <th class="" >REFERENCIAS</th>
                                            <?php
                                            $sql = "SELECT talla FROM molde GROUP BY talla ORDER BY talla asc";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {
                                                    ?>
                                                    <th class="text-center" ><?php echo $row['talla']; ?></th>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <th class="text-center">TOTAL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql1 = "SELECT referencia_segmento FROM molde  GROUP BY referencia_segmento ORDER BY referencia_segmento asc";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {

                                                $sql1p = "SELECT * FROM producto WHERE referencia_segmento='" . $row1['referencia_segmento'] . "' LIMIT 1";
                                                $query1p = $conn->query($sql1p);
                                                $row1p = $query1p->fetch_assoc();
                                                ?>
                                                <tr class="" >
                                                    <td class="">
                                                        <b class="text-primary">
                                                            <?php echo $row1['referencia_segmento']; ?>
                                                        </b>
                                                    </td>

                                                    <?php
                                                    $total_talla = 0;
                                                    $sql2 = "SELECT talla FROM molde GROUP BY talla ORDER BY talla asc";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {


                                                            $sql3 = "SELECT SUM(cantidad) as cantidad FROM molde WHERE referencia_segmento='" . $row1['referencia_segmento'] . "' AND talla='" . $row2['talla'] . "' ";
                                                            $query3 = $conn->query($sql3);
                                                            $row3 = $query3->fetch_assoc();

                                                            if ($row3['cantidad'] < 0) {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                                $talla_pedido = 0;
                                                            } if ($row3['cantidad'] > 0) {
                                                                $bg_color_talla = 'bg-purple';
                                                                $text_color = 'text-white';
                                                                $talla_pedido = $row3['cantidad'];
                                                            } else {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                                $talla_pedido = 0;
                                                            }
                                                            ?>
                                                            <td class="text-center <?php echo $bg_color_talla; ?> <?php echo $text_color; ?>" >


                                                                <?php
                                                                if ($row3['cantidad'] > 0) {
                                                                    ?>

                                                                    <a href="#!" class=" <?php echo $text_color; ?>"  data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo $row1['referencia_segmento'] . $row2['talla']; ?>" autofocus>
                                                                        <?php echo number_format($talla_pedido, 0); ?>
                                                                    </a>


                                                                    <!-- Modal -->
                                                                    <div class="modal fade" id="exampleModal<?php echo $row1['referencia_segmento'] . $row2['talla']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                        <div class="modal-dialog modal-sm">
                                                                            <div class="modal-content">
                                                                                <div class="modal-header">
                                                                                    <h5 class="modal-title card-heading text-dark" id="exampleModalLabel">
                                                                                        <b><?php echo $row1['referencia_segmento'] ?> </b>
                                                                                    </h5>
                                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                                </div>
                                                                                <form class=" g-3 needs-validation text-dark text-start" novalidate="" method="POST" action="script/molde-editar.php">
                                                                                    <input  type="text" required="" value="<?php echo $row1['referencia_segmento']; ?>" name="referencia_segmento" readonly="" hidden="">
                                                                                    <input  type="text" required="" value="<?php echo $row2['talla']; ?>" name="talla" readonly="" hidden="">

                                                                                    <div class="modal-body ">

                                                                                        <h6><b>Talla <?php echo $row2['talla']; ?></b></h6>
                                                                                        <hr>
                                                                                        <div class="row">
                                                                                            <div class="col-md-6">
                                                                                                <label class="form-label" for="validationCustom01">Cantidad actual</label>
                                                                                                <input class="form-control" id="validationCustom01" type="text" required="" value="<?php echo $row3['cantidad']; ?>" name="cantidad_actual" readonly="">
                                                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                                                <div class="invalid-feedback">Por favor, digite un color.</div>
                                                                                            </div>
                                                                                            <div class="col-md-6">
                                                                                                <label class="form-label" for="validationCustom01">Cantidad</label>
                                                                                                <input class="form-control" id="validationCustom01" type="number" required="" name="cantidad" value="0">
                                                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                                                <div class="invalid-feedback">Por favor, digite un color.</div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="modal-footer">
                                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                                                        <button type="submit" class="btn btn-warning" >Guardar cambios</button>
                                                                                    </div>
                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <?php
                                                                } else {
                                                                    echo number_format($talla_pedido, 0);
                                                                }
                                                                ?>


                                                            </td>


                                                            <?php
                                                            $total_talla += $row3['cantidad'];
                                                        }
                                                    }
                                                    ?> 






                                                    <?php
                                                    if ($total_talla < 0) {
                                                        $text_total_color = 'text-danger';
                                                    } elseif ($total_talla > 0) {
                                                        $text_total_color = 'text-purple';
                                                    } else {
                                                        $text_total_color = '';
                                                    }
                                                    ?>
                                                    <td class="text-center <?php echo $text_total_color; ?> h6"  style="font-weight: bold; ">

                                                        <?php echo $total_talla; ?>
                                                    </td>

                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                    <tfoot align="right">
                                        <tr class="bg-light-dark">
                                            <th class="bg-light-dark" >TOTAL</th>
                                                <?php
                                                $item_footer = 0;
                                                $sql2 = "SELECT talla FROM molde GROUP BY talla ORDER BY talla asc";
                                                $query2 = $conn->query($sql2);
                                                if ($query2->num_rows > 0) {
                                                    while ($row2 = $query2->fetch_assoc()) {
                                                        ?>
                                                    <th></th>
                                                    <?php
                                                    $item_footer++;
                                                }
                                            }


                                            $item_footer = $item_footer + 1;
                                            ?>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            $(document).ready(function () {
                var table = $('#example').DataTable({
                    scrollY: "500px",
                    scrollX: true,
                    scrollCollapse: true,
                    paging: false,
                    ordering: false,
                    fixedColumns: {
                        left: 1,
                    },

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    },

                    footerCallback: function (row, data, start, end, display) {
                        var api = this.api();

                        // Remove the formatting to get integer data for summation
                        var intVal = function (i) {
                            return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                        };



<?php
for ($i = 1; $i < $item_footer + 1; $i++) {
    ?>

                            // Total over all pages
                            total = api
                                    .column(<?php echo $i; ?>)
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                            // Total over this page
                            pageTotal = api
                                    .column(<?php echo $i; ?>, {page: 'current'})
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                            // Update footer
                            $(api.column(<?php echo $i; ?>).footer()).html(pageTotal);

    <?php
}
?>






                    },

                });
                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });




            //Tabla producto
            $(document).ready(function () {
                var select1 = $('#single-select1').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });

            //Tabla producto
            $(document).ready(function () {
                var select2 = $('#single-select2').select2({
                    theme: 'bootstrap4',
                    width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                    placeholder: $(this).data('placeholder'),
                    allowClear: Boolean($(this).data('allow-clear')),
                });


            });

        </script>


    </body>
</html>