<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$nombre_categoria = $_GET['nombre_categoria'];
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-panel.php"> 
                                    Panel de produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $nombre_categoria; ?></li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body bg-gradient-purple text-white">
                            <h4 class="text-center"><b>PRODUCCION</b></h4>
                        </div>
                    </div>



                    <div class="row">

                        <style>
                            #hover_enlace:hover{
                                box-shadow: 0px 0px 20px 0px #3C3D6B;
                            }

                        </style>

                        <div class="col-sm-12">
                            <div class="card radius-10 w-100">
                                <div class="card-body">

                                    <h5><b><?php echo $nombre_categoria; ?></b></h5>
                                    <hr>


                                    <div class="row">
                                        <?php
                                        $sql5 = "SELECT p.color, p.color2, p.categoria 
                                                FROM referencia_produccion rp, producto p 
                                                WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' GROUP BY p.color, p.color2 ORDER BY p.color asc";
                                        $query5 = $conn->query($sql5);
                                        if ($query5->num_rows > 0) {
                                            while ($row5 = $query5->fetch_assoc()) {
                                                ?>
                                                <div class="col-3 mt-2"  >
                                                    <div class="card radius-10  mb-0 " style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">

                                                        <a href="seleccion-maquina.php?nombre_categoria=<?php echo $nombre_categoria; ?>&&color=<?php echo $row5['color']; ?>&&color2=<?php echo $row5['color2']; ?>" id="hover_enlace" style="border-radius: 15px;">

                                                            <div class="card-body ">
                                                                <div class="d-flex align-items-center gap-3">

                                                                    <h6 class="mb-0 text-dark">
                                                                        <?php
                                                                        if ($row5['color'] == $row5['color2']) {
                                                                            echo $row5['color'];
                                                                        } else {
                                                                            echo $row5['color'] . " - " . $row5['color2'] . " <b class='text-secondary'>(BICOLOR)</b>";
                                                                        }
                                                                        ?></h6>

                                                                    <div class="ms-auto"> </div>
                                                                </div>



                                                                <ul class="list-unstyled mb-0 categories-list">



                                                                    <li>
                                                                        <span> </span>
                                                                    </li>

                                                                </ul>

                                                                <hr>
                                                                <div class="">
                                                                    <ul class="list-unstyled mb-0 categories-list">
                                                                        <?php
                                                                        $sql6 = "SELECT SUM(rp.cantidad) as cantidad_produccion_color 
                                                                                FROM referencia_produccion rp, producto p 
                                                                                WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' AND p.color='" . $row5['color'] . "' AND p.color2='" . $row5['color2'] . "'";
                                                                        $query6 = $conn->query($sql6);
                                                                        $row6 = $query6->fetch_assoc();
                                                                        ?>
                                                                        <li>
                                                                            <span><b>TOTAL</b> <span class="float-end badge rounded-pill bg-primary"><?php echo $row6['cantidad_produccion_color']; ?></span></span>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </a>

                                                    </div>
                                                </div>

                                                <?php
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card ">
                        <div class="card-body">


                            <style>
                                th, td { white-space: nowrap; }

                                div.dataTables_wrapper {
                                    width: 100%;
                                    margin: 0 auto;
                                }


                            </style>


                            <div class=" mt-3">
                                <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                    <thead class="bg-gradient-purple text-white">
                                        <tr class=" ">
                                            <th class="bg-gradient-purple" >REFERENCIAS</th>
                                            <th class="bg-gradient-purple" >COLOR 1</th> 
                                            <th class="bg-gradient-purple" >COLOR 2</th>
                                            <?php
                                            $sql = "SELECT rp.talla 
                                                    FROM referencia_produccion rp, producto p 
                                                    WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' GROUP BY rp.talla ORDER BY rp.talla asc";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {
                                                    ?>
                                                    <th class="text-center" ><?php echo $row['talla']; ?></th>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <th class="text-center">TOTAL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql1 = "SELECT rp.referencia_producto 
                                                FROM referencia_produccion rp, producto p 
                                                WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' GROUP BY rp.referencia_producto ORDER BY rp.referencia_producto asc";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {

                                                $sql1p = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                                $query1p = $conn->query($sql1p);
                                                $row1p = $query1p->fetch_assoc();
                                                ?>
                                                <tr class="" >
                                                    <td class="">
                                                        <b class="text-primary">
                                                            <a href="../producto/kardex.php?referencia=<?php echo $row1['referencia_producto']; ?>" target="_blank">
                                                                <?php echo $row1['referencia_producto']; ?>

                                                                <span>
                                                                    <?php
                                                                    if ($row1p['color'] == $row1p['color2']) {
                                                                        
                                                                    } else {
                                                                        echo  "<b class='text-secondary'>(BICOLOR)</b>";
                                                                    }
                                                                    ?>
                                                                </span>
                                                            </a>
                                                        </b>
                                                    </td>
                                                    <td class="">
                                                        <b class="text-primary"><?php echo $row1p['color']; ?></b>
                                                    </td>

                                                    <td class="">
                                                        <b class="text-primary"><?php echo $row1p['color2']; ?></b>
                                                    </td>

                                                    <?php
                                                    $total_talla = 0;
                                                    $sql2 = "SELECT rp.talla 
                                                            FROM referencia_produccion rp, producto p 
                                                            WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' GROUP BY rp.talla ORDER BY rp.talla asc";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {


                                                            $sql3 = "SELECT SUM(rp.cantidad) as cantidad "
                                                                    . "FROM referencia_produccion rp, producto p "
                                                                    . "WHERE p.referencia=rp.referencia_producto AND "
                                                                    . "rp.referencia_producto='" . $row1['referencia_producto'] . "' AND rp.talla='" . $row2['talla'] . "' AND p.categoria='$nombre_categoria' ";
                                                            $query3 = $conn->query($sql3);
                                                            $row3 = $query3->fetch_assoc();

                                                            if ($row3['cantidad'] < 0) {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                                $talla_pedido = 0;
                                                            } if ($row3['cantidad'] > 0) {
                                                                $bg_color_talla = 'bg-purple';
                                                                $text_color = 'text-white';
                                                                $talla_pedido = $row3['cantidad'];
                                                            } else {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                                $talla_pedido = 0;
                                                            }
                                                            ?>
                                                            <td class="text-center <?php echo $bg_color_talla; ?> <?php echo $text_color; ?>" >
                                                                <?php echo number_format($talla_pedido, 0); ?>
                                                            </td>


                                                            <?php
                                                            $total_talla += $row3['cantidad'];
                                                        }
                                                    }
                                                    ?> 






                                                    <?php
                                                    if ($total_talla < 0) {
                                                        $text_total_color = 'text-danger';
                                                    } elseif ($total_talla > 0) {
                                                        $text_total_color = 'text-purple';
                                                    } else {
                                                        $text_total_color = '';
                                                    }
                                                    ?>
                                                    <td class="text-center <?php echo $text_total_color; ?> h6"  style="font-weight: bold; ">

                                                        <?php echo $total_talla; ?>
                                                    </td>

                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                    <tfoot align="right">
                                        <tr class="bg-light-dark">
                                            <th class="bg-light-dark" colspan="3">TOTAL</th>
                                            <?php
                                            $item_footer = 1;
                                            $sql4 = "SELECT rp.talla "
                                                    . "FROM referencia_produccion rp, producto p "
                                                    . "WHERE p.referencia=rp.referencia_producto AND p.categoria='$nombre_categoria' AND p.bloqueo='No' GROUP BY rp.talla ORDER BY rp.talla asc";
                                            $query4 = $conn->query($sql4);
                                            if ($query4->num_rows > 0) {
                                                while ($row4 = $query4->fetch_assoc()) {
                                                    ?>
                                                    <th class="text-center"></th>
                                                    <?php
                                                    $item_footer++;
                                                }
                                            }
                                            ?>
                                            <th class="text-center"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                        </div>
                    </div>


                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            $(document).ready(function () {



                var table = $('#example').DataTable({
                    scrollY: "500px",
                    scrollX: true,
                    scrollCollapse: true,
                    paging: false,
                    ordering: false,
                    fixedColumns: {
                        left: 1,
                    },

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    },

                    footerCallback: function (row, data, start, end, display) {
                        var api = this.api();
                        // Remove the formatting to get integer data for summation
                        var intVal = function (i) {
                            return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                        };
<?php
for ($i = 2; $i < $item_footer + 2; $i++) {
    ?>

                            // Total over all pages
                            total = api
                                    .column(<?php echo $i; ?>)
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);
                            // Total over this page
                            pageTotal = api
                                    .column(<?php echo $i; ?>, {page: 'current'})
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);
                            // Update footer
                            $(api.column(<?php echo $i; ?>).footer()).html(pageTotal);
    <?php
}
?>
                    },
                });
                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


    </body>
</html>