<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="../produccion/produccion-panel.php"> 
                                    Panel de produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                Ordenes produccion
                            </li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center">
                            <h3><b>ORDENES DE PRODUCCION</b></h3>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            <div class="row">
                                <div class="col-sm-8">
                                    <h6 class="mb-0 text-uppercase"><b>LISTA DE PRODUCCION</b> 
                                    </h6>

                                </div>
                                <div class="col-sm-4 text-end">
                                    <a href="produccion-orden-p1.php" class="btn btn-primary px-5 radius-30"  >
                                        GENERAR ORDEN DE PRODUCCION
                                    </a> 

                                 
                                </div>
                            </div>

                            <hr/>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px; 
                                    box-shadow: 0px 0px 10px 0px purple;
                                }

                            </style>

                            <div class=" mt-2" style="overflow: auto; ">
                                <table class="table align-middle mb-0 table-striped table-bordered" border="1" id="example2" style="">
                                    <thead class="">
                                        <tr class="bg-primary text-white">
                                            <th class="text-center" style="width: 8%;">FECHA</th>
                                            <th class="text-center ">ID</th>
                                            <th class="text-center ">USUARIO REGISTRO</th>
                                            <th class="text-center ">No PRODUCCION</th>
                                            <th class=" ">MAQUINA</th>
                                            <th class="text-center ">CAÑON</th>
                                            <th class=" ">ENCARGADO</th>
                                            <th class="text-center" style="width: 8%;">AYUDANTE 1</th>
                                            <th class="text-center" style="width: 8%;">AYUDANTE 2</th>
                                            <th class="text-center">CANTIDAD</th>
                                            <th class="text-center">OBSERVACION</th>
                                            <th class="text-center">DETALLE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM produccion ORDER BY fecha desc, id desc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {

                                                $sql1 = "SELECT SUM(cantidad) as cantidad FROM produccion_detalle WHERE id_produccion='" . $row['id'] . "'";
                                                $query1 = $conn->query($sql1);
                                                $row1 = $query1->fetch_assoc();
                                                ?>
                                                <tr class="align-middle" id="hover_enlace" >
                                                    <td class="text-center">
                                                        <?php echo date('d-m-Y', strtotime($row['fecha'])); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo $row['id']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo $row['nombre_usuario']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <b><?php echo $row['numero_produccion']; ?></b>
                                                    </td>
                                                    <td class="">
                                                        <?php echo $row['nombre_maquina']; ?>
                                                    </td>         
                                                    <td class="text-center">
                                                        <?php echo $row['canon']; ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php echo $row['nombre_tercero_1']; ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php
                                                        if ($row['nombre_tercero_2'] == NULL) {
                                                            echo '---';
                                                        } else {
                                                            echo $row['nombre_tercero_2'];
                                                        }
                                                        ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php
                                                        if ($row['nombre_tercero_3'] == NULL) {
                                                            echo '---';
                                                        } else {
                                                            echo $row['nombre_tercero_3'];
                                                        }
                                                        ?>                                                   
                                                    </td> 
                                                    <td class="text-center">
                                                        <?php echo number_format($row1['cantidad'], 0); ?>
                                                    </td>
                                                    <td class="">
                                                        <?php echo $row['observacion']; ?>
                                                    </td>

                                                    <td class="text-center">
                                                        <a href="produccion-detalle.php?id_produccion=<?php echo $row['id']; ?>"><i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i></a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    }
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>