<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
</head>

<body>
    <!--start wrapper-->
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php">
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="../produccion/produccion-panel.php">
                                Panel de produccion
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            Historial produccion
                        </li>
                    </ol>
                </nav>



                <div class="card">
                    <div class="card-body text-center bg-gradient-purple text-white">
                        <h3><b>HISTORIAL PRODUCCION</b></h3>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">

                        <div class="row">
                            <div class="col-sm-9">
                                <h6 class="mb-0 text-uppercase"><b>LISTA DE PRODUCCION</b>
                                </h6>

                            </div>
                            <div class="col-sm-3 text-end">
                                <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#agregar">
                                    NUEVA PRODUCCION
                                </a>

                                <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xs">
                                        <div class="modal-content">
                                            <div class="modal-header bg-gradient-purple">
                                                <h5 class="modal-title card-heading text-white" id="exampleModalLabel">NUEVA PRODUCCION</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form class=" g-3 needs-validation" method="POST" action="script/produccion-guardar.php">
                                                <div class="modal-body ">
                                                    <div class="row">
                                                        <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                                        <div class="col-sm-6">
                                                            <label class="form-label" for="validationCustom02">Fecha</label>
                                                            <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                        </div>
                                                        <div class="col-sm-6 ">
                                                            <label class="form-label" for="validationCustom02">Numero produccion</label>
                                                            <input class="form-control" id="validationCustom02" type="text" required="" name="numero_produccion" value="Autoincrementable" readonly="">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                        </div>
                                                        <div class="col-sm-8 mt-3">
                                                            <label class="form-label" for="validationCustom01">Maquina</label>
                                                            <select class="form-select" id="validationCustom04" required="" name="nombre_maquina">
                                                                <option disabled="" selected="" value="">SELECCIONE</option>
                                                                <?php
                                                                $sql4 = "SELECT * FROM maquina ";
                                                                $query4 = $conn->query($sql4);
                                                                if ($query4->num_rows > 0) {
                                                                    while ($row4 = $query4->fetch_assoc()) {
                                                                ?>
                                                                        <option value="<?php echo $row4['nombre'] ?>"><?php echo $row4['identificador'] ?> - <?php echo $row4['nombre'] ?></option>
                                                                <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                        </div>

                                                        <div class="col-sm-4 mt-3">
                                                            <label class="form-label" for="validationCustom01">Cañon</label>
                                                            <select class="form-select" id="validationCustom04" required="" name="canon">
                                                                <option disabled="" value="">SELECCIONE</option>
                                                                <option selected="" value="1">1</option>
                                                                <option value="2">2</option>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                        </div>

                                                        <div class="col-sm-12 mt-3">
                                                            <label class="form-label" for="validationCustom01">Encargado</label>
                                                            <select class="form-select" id="validationCustom04" required="" name="nombre_tercero_1">
                                                                <option disabled="" selected="" value="">SELECCIONE</option>
                                                                <?php
                                                                $sql1 = "SELECT * FROM tercero WHERE tipo='Empleado'";
                                                                $query1 = $conn->query($sql1);
                                                                if ($query1->num_rows > 0) {
                                                                    while ($row1 = $query1->fetch_assoc()) {
                                                                ?>

                                                                        <option value="<?php echo $row1['nombre'] ?>"><?php echo $row1['nombre'] ?></option>
                                                                <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                        </div>
                                                        <div class="col-sm-12 mt-3">
                                                            <label class="form-label" for="validationCustom01">Ayudante 1</label>
                                                            <select class="form-select" id="validationCustom04" required="" name="nombre_tercero_2">
                                                                <option selected="" value="NO APLICA">NO APLICA</option>
                                                                <option disabled="" value="">SELECCIONE</option>

                                                                <?php
                                                                $sql2 = "SELECT * FROM tercero WHERE tipo='Empleado'";
                                                                $query2 = $conn->query($sql2);
                                                                if ($query2->num_rows > 0) {
                                                                    while ($row2 = $query2->fetch_assoc()) {
                                                                ?>

                                                                        <option value="<?php echo $row2['nombre'] ?>"><?php echo $row2['nombre'] ?></option>
                                                                <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                        </div>
                                                        <div class="col-sm-12 mt-3">
                                                            <label class="form-label" for="validationCustom01">Ayudante 2</label>
                                                            <select class="form-select" id="validationCustom04" required="" name="nombre_tercero_3">
                                                                <option selected="" value="NO APLICA">NO APLICA</option>
                                                                <option disabled="" value="">SELECCIONE</option>
                                                                <?php
                                                                $sql3 = "SELECT * FROM tercero WHERE tipo='Empleado'";
                                                                $query3 = $conn->query($sql3);
                                                                if ($query3->num_rows > 0) {
                                                                    while ($row3 = $query3->fetch_assoc()) {
                                                                ?>
                                                                        <option value="<?php echo $row3['nombre'] ?>"><?php echo $row3['nombre'] ?></option>
                                                                <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </select>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                        </div>
                                                        <div class="col-md-12 mt-3">
                                                            <label class="form-label" for="validationCustom02">Observación</label>
                                                            <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion">SIN COMENTARIOS</textarea>
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-success px-5 radius-30">Guardar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <hr />

                        <style>
                            #hover_enlace:hover {
                                color: purple;
                                border-radius: 10px;
                                box-shadow: 0px 0px 10px 0px purple;
                            }
                        </style>

                        <div class=" mt-2" style="overflow: auto; ">
                            <table class="table align-middle mb-0 table-striped table-bordered" border="1" id="example2" >
                                <thead class="">
                                    <tr class="bg-gradient-purple text-white">
                                        <th class="text-center" style="width: 8%;">FECHA</th>
                                        <th class="text-center ">USUARIO</th>
                                        <th class="text-center ">No PRODUC.</th>
                                        <th class=" ">MAQUINA</th>
                                        <th class="text-center ">CAÑON</th>
                                        <th class=" ">ENCARGADO</th>
                                        <th class="text-center">CANTIDAD</th>
                                        <th class="text-center">OBSERVACION</th>
                                        <th class="text-center">ESTADO</th>
                                        <th class="text-center">DETALLE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT * FROM produccion ORDER BY fecha desc, id desc";
                                    $query = $conn->query($sql);
                                    if ($query->num_rows > 0) {
                                        while ($row = $query->fetch_assoc()) {

                                            $sql1 = "SELECT SUM(cantidad) as cantidad FROM produccion_detalle WHERE id_produccion='" . $row['id'] . "'";
                                            $query1 = $conn->query($sql1);
                                            $row1 = $query1->fetch_assoc();
                                    ?>
                                            <tr class="align-middle" id="hover_enlace">
                                                <td class="text-center">
                                                    <?php echo date('d-m-Y', strtotime($row['fecha'])); ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo $row['nombre_usuario']; ?>
                                                </td>
                                                <td class="text-center">
                                                    <b><?php echo $row['numero_produccion']; ?></b>
                                                </td>
                                                <td class="">
                                                    <?php echo $row['nombre_maquina']; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo $row['canon']; ?>
                                                </td>
                                                <td class="">
                                                    <?php echo $row['nombre_tercero_1']; ?>

                                                    <br>
                                                    <?php
                                                    if ($row['nombre_tercero_2'] == NULL) {
                                                        echo '---';
                                                    } else {
                                                        echo $row['nombre_tercero_2'];
                                                    }
                                                    ?>
                                                    <br>
                                                    <?php
                                                    if ($row['nombre_tercero_3'] == NULL) {
                                                        echo '---';
                                                    } else {
                                                        echo $row['nombre_tercero_3'];
                                                    }
                                                    ?>
                                                </td>

                                                <td class="text-center">
                                                    <?php echo number_format($row1['cantidad'], 0); ?>
                                                </td>
                                                <td class="">
                                                    <?php echo $row['observacion']; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php
                                                    if ($row['estado'] == 'Proceso') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-info';
                                                    } elseif ($row['estado'] == 'Confirmado') {
                                                        $alert_text = 'text-white';
                                                        $alert = 'bg-pink';
                                                    } else {
                                                        $text = 'text-dark';
                                                    }
                                                    ?>
                                                    <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>

                                                </td>
                                                <td class="text-center">
                                                    <a href="produccion-detalle.php?id_produccion=<?php echo $row['id']; ?>"><i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i></a>
                                                </td>
                                            </tr>
                                    <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">
                        <div class=" mt-3" style="overflow: auto;">
                            <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                <thead class="bg-gradient-purple text-white">
                                    <tr class=" ">
                                        <th class="bg-gradient-purple">REFERENCIAS</th>
                                        <th class="bg-gradient-purple">COLOR</th>
                                        <?php
                                        $sql = "SELECT talla FROM referencia_produccion GROUP BY talla ORDER BY talla asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                        ?>
                                                <th class="text-center"><?php echo $row['talla']; ?></th>
                                        <?php
                                            }
                                        }
                                        ?>
                                        <th class="text-center">TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql1 = "SELECT referencia_producto FROM referencia_produccion  GROUP BY referencia_producto ORDER BY referencia_producto asc";
                                    $query1 = $conn->query($sql1);
                                    if ($query1->num_rows > 0) {
                                        while ($row1 = $query1->fetch_assoc()) {

                                            $sql1p = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                            $query1p = $conn->query($sql1p);
                                            $row1p = $query1p->fetch_assoc();
                                    ?>
                                            <tr class="">
                                                <td class="">
                                                    <b class="text-primary">
                                                        <a href="../producto/kardex.php?referencia=<?php echo $row1['referencia_producto']; ?>" target="_blank">
                                                            <?php echo $row1['referencia_producto']; ?>
                                                        </a>
                                                    </b>
                                                </td>
                                                <td class="">
                                                    <b class="text-primary"><?php echo $row1p['color']; ?></b>
                                                </td>

                                                <?php
                                                $total_talla = 0;
                                                $sql2 = "SELECT talla FROM referencia_produccion GROUP BY talla ORDER BY talla asc";
                                                $query2 = $conn->query($sql2);
                                                if ($query2->num_rows > 0) {
                                                    while ($row2 = $query2->fetch_assoc()) {


                                                        $sql3 = "SELECT SUM(cantidad) as cantidad FROM referencia_produccion WHERE referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $row2['talla'] . "' ";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        if ($row3['cantidad'] < 0) {
                                                            $bg_color_talla = '';
                                                            $text_color = 'text-secondary';
                                                            $talla_pedido = 0;
                                                        }
                                                        if ($row3['cantidad'] > 0) {
                                                            $bg_color_talla = 'bg-purple';
                                                            $text_color = 'text-white';
                                                            $talla_pedido = $row3['cantidad'];
                                                        } else {
                                                            $bg_color_talla = '';
                                                            $text_color = 'text-secondary';
                                                            $talla_pedido = 0;
                                                        }
                                                ?>
                                                        <td class="text-center <?php echo $bg_color_talla; ?> <?php echo $text_color; ?>">
                                                            <?php echo number_format($talla_pedido, 0); ?>
                                                        </td>


                                                <?php
                                                        $total_talla += $row3['cantidad'];
                                                    }
                                                }
                                                ?>






                                                <?php
                                                if ($total_talla < 0) {
                                                    $text_total_color = 'text-danger';
                                                } elseif ($total_talla > 0) {
                                                    $text_total_color = 'text-purple';
                                                } else {
                                                    $text_total_color = '';
                                                }
                                                ?>
                                                <td class="text-center <?php echo $text_total_color; ?> h6" style="font-weight: bold; ">

                                                    <?php echo $total_talla; ?>
                                                </td>

                                            </tr>
                                    <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                                <tfoot align="right">
                                    <tr class="bg-light-dark">
                                        <th class="bg-light-dark" colspan="2">TOTAL</th>
                                        <?php
                                        $item_footer = 1;
                                        $sql2 = "SELECT talla FROM referencia_produccion GROUP BY talla ORDER BY talla asc";
                                        $query2 = $conn->query($sql2);
                                        if ($query2->num_rows > 0) {
                                            while ($row2 = $query2->fetch_assoc()) {
                                        ?>
                                                <th></th>
                                        <?php
                                                $item_footer++;
                                            }
                                        }
                                        ?>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>


            </div>
            <?php echo include '../general/footer.php'; ?>
        </div>
    </div>
    <!--end wrapper-->
    <?php echo include '../general/libreria-js.php'; ?>


    <script>
        //Tabla producto
        $(document).ready(function() {
            var table = $('#example2').DataTable({
                lengthChange: false,
                buttons: ['copy', 'excel', 'pdf', 'print'],
                "order": false,
                language: {
                    search: 'Buscar',
                    zeroRecords: 'No hay registros para mostrar.',
                    emptyTable: 'La tabla está vacia.',
                    info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                    infoFiltered: "(Filtrados de _MAX_ Registros.)",
                    paginate: {
                        first: 'Primero',
                        previous: 'Anterior',
                        next: 'Siguiente',
                        last: 'Último'
                    }
                }
            });

            table.buttons().container()
                .appendTo('#example2_wrapper .col-md-6:eq(0)');
        });
    </script>


    <script>
        $(document).ready(function() {
            var table = $('#example').DataTable({
                scrollY: "500px",
                scrollX: true,
                scrollCollapse: true,
                paging: false,
                ordering: false,
                fixedColumns: {
                    left: 1,
                },

                language: {
                    search: 'Buscar',
                    zeroRecords: 'No hay registros para mostrar.',
                    emptyTable: 'La tabla está vacia.',
                    info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                    infoFiltered: "(Filtrados de _MAX_ Registros.)",
                    paginate: {
                        first: 'Primero',
                        previous: 'Anterior',
                        next: 'Siguiente',
                        last: 'Último'
                    }
                },

                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();

                    // Remove the formatting to get integer data for summation
                    var intVal = function(i) {
                        return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                    };



                    <?php
                    for ($i = 2; $i < $item_footer + 2; $i++) {
                    ?>

                        // Total over all pages
                        total = api
                            .column(<?php echo $i; ?>)
                            .data()
                            .reduce(function(a, b) {
                                return intVal(a) + intVal(b);
                            }, 0);

                        // Total over this page
                        pageTotal = api
                            .column(<?php echo $i; ?>, {
                                page: 'current'
                            })
                            .data()
                            .reduce(function(a, b) {
                                return intVal(a) + intVal(b);
                            }, 0);

                        // Update footer
                        $(api.column(<?php echo $i; ?>).footer()).html(pageTotal);

                    <?php
                    }
                    ?>






                },

            });
            table.buttons().container()
                .appendTo('#example2_wrapper .col-md-6:eq(0)');
        });
    </script>



</body>

</html>