<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
</head>

<body>
    <!--start wrapper-->
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">

                <div class="card">
                    <div class="card-body pb-0">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb ">
                                <li class="breadcrumb-item">
                                    <a href="../inicio/inicio.php">
                                        <ion-icon name="home-outline"></ion-icon>
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="producto.php">
                                        Productos
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Nuevo producto</li>
                            </ol>
                        </nav>
                    </div>
                </div>



                <!-- contenedor padre centrado -->
                <div class="container my-4">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10 col-xl-8">

                            <div class="card shadow-sm border-0">
                                <div class="card-header bg-success bg-gradient text-white py-2">
                                    <h5 class="mb-0"><i class="fas fa-box-open me-2"></i>Nuevo producto</h5>
                                </div>

                                <form class="card-body " method="POST"
                                    action="script/producto-guardar.php" >

                                    <!-- ① Datos básicos --------------------------------------------------- -->
                                    <h6 class="border-start border-4 border-success ps-2 mb-3">Datos básicos</h6>
                                    <div class="row g-3">
                                        <input type="hidden" name="nombre_usuario" value="<?= $rowusu['nombre'] ?>">
                                        <input type="hidden" name="nombre_sucursal" value="<?= $session_sucursal ?>">


                                        <div class="col-sm-4">
                                            <label class="form-label">Segmento *</label>
                                            <select class="custom-select"  name="referencia_segmento" autofocus="" required="">
                                                <option selected="" disabled="" value="">Seleccione</option>

                                                <?php
                                                $sql6 = "SELECT * FROM segmento";
                                                $query6 = $conn->query($sql6);
                                                if ($query6->num_rows > 0) {
                                                    while ($row6 = $query6->fetch_assoc()) {
                                                ?>
                                                        <option value="<?php echo $row6['referencia'] ?>"><?php echo $row6['referencia'] ?></option>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label">Codigo *</label>
                                            <input type="text" class="form-control" name="codigo" required>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label">Referencia *</label>
                                            <input type="text" class="form-control" name="referencia" required>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label">Color 1 *</label>
                                            <select class="custom-select " required="" name="color">
                                                <option selected="" disabled="" value="">Seleccione</option>
                                                <?php
                                                $sql21 = "SELECT * FROM color";
                                                $query21 = $conn->query($sql21);
                                                if ($query21->num_rows > 0) {
                                                    while ($row21 = $query21->fetch_assoc()) {
                                                ?>
                                                        <option value="<?php echo $row21['color'] ?>"><?php echo $row21['color'] ?></option>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-sm-4">
                                            <label class="form-label">Color 2 *</label>
                                            <select class="custom-select " required="" name="color2">
                                                <option selected="" disabled="" value="">Seleccione</option>
                                                <?php
                                                $sql21 = "SELECT * FROM color";
                                                $query21 = $conn->query($sql21);
                                                if ($query21->num_rows > 0) {
                                                    while ($row21 = $query21->fetch_assoc()) {
                                                ?>
                                                        <option value="<?php echo $row21['color'] ?>"><?php echo $row21['color'] ?></option>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label">Categoría *</label>
                                            <select class="form-select custom-select" name="categoria" required>
                                                <option value="" disabled selected>Seleccione</option>
                                                <?php
                                                $rs = $conn->query("SELECT categoria FROM categoria_producto ORDER BY categoria");
                                                while ($c = $rs->fetch_assoc()):
                                                ?>
                                                    <option value="<?= $c['categoria'] ?>"><?= $c['categoria'] ?></option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label">Clase *</label>
                                            <select class="custom-select" required="" name="clase">
                                                <option selected="" disabled="" value="">Seleccione</option>
                                                <?php
                                                $sql6c = "SELECT * FROM clase";
                                                $query6c = $conn->query($sql6c);
                                                if ($query6c->num_rows > 0) {
                                                    while ($row6c = $query6c->fetch_assoc()) {
                                                ?>

                                                        <option value="<?php echo $row6c['clase'] ?>"><?php echo $row6c['clase'] ?></option>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <div class="col-sm-4">
                                            <label class="form-label" for="validationCustom02">Peso Kg. *</label>
                                            <input class="form-control" id="validationCustom02" type="text" required="" name="peso">
                                        </div>



                                        <div class="col-sm-4">
                                            <label class="form-label">precio venta *</label>
                                            <input type="number" class="form-control" value="0" name="precio_venta" required>

                                        </div>

                                        <div class="col-12 form-floating">
                                            <textarea class="form-control" id="inpDesc" name="descripcion"
                                                style="height:90px" required>No aplica</textarea>
                                            <label for="inpDesc">Descripción *</label>
                                        </div>
                                    </div> <!-- row g-3 -->

                                    <!-- ③ Botones --------------------------------------------------------- -->
                                    <div class="text-end border-top pt-3">
                                        <a href="producto.php" class="btn btn-secondary">Cancelar</a>
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-save me-1"></i>Guardar
                                        </button>

                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>



                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
    </div>
    <!--end wrapper-->
    <?php echo include '../general/libreria-js.php'; ?>



</body>

</html>