<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$id_venta = $_GET['id_venta'];

$sql = "SELECT * FROM venta WHERE id='$id_venta'";
$query = $conn->query($sql);
$row = $query->fetch_assoc();
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="venta.php"> 
                                    Ventas
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="venta-fecha.php?fecha=<?php echo $row['fecha']; ?>"> 
                                    <?php echo $row['fecha']; ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $row['id']; ?> | <?php echo $row['nombre']; ?></li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body" style="background-image: url('../../img/logo_opacidad.png');">
                            <!-- CONTENIDO DE PAGINA-->

                            <div class="row">

                                <div class="col-xl-4 ">
                                    <h6 class="text-uppercase ">
                                        <strong class="text-dark">Asesor</strong>:  
                                        <strong class="text-body text-muted"><?php echo $row['nombre_usuario']; ?></strong>
                                    </h6>
                                </div>
                                <div class="col-xl-8 text-end">
                                    <?php
                                    if ($row['estado'] == 'Proceso') {
                                        $color_estado = 'badge alert-primary';
                                        $color_estado_2 = '';
                                    } elseif ($row['estado'] == 'Confirmado') {
                                        $color_estado = 'badge bg-pink';
                                        $color_estado_2 = '';
                                    } elseif ($row['estado'] == 'Alistamiento') {
                                        $color_estado = '';
                                        $color_estado_2 = 'background-color: purple';
                                    } elseif ($row['estado'] == 'Enviado') {
                                        $color_estado = 'badge alert-warning';
                                        $color_estado_2 = '';
                                    } elseif ($row['estado'] == 'Novedad') {
                                        $color_estado = '';
                                        $color_estado_2 = 'background-color: yellow; color:black';
                                    } elseif ($row['estado'] == 'Entregado') {
                                        $color_estado = 'badge alert-success';
                                        $color_estado_2 = '';
                                    } elseif ($row['estado'] == 'Devolucion') {
                                        $color_estado = 'badge alert-danger';
                                        $color_estado_2 = '';
                                    } elseif ($row['estado'] == 'Cancelado') {
                                        $color_estado = 'badge alert-secondary';
                                        $color_estado_2 = '';
                                    }
                                    ?>



                                    <div class="dropdown">
                                        <button class=" dropdown-toggle badge <?php echo $color_estado; ?>" style="font-size: 13px; <?php echo $color_estado_2; ?>;" type="button" data-bs-toggle="dropdown" aria-expanded="false"><?php echo $row['estado']; ?></button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Proceso"><i class="fas fa-circle text-info" style="font-size: 13px;"></i> Proceso</a>
                                            </li> 
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Confirmado"><i class="fas fa-circle" style="font-size: 13px; color: #ff0080;"></i> Confirmado</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Alistamiento"><i class="fas fa-circle" style="font-size: 13px; color: purple;"></i> Alistamiento</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Enviado"><i class="fas fa-circle text-warning" style="font-size: 13px;"></i> Enviado</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Novedad"><i class="fas fa-circle text-bronze" style="font-size: 13px;"></i> Novedad</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Entregado"><i class="fas fa-circle text-success" style="font-size: 13px;"></i> Entregado</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Cancelado"><i class="fas fa-circle text-secondary" style="font-size: 13px;"></i> Cancelado</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Devolucion"><i class="fas fa-circle text-dark" style="font-size: 13px;"></i> Devolucion</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>


                            <form class=" g-3 needs-validation" novalidate="" action="">
                                <input class="form-control inputcss"  type="text" required="" name="nombre_usuario"  value="<?php echo $rowusu['nombre']; ?>" hidden readonly>

                                <div class="row">
                                    <div class="col-md-3 ">
                                        <h6 class="mt-3">DATOS FACTURACION: <strong class="text-primary "> P<?php echo $row['id']; ?></strong></h6>
                                        <hr class="mt-0" style="border-top: 2px dotted black;">
                                        <style>
                                            .inputcss{
                                                color: brown;
                                                font-weight: 500;
                                            }
                                        </style>
                                        <div style="font-size: 12px;">
                                            <div class="row ">
                                                <div class="col-md-6 col-6">
                                                    <strong>Fecha:</strong>
                                                </div>
                                                <div class="col-md-6 col-6" style="text-align: right;">
                                                    <span><?php echo $row['fecha']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-6 col-6">
                                                    <strong>Nombre tercero:</strong>
                                                </div>
                                                <div class="col-md-6 col-6" style="text-align: right;">
                                                    <strong class="text-secondary"><?php echo $row['nombre_tercero']; ?></strong>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-6 col-6">
                                                    <strong>No Pedido:</strong>
                                                </div>
                                                <div class="col-md-6 col-6" style="text-align: right;">
                                                    <span><?php echo $row['numero_pedido']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-6 col-6">
                                                    <strong>No Remision:</strong>
                                                </div>
                                                <div class="col-md-6 col-6" style="text-align: right;">
                                                    <span><?php echo $row['numero_remision']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-4">
                                        <h6 class="mt-3">DATOS DEL CLIENTE:</h6>
                                        <hr class="mt-0" style="border-top: 2px dotted black;">
                                        <div style="font-size: 12px;">
                                            <div class="row ">
                                                <div class="col-md-3 col-3 ">
                                                    <strong>Nombre:</strong>
                                                </div>
                                                <div class="col-md-9 col-9" style="text-align: right;">
                                                    <span> <strong style="color: gray;"><?php echo $row['nombre']; ?></strong></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-3 col-4">
                                                    <strong>Cedula:</strong>
                                                </div>
                                                <div class="col-md-9 col-8" style="text-align: right;">
                                                    <span><?php echo $row['cedula']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-3 col-4">
                                                    <strong>Telefono:</strong>
                                                </div>
                                                <div class="col-md-9 col-8" style="text-align: right;">
                                                    <span><?php echo $row['telefono']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-3 col-3">
                                                    <strong>Correo:</strong>
                                                </div>
                                                <div class="col-md-9 col-9" style="text-align: right;">
                                                    <span><?php echo $row['correo']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-5">
                                        <h6 class="mt-3">DATOS DE ENVIO:</h6>
                                        <hr class="mt-0" style="border-top: 2px dotted black;">
                                        <div style="font-size: 12px;">
                                            <div class="row ">
                                                <div class="col-md-3 col-3">
                                                    <strong>Destino:</strong>
                                                </div>
                                                <div class="col-md-9 col-9" style="text-align: right;">
                                                    <span><?php echo $row['destino']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-3 col-4">
                                                    <strong>Dirección:</strong>
                                                </div>
                                                <div class="col-md-9 col-8" style="text-align: right;">
                                                    <span><?php echo $row['direccion']; ?></span>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div class="col-md-5 col-6">
                                                    <strong>Observacion</strong>
                                                </div>
                                                <div class="col-md-7 col-6" style="text-align: right;">
                                                    <span><?php echo $row['observacion']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <hr class="bg-gray-400 my-4">
                            </form>

                            <div class="row">
                                <div class="col-xl-6">
                                </div>
                                <div class="col-xl-6 text-end">


                                    <a class="btn btn-warning px-5 radius-30" href="#!" data-bs-toggle="modal" data-bs-target="#editar_venta">
                                        <i class="far fa-edit me-2" ></i>Actualizar datos de orden
                                    </a>

                                    <div class="modal fade" id="editar_venta" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xl">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar orden</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation text-start" novalidate="" method="POST" action="script/venta-editar.php">
                                                    <input class="form-control" type="text" required="" name="id_venta" value="<?php echo $id_venta; ?>"  hidden>
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <h6 class="mt-3"><b>Datos facturacion:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <style>
                                                                    .inputcss{
                                                                        color: brown;
                                                                        font-weight: 500;
                                                                    }
                                                                </style>


                                                                <?php
                                                                if ($row['estado'] != 'Proceso') {
                                                                    $readonly = '';
                                                                } else {
                                                                    $readonly = '';
                                                                }
                                                                ?>


                                                                <div class="row ">
                                                                    <div class="col-md-12">
                                                                        <label class="form-label" for="validationCustom01">Fecha:</label>
                                                                        <input class="form-control inputcss"  type="date" name="fecha" value="<?php echo $row['fecha']; ?>" <?php echo $readonly; ?>  required="">
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un fecha para el pedido.</div>
                                                                    </div>
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Nompre tercero:</label>


                                                                        <select class="form-select choices-1 " id="validationCustom04" required="" name="nombre_tercero" <?php echo $readonly; ?>>
                                                                            <option value="<?php echo $row['nombre_tercero']; ?>"><?php echo $row['nombre_tercero']; ?></option>
                                                                            <option disabled="" value="">Seleccione</option>
                                                                            <option value="VARIOS">VARIOS</option>
                                                                            <?php
                                                                            $sql6m = "SELECT * FROM tercero";
                                                                            $query6m = $conn->query($sql6m);
                                                                            if ($query6m->num_rows > 0) {
                                                                                while ($row6m = $query6m->fetch_assoc()) {
                                                                                    ?>

                                                                                    <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </select>


                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div>
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom02">No Pedido:</label>
                                                                        <input class="form-control inputcss "   type="text" required="" name="numero_pedido" value="<?php echo $row['numero_pedido']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite un numero de pedido.</div>
                                                                    </div>
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom02">No Remision:</label>
                                                                        <input class="form-control inputcss "   type="text" required="" name="numero_remision" value="<?php echo $row['numero_remision']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite un numero de remision.</div>
                                                                    </div>                                       

                                                                </div>
                                                            </div>


                                                            <div class="col-md-6">
                                                                <h6 class="mt-3"><b>Datos del cliente:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <div class="row ">
                                                                    <div class="col-md-4">
                                                                        <label class="form-label" for="validationCustom01">Cedula o Nit:</label>
                                                                        <input class="form-control inputcss"   type="text" required="" name="cedula" placeholder="**********" value="<?php echo $row['cedula']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite una cedula valida de lo contrario rellene con "No aplica"</div>
                                                                    </div>
                                                                    <div class="col-md-8 ">
                                                                        <label class="form-label" for="validationCustom02">Nombre cliente:</label>
                                                                        <input class="form-control inputcss"   type="text" required="" name="nombre" placeholder="Nombres y apellidos" value="<?php echo $row['nombre']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite nombres y apellidos.</div>
                                                                    </div>
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Dirección:</label>
                                                                        <textarea class="form-control inputcss"   type="text" required="" name="direccion" placeholder="Cll, Av, Mz 0E-00E Barrio" <?php echo $readonly; ?>><?php echo $row['direccion']; ?></textarea>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite la direccion del cliente.</div>
                                                                    </div>
                                                                    <div class="col-md-8 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Destino:</label>
                                                                        <input class="form-control inputcss"  type="text" required="" name="destino" placeholder="Ciudad - Departamento" value="<?php echo $row['destino']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite el destino.</div>
                                                                    </div>
                                                                    <div class="col-md-4 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Telefono:</label>
                                                                        <input class="form-control inputcss"  type="text" required="" name="telefono" placeholder="5555555555 - 5555555555" value="<?php echo $row['telefono']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite uno o dos numero de contacto.</div>
                                                                    </div>
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Correo:</label>
                                                                        <input class="form-control inputcss" type="text" required="" name="correo" placeholder="alguien@example.com" value="<?php echo $row['correo']; ?>" <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite un correo valido de lo contrario rellene con "No aplica".</div>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                            <div class="col-md-4">
                                                                <h6 class="mt-3"><b>Datos de envio:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <div class="row ">
                                                                    <div class="col-md-6">
                                                                        <label class="form-label" for="validationCustom01">Transportadora:</label>


                                                                        <select class="form-select choices-1 " id="validationCustom04" required="" name="tercero_transportadora" <?php echo $readonly; ?> >

                                                                            <?php
                                                                            if ($row['tercero_transportadora'] == NULL) {
                                                                                ?>
                                                                                <option value="No aplica">No aplica</option>
                                                                                <?php
                                                                            } else {
                                                                                ?>
                                                                                <option value="<?php echo $row['tercero_transportadora']; ?>" > <?php echo $row['tercero_transportadora']; ?></option>
                                                                                <?php
                                                                            }
                                                                            ?>

                                                                            <option disabled="" value="">Seleccione</option>
                                                                            <option value="No aplica">No aplica</option>
                                                                            <?php
                                                                            $sql7m = "SELECT * FROM tercero WHERE rol='Transporte' AND nombre!='VARIO'";
                                                                            $query7m = $conn->query($sql7m);
                                                                            if ($query7m->num_rows > 0) {
                                                                                while ($row7m = $query7m->fetch_assoc()) {
                                                                                    ?>

                                                                                    <option value="<?php echo $row7m['nombre'] ?>"><?php echo $row7m['nombre'] ?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </select>



                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione una transportadora.</div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="form-label" for="validationCustom01">Recaudadora:</label>



                                                                        <select class="form-select choices-1 " id="validationCustom04" required="" name="tercero_recaudadora" <?php echo $readonly; ?> >
                                                                            <?php
                                                                            if ($row['tercero_recaudadora'] == NULL) {
                                                                                ?>
                                                                                <option value="No aplica">No aplica</option>
                                                                                <?php
                                                                            } else {
                                                                                ?>
                                                                                <option value="<?php echo $row['tercero_recaudadora']; ?>"><?php echo $row['tercero_recaudadora']; ?></option>
                                                                                <?php
                                                                            }
                                                                            ?>           
                                                                            <option disabled="" value="">Seleccione</option>
                                                                            <option value="No aplica">No aplica</option>
                                                                            <?php
                                                                            $sql8m = "SELECT * FROM tercero WHERE rol='Recaudador' AND nombre!='VARIO'";
                                                                            $query8m = $conn->query($sql8m);
                                                                            if ($query8m->num_rows > 0) {
                                                                                while ($row8m = $query8m->fetch_assoc()) {
                                                                                    ?>

                                                                                    <option value="<?php echo $row8m['nombre'] ?>"><?php echo $row8m['nombre'] ?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </select>



                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione una transportadora.</div>
                                                                    </div>
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom02">No Guia:</label>
                                                                        <input class="form-control inputcss"  type="text" required="" name="numero_guia" value="<?php echo $row['numero_guia']; ?>">
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite un numero de guia.</div>
                                                                    </div>
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label"  for="validationCustom02">Flete cliente:</label>
                                                                        <input class="form-control inputcss"  id="flete"  type="text" required="" name="flete_cliente" value="<?php echo $row['flete_cliente']; ?>"  <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite costo del flete a cargo del cliente.</div>
                                                                    </div>
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Flete empresa:</label>
                                                                        <input class="form-control inputcss" id="flete1"  type="text" required="" name="flete_empresa" value="<?php echo $row['flete_empresa']; ?>"  <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite costo del flete a cargo de la empresa.</div>
                                                                    </div>
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Caja | Flete empresa:</label>


                                                                        <select class="form-select"  required="" name="caja_flete"  <?php echo $readonly; ?>>                                           
                                                                            <optgroup label="Cajas">
                                                                                <?php
                                                                                if ($row['caja_flete'] == NULL) {
                                                                                    ?>
                                                                                    <option value="No aplica">No aplica</option>
                                                                                    <?php
                                                                                } else {
                                                                                    ?>
                                                                                    <option value="<?php echo $row['caja_flete']; ?>"><?php echo $row['caja_flete']; ?></option>
                                                                                    <?php
                                                                                }
                                                                                ?>     
                                                                                <option value="No aplica">No aplica</option>
                                                                                <?php
                                                                                $sql5 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                                $query5 = $conn->query($sql5);
                                                                                if ($query5->num_rows > 0) {
                                                                                    while ($row5 = $query5->fetch_assoc()) {
                                                                                        ?>
                                                                                        <option class="text-sm" value="<?php echo $row5['nombre']; ?>"><?php echo $row5['nombre']; ?></option>
                                                                                        <?php
                                                                                    }
                                                                                }
                                                                                ?>
                                                                            </optgroup>
                                                                        </select>  

                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div> 
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom02">Observación:</label>
                                                                        <textarea class="form-control inputcss"   type="text" required="" name="observacion"  placeholder="Complemento para direccion u observacion"  <?php echo $readonly; ?>><?php echo $row['observacion']; ?></textarea>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, Digite una descripcion para la orden.</div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <h6 class="mt-3"><b>Modo de pago:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <style>
                                                                    .inputcss{
                                                                        color: brown;
                                                                        font-weight: 500;
                                                                    }
                                                                </style>

                                                                <div class="row ">
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Modo de pago:</label>



                                                                        <select class="form-select choices-1 " id="validationCustom04" required="" name="modo_pago"  <?php echo $readonly; ?>>
                                                                            <option value="<?php echo $row['modo_pago'] ?>"><?php echo $row['modo_pago'] ?></option>
                                                                            <option disabled="" value="">Seleccione</option>
                                                                            <option value="Contado">Contado</option>
                                                                            <option value="Credito">Credito</option>
                                                                        </select>


                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div>                                      
                                                                </div>
                                                            </div>

                                                            <div class="col-md-5">
                                                                <h6 class="mt-3"><b>Abono para venta:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <style>
                                                                    .inputcss{
                                                                        color: brown;
                                                                        font-weight: 500;
                                                                    }
                                                                </style>

                                                                <div class="row ">
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Monto abono venta:</label>
                                                                        <input class="form-control inputcss"  id="flete"  type="text" required="" name="abono_venta" value="<?php echo $row['abono_venta'] ?>"  <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div> 

                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Caja | Abono:</label>


                                                                        <select class="form-select"  required="" name="caja_abono_venta"  <?php echo $readonly; ?>>   

                                                                            <optgroup label="Cajas">
                                                                                <?php
                                                                                if ($row['caja_abono_venta'] == NULL) {
                                                                                    ?>
                                                                                    <option value="No aplica">No aplica</option>
                                                                                    <?php
                                                                                } else {
                                                                                    ?>
                                                                                    <option value="<?php echo $row['caja_abono_venta']; ?>"><?php echo $row['caja_abono_venta']; ?></option>
                                                                                    <?php
                                                                                }
                                                                                ?>          
                                                                                <option value="No aplica">No aplica</option>

                                                                                <?php
                                                                                $sql6 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                                $query6 = $conn->query($sql6);
                                                                                if ($query6->num_rows > 0) {
                                                                                    while ($row6 = $query6->fetch_assoc()) {
                                                                                        ?>
                                                                                        <option class="text-sm" value="<?php echo $row6['nombre']; ?>"><?php echo $row6['nombre']; ?></option>
                                                                                        <?php
                                                                                    }
                                                                                }
                                                                                ?>
                                                                            </optgroup>
                                                                        </select> 


                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div> 

                                                                </div>
                                                            </div>



                                                            <div class="col-md-5">
                                                                <h6 class="mt-3"><b>Abono para flete:</b></h6>
                                                                <hr class="mt-0" style="border-top: 2px dotted black;">
                                                                <style>
                                                                    .inputcss{
                                                                        color: brown;
                                                                        font-weight: 500;
                                                                    }
                                                                </style>

                                                                <div class="row ">
                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Monto abono flete:</label>
                                                                        <input class="form-control inputcss"  id="flete"  type="text" required="" name="abono_flete" value="<?php echo $row['abono_flete'] ?>"  <?php echo $readonly; ?>>
                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div> 

                                                                    <div class="col-md-6 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Caja | Abono flete:</label>


                                                                        <select class="form-select"  required="" name="caja_abono_flete"  <?php echo $readonly; ?>>   

                                                                            <optgroup label="Cajas">
                                                                                <?php
                                                                                if ($row['caja_abono_flete'] == NULL) {
                                                                                    ?>
                                                                                    <option value="No aplica">No aplica</option>
                                                                                    <?php
                                                                                } else {
                                                                                    ?>
                                                                                    <option value="<?php echo $row['caja_abono_flete']; ?>"><?php echo $row['caja_abono_flete']; ?></option>
                                                                                    <?php
                                                                                }
                                                                                ?>          
                                                                                <option value="No aplica">No aplica</option>

                                                                                <?php
                                                                                $sql6 = "SELECT * FROM caja ORDER BY nombre desc";
                                                                                $query6 = $conn->query($sql6);
                                                                                if ($query6->num_rows > 0) {
                                                                                    while ($row6 = $query6->fetch_assoc()) {
                                                                                        ?>
                                                                                        <option class="text-sm" value="<?php echo $row6['nombre']; ?>"><?php echo $row6['nombre']; ?></option>
                                                                                        <?php
                                                                                    }
                                                                                }
                                                                                ?>
                                                                            </optgroup>
                                                                        </select> 


                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div> 

                                                                </div>
                                                            </div>

                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-warning px-5 radius-30" >Guardar cambios</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>


                            <style>
                                .ancho{
                                    width: 2.5%;
                                    text-align: center;
                                }

                                #hover_enlace:hover{
                                    color: orange;
                                    border-radius: 10px; border: lightcoral 1px solid;
                                    box-shadow: 0px 0px 5px 0px lightcoral;
                                }
                            </style>
                            <div class="table-responsive mt-3">
                                <table class="table table-hover text-sm table-sm table-striped table-bordered">
                                    <thead>
                                        <tr class="bg-light-primary text-primary">
                                            <th class="text-center p-1 " style="width: 30%;" >Referencia</th>
                                            <?php
                                            for ($f = 34; $f < 44; $f++) {
                                                ?>
                                                <th class="text-center p-1"><?php echo $f; ?></th>
                                                <?php
                                            }
                                            ?>
                                            <th class="text-center p-1">T. Prda</th>
                                            <th class="text-center p-1">VR. Unit</th>
                                            <th class="text-center p-1">VR. Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $total_cantidad = 0;
                                        $total_venta = 0;
                                        $sql1 = "SELECT * FROM venta_detalle WHERE id_venta='" . $row['id'] . "' GROUP BY referencia_producto, precio_unidad";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {

                                                $sql2 = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                                $query2 = $conn->query($sql2);
                                                $row2 = $query2->fetch_assoc();

                                                ////CANTIDAD POR REFERENCIA
                                                $sqlCANT = "SELECT SUM(cantidad) as cantidad_referencia FROM venta_detalle WHERE id_venta='" . $row['id'] . "' AND referencia_producto='" . $row1['referencia_producto'] . "'  AND precio_unidad='" . $row1['precio_unidad'] . "'";
                                                $queryCANT = $conn->query($sqlCANT);
                                                $rowCANT = $queryCANT->fetch_assoc();
                                                ?>
                                                <tr class="align-middle">
                                                    <td> 
                                                        <strong class="text-primary"><?php echo $row2['referencia']; ?></strong> - 
                                                        <span class="text-muted text-sm"><?php echo $row2['categoria']; ?></span><br>
                                                    </td>

                                                    <?php
                                                    for ($i = 34; $i < 44; $i++) {

                                                        $sqlt4 = "SELECT SUM(cantidad) as suma_talla FROM venta_detalle WHERE id_venta='" . $row['id'] . "' AND referencia_producto='" . $row1['referencia_producto'] . "' AND talla='$i' AND precio_unidad='" . $row1['precio_unidad'] . "'";
                                                        $queryt4 = $conn->query($sqlt4);
                                                        $rowt4 = $queryt4->fetch_assoc();

                                                        $suma_talla = $rowt4['suma_talla'];
                                                        ?>
                                                        <td class="ancho">

                                                            <?php
                                                            if ($row['estado'] != "Proceso") {
                                                                ?>
                                                                <?php echo $suma_talla; ?>

                                                                <?php
                                                            } else {
                                                                ?>
                                                                <a href="script/venta-talla-eliminar.php?referencia_producto=<?php echo $row1['referencia_producto']; ?>&&id_venta=<?php echo $id_venta; ?>&&precio_unidad=<?php echo $row1['precio_unidad'] ?>&&talla=<?php echo $i; ?>" 
                                                                   onclick="if (!confirm('Seguro deseas elminar este registro?')) {
                                                                                               return false
                                                                                           }" style="color: black; text-decoration: none;">

                                                                    <div id="hover_enlace" >
                                                                        <?php echo $suma_talla; ?>
                                                                    </div>

                                                                </a>

                                                                <?php
                                                            }
                                                            ?>

                                                        </td>
                                                        <?php
                                                    }
                                                    ?>



                                                    <td class="text-center"><?php echo $rowCANT['cantidad_referencia']; ?></td>  
                                                    <td class="" style="text-align: right;">


                                                        <?php
                                                        if ($row['estado'] != "Proceso") {
                                                            ?>
                                                            $ <?php echo number_format($row1['precio_unidad'], 0, '.', ','); ?>

                                                            <?php
                                                        } else {
                                                            ?>
                                                            <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar_precio"
                                                               data-id_venta="<?php echo $id_venta; ?>"
                                                               data-referencia_producto="<?php echo $row1['referencia_producto']; ?>"
                                                               data-precio_unidad="<?php echo $row1['precio_unidad']; ?>">

                                                                <div id="hover_enlace" >
                                                                    $ <?php echo number_format($row1['precio_unidad'], 0, '.', ','); ?>
                                                                </div>

                                                            </a>
                                                            <?php
                                                        }
                                                        ?>



                                                    </td> 
                                                    <td class="" style="text-align: right; ">$ <?php echo number_format($rowCANT['cantidad_referencia'] * $row1['precio_unidad'], 0, '.', ','); ?></td>

                                                </tr>
                                                <?php
                                                $total_venta += $rowCANT['cantidad_referencia'] * $row1['precio_unidad'];
                                                $total_cantidad += $rowCANT['cantidad_referencia'];
                                            }
                                        }
                                        ?>

                                        <tr> 
                                            <td class="text-center p-0"  rowspan="4">
                                                <br>
                                                <strong>

                                                    <?php
                                                    if ($row['tercero_transportadora'] == 'Interrapidisimo transporte') {
                                                        ?>
                                                        <img src="../../img/LOGO-INTERRAPIDISIMO.jpg" width="120" class="" alt="" />
                                                        <?php
                                                    } elseif ($row['tercero_transportadora'] == 'Envia transporte') {
                                                        ?>
                                                        <img src="../../img/Envia.png" width="80" class="" alt="" />
                                                        <?php
                                                    } elseif ($row['tercero_transportadora'] == 'Aveonline trasnporte') {
                                                        ?>
                                                        <img src="../../img/Aveonline.png" width="200"  class="" alt="" />
                                                        <?php
                                                    } elseif ($row['tercero_transportadora'] == 'Servientrega transporte') {
                                                        ?>
                                                        <img src="../../img/Servientrega.png" width="120" class="" alt="" />
                                                        <?php
                                                    } elseif ($row['tercero_transportadora'] == NULL) {

                                                        echo 'No aplica';
                                                    } else {
                                                        echo $row['tercero_transportadora'];
                                                    }
                                                    ?> 
                                                </strong>
                                            </td>
                                            <td class="text-center" colspan="10" rowspan="4">
                                                <br>
                                                <br>
                                                <strong>Total prendas</strong>
                                            </td> 
                                            <td class="text-center" rowspan="4">
                                                <br>
                                                <br>
                                                <strong><?php echo $total_cantidad; ?></strong>
                                            </td> 
                                            <td class="text-center"><strong>SUBTOTAL</strong></td> 
                                            <td class="" style="text-align: right;"><strong>$ <?php echo number_format($total_venta, 0); ?></strong></td>
                                        </tr>

                                        <tr> 
                                            <td class="text-center"><strong>FLETE CLIENTE</strong></td> 
                                            <td class="" style="text-align: right;"><strong>$ <?php echo number_format($row['flete_cliente'], 0); ?></strong></td>
                                        </tr>
                                        <tr> 
                                            <td class="text-center" ><strong>ABONO A VENTA  </strong></td> 
                                            <td class="" style="text-align: right;"><strong>-$ <?php echo number_format($row['abono_venta'], 0); ?></strong></td>
                                        </tr>
                                        <tr>  
                                            <td class=" bg-secondary text-white text-center" style=""><strong>VR TOTAL</strong></td> 
                                            <td class=" bg-secondary text-white" style="text-align: right;"><strong>$ <?php echo number_format($total_venta + $row['flete_cliente'] - $row['abono_venta'], 0); ?></strong></td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>



                            <?php
                            if ($row['estado'] == 'Proceso') {
                                ?>

                                <form class=" g-3 needs-validation" method="POST" action="script/venta-referencia-guardar.php">
                                    <input class="form-control inputcss "   type="text" required="" name="id_venta" value="<?php echo $id_venta; ?>" hidden >
                                    <input class="form-control inputcss "   type="text" required="" name="estado" value="<?php echo $row['estado']; ?>" hidden>

                                    <div class="row">

                                        <div class="col-md-4">
                                            <select class="single-select" required="" name="referencia_producto" autofocus="">
                                                <option selected=""  value="">Referencias</option>
                                                <?php
                                                $sql4 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {
                                                        ?>

                                                        <option value="<?php echo $row4['referencia'] ?>"><?php echo $row4['referencia'] ?> - <?php echo $row4['marca']; ?> <?php echo $row4['categoria']; ?></option>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </select>
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, seleccione referencia.</div>
                                        </div>
                                        <div class="col-md-2">
                                            <select class="form-select " id="validationCustom04" required="" name="talla">
                                                <option selected="" disabled="" value="">Tallas</option>
                                                <?php
                                                for ($i = 34; $i < 44; $i++) {
                                                    ?>
                                                    <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, seleccione talla.</div>
                                        </div>
                                        <div class="col-md-2">
                                            <input class="form-control inputcss "   type="number" required="" name="cantidad" placeholder="cant." value="0">
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                        </div>
                                        <div class="col-md-2">
                                            <input class="form-control inputcss " id="precio_unitario"  type="text" required="" name="precio_unidad" placeholder="VR Unitario" value="0">
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, Digite precio por unidad.</div>
                                        </div> 
                                        <div class="col-md-2">
                                            <button class="btn btn-primary px-2 radius-30" style="width: 100%;" type="submit"><i class="fas fa-plus text-white"></i> Agregar Item</button>
                                        </div>
                                    </div> 
                                </form>
                                <!-- FIN TABA-->
                                <?php
                            } else {
                                
                            }
                            ?>
                            <hr class="bg-gray-400 my-4">
                            <div class="row">
                                <div class="col-xl-9"></div>
                                <div class="col-xl-3">

                                    <table class="table table-hover text-sm table-sm table-striped table-bordered" style="font-size: 18px;">
                                        <thead>                  
                                            <tr>
                                                <th>TOTAL ITEMS </th>
                                                <td class="text-end">$ <?php echo number_format($total_venta, 0); ?></td>
                                            </tr>
                                            <tr>
                                                <th>FLETE EMPRESA </th>
                                                <td class="text-end">- $ <?php echo number_format($row['flete_empresa'], 0); ?></td>
                                            </tr> 
                                            <tr>
                                                <th>ABONO A FLETE </th>
                                                <td class="text-end">$ <?php echo number_format($row['abono_flete'], 0); ?></td>
                                            </tr> 
                                            <tr class="bg-light-success text-success ">
                                                <th>TOTAL RECAUDADO </th>
                                                <?php
                                                $total_recaudado = $total_venta - $row['flete_empresa'] + $row['abono_flete'];
                                                ?>
                                                <th class="text-end">$ <?php echo number_format($total_recaudado, 0); ?></th>
                                            </tr>
                                        </thead> 

                                    </table>
                                </div> 
                            </div>



                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="card-header-more  mb-2">
                                        <div class="">
                                            <a href="#!" class="btn btn-primary px-5 radius-30 " data-bs-toggle="modal" data-bs-target="#cambio_add" >
                                                <i class="fas fa-boxes-packing opacity-5 me-2 text-titulo" ></i>Registrar cambios
                                            </a>
                                        </div>
                                    </div>

                                    <!-- Modal -->
                                    <div class="modal fade" id="cambio_add" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Registro cambio</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation" method="POST" action="script/novedad-guardar.php">
                                                    <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                                    <input type="text" required="" name="id_venta" value="<?php echo $id_venta; ?>" hidden>

                                                    <div class="modal-body ">
                                                        <div class="row ">
                                                            <div class="col-md-12">
                                                                <label class="form-label" for="validationCustom01">Fecha</label>
                                                                <input class="form-control" id="validationCustom01" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, seleccione una fecha.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Referencia</label>
                                                                <select class="form-select " id="validationCustom04" required="" name="referencia">
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <?php
                                                                    $sql21 = "SELECT * FROM venta_detalle WHERE id_venta='$id_venta' GROUP BY referencia_producto";
                                                                    $query21 = $conn->query($sql21);
                                                                    if ($query21->num_rows > 0) {
                                                                        while ($row21 = $query21->fetch_assoc()) {
                                                                            ?>

                                                                            <option value="<?php echo $row21['referencia_producto'] ?>">Talla <?php echo $row21['referencia_producto'] ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                            </div>

                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Talla</label>
                                                                <select class="form-select " id="validationCustom04" required="" name="talla">
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <?php
                                                                    $sql22 = "SELECT * FROM venta_detalle WHERE id_venta='$id_venta' GROUP BY talla";
                                                                    $query22 = $conn->query($sql22);
                                                                    if ($query22->num_rows > 0) {
                                                                        while ($row22 = $query22->fetch_assoc()) {
                                                                            ?>

                                                                            <option value="<?php echo $row22['talla'] ?>">Talla <?php echo $row22['talla'] ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustomUsername">Cantidad</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required="" name="cantidad" value="0">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Digite la cantidad de prendas.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3" hidden="">
                                                                <label class="form-label" for="validationCustom02">Tipo</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required=""  name="tipo" value="Normal" readonly="">

                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione el tipo de prenda.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Descripcion</label>
                                                                <textarea class="form-control" id="validationCustom02" type="text" required=""  name="descripcion">No aplica</textarea>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Digite una descripcion.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3" hidden="">
                                                                <label class="form-label" for="validationCustom02">Movimiento</label>
                                                                <select class="form-select" id="validationCustom04" required="" name="movimiento">
                                                                    <option  value="Entrada">Entrada</option> 
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione el movimiento que desea hacer.</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                        <button type="submit" class="btn btn-primary  radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-hover text-sm table-sm table-bordered table-striped" >
                                            <thead>
                                                <tr>
                                                    <th class=" p-1">Fecha</th>
                                                    <th class="text-center p-1">Referencia</th>
                                                    <th class="text-center p-1">Talla</th>
                                                    <th class="text-center p-1">Cantidad</th>
                                                    <th class=" p-1">Descripción</th>
                                                    <th class="text-center p-1">Movimiento</th>
                                                    <th class="text-center p-1">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql31 = "SELECT * FROM novedad WHERE  id_venta='$id_venta' ";
                                                $query31 = $conn->query($sql31);
                                                if ($query31->num_rows > 0) {
                                                    while ($row31 = $query31->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td class="text-center"><?php echo $row31['fecha'] ?></td>
                                                            <td class="text-center"><?php echo $row31['referencia_producto']; ?></td>
                                                            <td class="text-center">
                                                                <strong>T - <?php echo $row31['talla']; ?></strong>
                                                            </td>
                                                            <td class="text-center"><?php echo $row31['cantidad']; ?></td>
                                                            <td class=""><?php echo $row31['descripcion']; ?></td>
                                                            <td class="text-center">
                                                                <?php if ($row31['movimiento'] == 'Salida') { ?>
                                                                    <span class="badge alert-danger"><?php echo $row31['movimiento']; ?></span>
                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <span class="badge alert-success"><?php echo $row31['movimiento']; ?></span>

                                                                    <?php
                                                                }
                                                                ?>
                                                            </td>

                                                            <td class="text-center">


                                                                <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar_cambio<?php echo $row31['id'] ?>">
                                                                    <i class="far fa-edit opacity-5 me-2 text-warning"></i>
                                                                </a>

                                                                <div class="modal fade text-start" id="editar_cambio<?php echo $row31['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-sm">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Editar cambio</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/novedad-editar.php">
                                                                                <input  type="text" required="" name="edit_id" value="<?php echo $row31['id']; ?>"  hidden>
                                                                                <input type="text" required="" name="edit_nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                                                                <input class="form-control" type="text" required=""  name="edit_id_venta" value="<?php echo $id_venta; ?>" hidden >


                                                                                <div class="modal-body ">
                                                                                    <div class="row ">
                                                                                        <div class="col-md-12">
                                                                                            <label class="form-label" for="validationCustom01">Fecha</label>
                                                                                            <input class="form-control"  type="date" required="" name="edit_fecha" value="<?php echo $row31['fecha']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, seleccione una fecha.</div>
                                                                                        </div>
                                                                                        <div class="col-md-12 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Referencia</label>
                                                                                            <select class="form-select "  required="" name="edit_referencia" >
                                                                                                <option selected value="<?php echo $row31['referencia_producto']; ?>"><?php echo $row31['referencia_producto']; ?></option>
                                                                                                <option disabled="" value="">Seleccione</option>
                                                                                                <?php
                                                                                                $sql32 = "SELECT * FROM venta_detalle WHERE id_venta='$id_venta' GROUP BY referencia_producto";
                                                                                                $query32 = $conn->query($sql32);
                                                                                                if ($query32->num_rows > 0) {
                                                                                                    while ($row32 = $query32->fetch_assoc()) {
                                                                                                        ?>

                                                                                                        <option value="<?php echo $row32['referencia_producto'] ?>">Talla <?php echo $row32['referencia_producto'] ?></option>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                                ?>
                                                                                            </select>
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                                                        </div>
                                                                                        <div class="col-md-6 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Talla</label>
                                                                                            <select class="form-select "  required="" name="edit_talla" >
                                                                                                <option selected value="<?php echo $row31['talla']; ?>"><?php echo $row31['talla']; ?></option>
                                                                                                <option disabled="" value="">Seleccione</option>
                                                                                                <?php
                                                                                                $sql33 = "SELECT * FROM venta_detalle WHERE id_venta='$id_venta' GROUP BY talla";
                                                                                                $query33 = $conn->query($sql33);
                                                                                                if ($query33->num_rows > 0) {
                                                                                                    while ($row33 = $query33->fetch_assoc()) {
                                                                                                        ?>

                                                                                                        <option value="<?php echo $row1['talla'] ?>">Talla <?php echo $row1['talla'] ?></option>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                                ?>
                                                                                            </select>
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                                                        </div>
                                                                                        <div class="col-md-6 mt-3">
                                                                                            <label class="form-label" for="validationCustomUsername">Cantidad</label>
                                                                                            <input class="form-control"  type="text" required="" name="edit_cantidad" id="edit_cantidad" value="<?php echo $row31['cantidad']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Digite la cantidad de prendas.</div>
                                                                                        </div>
                                                                                        <div class="col-md-12 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Descripcion</label>
                                                                                            <textarea class="form-control"  type="text" required=""  name="edit_descripcion" id="edit_descripcion"><?php echo $row31['descripcion']; ?></textarea>
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Digite una descripcion.</div>
                                                                                        </div>

                                                                                        <div class="col-md-12 mt-3" hidden="">
                                                                                            <label class="form-label" for="validationCustom02">Movimiento</label>
                                                                                            <input class="form-control"  type="text" required="" name="edit_movimiento" id="edit_movimiento" readonly="" value="<?php echo $row31['movimiento']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Seleccione el movimiento que desea hacer.</div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                                                    <button type="submit" class="btn btn-warning  radius-30" >Guardar cambios</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                                <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#eliminar_cambio<?php echo $row31['id'] ?>">
                                                                    <i class="far fa-trash-alt opacity-5 me-2 text-danger"></i>        
                                                                </a>

                                                                <div class="modal fade" id="eliminar_cambio<?php echo $row31['id'] ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Eliminar cambio</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/novedad-eliminar.php">
                                                                                <input class="form-control" type="text" required=""  name="delete_id_venta" value="<?php echo $id_venta; ?>" hidden >

                                                                                <input class="form-control" type="text" required="" name="delete_id"  value="<?php echo $row31['id'] ?>" hidden>
                                                                                <div class="modal-body row">
                                                                                    <div class="col-md-12">
                                                                                        <label class="form-label" for="validationCustom01">¿Estas seguro que deseas eliminar este registro?</label>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                                                    <button type="submit" class="btn btn-danger  radius-30" >Eliminar</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>



                                </div>
                            </div>


                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-sm-4">

                                    <h6 ><b>GUIA DE SEGUIMIENTO:</b></h6>


                                    <style>
                                        #hover_enlace:hover{
                                            color: #923EB9;
                                            border-radius: 6px; border: #923EB9 1px solid;
                                            box-shadow: 0px 0px 5px 0px #923EB9;
                                        }

                                    </style>



                                    <?php
                                    if ($row['documento_guia'] == 'No aplica') {
                                        ?>
                                        <form  method="POST" action="script/upload.php"  enctype="multipart/form-data">
                                            <input type="text" class="form form-control" name="id_venta" value="<?php echo $id_venta; ?>" hidden>

                                            <div id="hover_enlace">
                                                <input type="file" name="file" class="dropify"/>
                                            </div>
                                            <div class="text-right mt-1 text-end">
                                                <button id="payment-button" type="submit" name="editar" class="btn btn-primary px-2 radius-30">
                                                    <span id="payment-button-amount">Guardar Guia</span>
                                                </button>
                                            </div>

                                        </form>
                                        <?php
                                    } else {
                                        ?>

                                        <div class="card mb-4">

                                            <iframe src="../../img-guia-transportadora/<?php echo $row['documento_guia']; ?>" style="width:100%; height:200px;" frameborder="0" ></iframe>

                                            <div class="card-body p-3 p-lg-4">

                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <a   href="#!"  data-bs-toggle="modal" data-bs-target="#foto">
                                                            <h6 class="card-title fw-bold mb-1">MEJOR VISTA </h6>
                                                            <strong class="card-title fw-bold mb-1 text-black"># <?php echo $row['numero_guia']; ?> </strong>
                                                        </a>
                                                    </div>
                                                    <div class="col-sm-6 text-end">
                                                        <a class="text-black"   href="script/upload-eliminar.php?id_venta=<?php echo $id_venta; ?>" 
                                                           onclick="if (!confirm('Seguro deseas elminar esta guia?')) {
                                                                           return false
                                                                       }" >
                                                            Remover
                                                        </a>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- Modal -->
                                        <div class="modal fade" id="foto" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title card-heading" id="exampleModalLabel">Guia <?php echo $row['tercero_transportadora']; ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form class=" g-3 needs-validation" >
                                                        <input class="form-control"  type="text" value="<?php echo $rowusu['nombre']; ?>" name="nombre_usuario" required="" hidden>

                                                        <div class="modal-body ">
                                                            <iframe src="../../img-guia-transportadora/<?php echo $row['documento_guia']; ?>" style="width:100%; height:700px;" frameborder="0" ></iframe>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                    ?>

                                </div>

                                <div class="col-sm-4">

                                    <h6 ><b>COMPROBANTE | ABONO VENTA:</b></h6>


                                    <style>
                                        #hover_enlace:hover{
                                            color: #923EB9;
                                            border-radius: 6px; border: #923EB9 1px solid;
                                            box-shadow: 0px 0px 5px 0px #923EB9;
                                        }

                                    </style>



                                    <?php
                                    if ($row['documento_abono_venta'] == 'No aplica') {
                                        ?>
                                        <form  method="POST" action="script/upload-abono-venta.php"  enctype="multipart/form-data">
                                            <input type="text" class="form form-control" name="id_venta" value="<?php echo $id_venta; ?>" hidden>

                                            <div id="hover_enlace">
                                                <input type="file" name="file" class="dropify"/>
                                            </div>
                                            <div class="text-right mt-1 text-end">
                                                <button id="payment-button" type="submit" name="editar" class="btn btn-primary px-2 radius-30">
                                                    <span id="payment-button-amount">Guardar comprobante | Abono venta</span>
                                                </button>
                                            </div>

                                        </form>
                                        <?php
                                    } else {
                                        ?>

                                        <div class="card mb-4">

                                            <iframe src="../../img-abono-venta/<?php echo $row['documento_abono_venta']; ?>" style="width:100%; height:200px;" frameborder="0" ></iframe>

                                            <div class="card-body p-3 p-lg-4">

                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <a   href="#!"  data-bs-toggle="modal" data-bs-target="#foto-abono-venta">
                                                            <h6 class="card-title fw-bold mb-1">MEJOR VISTA </h6>
                                                            <strong class="card-title fw-bold mb-1 text-black"> </strong>
                                                        </a>
                                                    </div>
                                                    <div class="col-sm-6 text-end">
                                                        <a class="text-black"   href="script/upload-eliminar-abono-venta.php?id_venta=<?php echo $id_venta; ?>" 
                                                           onclick="if (!confirm('Seguro deseas elminar esta guia?')) {
                                                                           return false
                                                                       }" >
                                                            Remover
                                                        </a>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- Modal -->
                                        <div class="modal fade" id="foto-abono-venta" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title card-heading" id="exampleModalLabel">Abono de venta</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form class=" g-3 needs-validation" novalidate="">
                                                        <input class="form-control"  type="text" value="<?php echo $rowusu['nombre']; ?>" name="nombre_usuario" required="" hidden>

                                                        <div class="modal-body ">
                                                            <iframe src="../../img-abono-venta/<?php echo $row['documento_abono_venta']; ?>" style="width:100%; height:700px;" frameborder="0" ></iframe>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                    ?>

                                </div>


                                <div class="col-sm-4">

                                    <h6 ><b>COMPROBANTE | ABONO FLETE:</b></h6>


                                    <style>
                                        #hover_enlace:hover{
                                            color: #923EB9;
                                            border-radius: 6px; border: #923EB9 1px solid;
                                            box-shadow: 0px 0px 5px 0px #923EB9;
                                        }

                                    </style>



                                    <?php
                                    if ($row['documento_abono_flete'] == 'No aplica') {
                                        ?>
                                        <form  method="POST" action="script/upload-abono-flete.php"  enctype="multipart/form-data">
                                            <input type="text" class="form form-control" name="id_venta" value="<?php echo $id_venta; ?>" hidden>

                                            <div id="hover_enlace">
                                                <input type="file" name="file" class="dropify"/>
                                            </div>
                                            <div class="text-right mt-1 text-end">
                                                <button id="payment-button" type="submit" name="editar" class="btn btn-primary px-2 radius-30">
                                                    <span id="payment-button-amount">Guarda comprobante | Abono flete</span>
                                                </button>
                                            </div>

                                        </form>
                                        <?php
                                    } else {
                                        ?>

                                        <div class="card mb-4">

                                            <iframe src="../../img-abono-flete/<?php echo $row['documento_abono_flete']; ?>" style="width:100%; height:200px;" frameborder="0" ></iframe>

                                            <div class="card-body p-3 p-lg-4">

                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <a   href="#!"  data-bs-toggle="modal" data-bs-target="#foto-abono-flete">
                                                            <h6 class="card-title fw-bold mb-1">MEJOR VISTA </h6>
                                                            <strong class="card-title fw-bold mb-1 text-black"> </strong>
                                                        </a>
                                                    </div>
                                                    <div class="col-sm-6 text-end">
                                                        <a class="text-black"   href="script/upload-eliminar-abono-flete.php?id_venta=<?php echo $id_venta; ?>" 
                                                           onclick="if (!confirm('Seguro deseas elminar este documento?')) {
                                                                           return false
                                                                       }" >
                                                            Remover
                                                        </a>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- Modal -->
                                        <div class="modal fade" id="foto-abono-flete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title card-heading" id="exampleModalLabel">Abono de flete</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form class=" g-3 needs-validation" novalidate="">
                                                        <input class="form-control"  type="text" value="<?php echo $rowusu['nombre']; ?>" name="nombre_usuario" required="" hidden>

                                                        <div class="modal-body ">
                                                            <iframe src="../../img-abono-flete/<?php echo $row['documento_abono_flete']; ?>" style="width:100%; height:700px;" frameborder="0" ></iframe>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                    ?>

                                </div>


                            </div>

                            <script>

                                $('.dropify').dropify();


                            </script>

                            <div class="text-center">


                                <?php
                                $sql3 = "UPDATE venta SET total_venta='$total_venta' WHERE id='$id_venta'";
                                if ($conn->query($sql3) === TRUE) {
                                    echo 'Atualizacion Exitosa';
                                } else {
                                    echo "Error: " . $sql3 . "<br>" . $conn->error;
                                }
                                ?>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <div class="modal fade" id="editar_precio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar precio</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/venta-precio-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id_venta" id="edit_id_venta" hidden>
                        <div class="modal-body ">
                            <div class="row ">
                                <div class="col-md-6">
                                    <label class="form-label" for="validationCustom01">Referencia:</label>
                                    <input class="form-control" type="text" required="" name="edit_referencia_producto" id="edit_referencia_producto" readonly>
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, Digite la referencia.</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label" for="validationCustom01">Precio actual:</label>
                                    <input class="form-control" type="text" required="" name="edit_precio_unidad" id="edit_precio_unidad" readonly>
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, Digite precio actual.</div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <label class="form-label" for="validationCustom01">Precio unitario:</label>
                                    <input class="form-control" type="text" required="" name="edit_precio_unidad_nuevo" id="precio_unitario_nuevo">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, Digite el precio nuevo.</div>
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary px-5 radius-30" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary px-5 radius-30" >Guardar cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#editar_precio').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id_venta = button.data('id_venta')
                var referencia_producto = button.data('referencia_producto')
                var precio_unidad = button.data('precio_unidad')


                $('#edit_id_venta').val(id_venta)
                $('#edit_referencia_producto').val(referencia_producto)
                $('#edit_precio_unidad').val(precio_unidad)
            });

        </script>

    </body>
</html>