<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$fecha = $_GET['fecha'];
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="venta.php"> 
                                    Ventas
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $fecha; ?></li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body">
                            
                            <div class="table-responsive mt-2">
                                <table class="table align-middle mb-0 table-striped table-hover" id="example2">
                                    <thead class="table-light">
                                        <tr class="bg-light-primary text-primary">
                                            <th class="text-center p-1">Id</th>
                                            <th class=" p-1">Cliente</th>
                                            <th class=" p-1">Contacto</th>
                                            <th class=" p-1">Ubicacion</th>
                                            <th class=" p-1">Transportadora</th>
                                            <th class=" p-1">Fletes</th>
                                            <th class=" p-1">Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM venta WHERE fecha='$fecha'  ORDER BY id desc ";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <tr class="align-middle"  style="cursor: pointer;"

                                                    onclick=" window.location = 'venta-detalle.php?id_venta=<?php echo $row['id']; ?> ';">
                                                    <td>
                                                        <strong class="text-primary">
                                                            ODP <?php echo $row['id']; ?>
                                                        </strong>
                                                    </td>
                                                    <td>
                                                        <i class=" fas fa-user"></i> <strong><?php echo $row['nombre']; ?></strong><br>
                                                        <i class=" fas fa-id-card"></i> <span class="text-muted"><?php echo $row['cedula'] ?></span><br>
                                                    </td>
                                                    <td class="">
                                                        <i class=" fas fa-phone"></i> <span class="text-muted"><?php echo $row['telefono']; ?></span><br>
                                                        <i class=" fas fa-envelope"></i> <span class="text-muted"><?php echo $row['correo']; ?></span>
                                                    </td>
                                                    <td class="">
                                                        <i class=" fas fa-map-marker-alt"></i>
                                                        <strong title="<?php echo $row['direccion']; ?>"><?php echo $row['destino']; ?></strong><br>
                                                    </td>
                                                    <td class="" style="min-width: 125px;">
                                                        <strong>

                                                            <?php
                                                            if ($row['tercero_transportadora'] == 'Interrapidisimo transporte') {
                                                                ?>
                                                                <img src="../../img/LOGO-INTERRAPIDISIMO.jpg" width="120" class="" alt="" />
                                                                <?php
                                                            } elseif ($row['tercero_transportadora'] == 'Envia transporte') {
                                                                ?>
                                                                <img src="../../img/Envia.png" width="80" class="" alt="" />
                                                                <?php
                                                            } elseif ($row['tercero_transportadora'] == 'Aveonline trasnporte') {
                                                                ?>
                                                                <img src="../../img/Aveonline.png" width="100" class="" alt="" />
                                                                <?php
                                                            } elseif ($row['tercero_transportadora'] == 'Servientrega transporte') {
                                                                ?>
                                                                <img src="../../img/Servientrega.png" width="120" class="" alt="" />
                                                                <?php
                                                            } elseif ($row['tercero_transportadora'] == NULL) {

                                                                echo 'No aplica';
                                                            } else {
                                                                echo $row['tercero_transportadora'];
                                                            }
                                                            ?> 
                                                        </strong><br>
                                                        <span class="text-muted"><?php echo $row['numero_guia']; ?></span>
                                                    </td>
                                                    <td class="" style="min-width: 125px;">
                                                        <strong>Empresa: </strong><span class="text-muted "><?php echo number_format($row['flete_empresa'], 0, '.', ','); ?></span><br>
                                                        <strong>cliente: </strong><span class="text-muted "><?php echo number_format($row['flete_cliente'], 0, '.', ','); ?></span>
                                                    </td>
                                                    <td class="" style="min-width: 125px;">


                                                        <?php
                                                        if ($row['estado'] == 'Proceso') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-info';
                                                        } elseif ($row['estado'] == 'Confirmado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-pink';
                                                        } elseif ($row['estado'] == 'Alistamiento') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-primary';
                                                        } elseif ($row['estado'] == 'Enviado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-warning';
                                                        } elseif ($row['estado'] == 'Novedad') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-bronze';
                                                        } elseif ($row['estado'] == 'Entregado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-success';
                                                        } elseif ($row['estado'] == 'Cancelado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-secondary';
                                                        } elseif ($row['estado'] == 'Devolucion') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-dark';
                                                        } else {
                                                            $text = 'text-dark';
                                                        }
                                                        ?>

                                                        <span class="badge <?php echo $alert; ?>"><?php echo $row['estado'];?></span>

                                                        <br>
                                                        <strong >$ <?php echo number_format($row['total_venta'], 0, '.', ','); ?></strong><br>

                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>