<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Categoria de gastos</li>
                        </ol>
                    </nav>


                    <div class="row">
                        <div class="col-xl-12 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-9">

                                        </div>
                                        <div class="col-sm-3 text-end">
                                            <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#agregar" >
                                                Nueva categoria de gastos
                                            </a> 
                                        </div>
                                    </div>

                                    <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Agregar categoria</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/categoria-gasto-guardar.php">
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <label>Nombre categoria</label>
                                                                <input class="form-control" type="text" required="" name="categoria">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-info" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->


                    <div class="row">
                        <div class="col-sm-3"></div>
                        <div class="col-sm-6">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Lista | Categoria de gastos</h6>
                                    <hr/>
                                    <div class="table-responsive mt-2">
                                        <table class="table align-middle mb-0" id="example2" style="width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">Nombre categoria</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql = "SELECT * FROM categoria_gasto";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr>
                                                            <td><?php echo $row['categoria']; ?></td>
                                                            <td class="text-center">
                                                                <a href="#" 
                                                                   data-bs-toggle="modal" data-bs-target="#editar"
                                                                   data-id="<?php echo $row['id']; ?>"
                                                                   data-categoria="<?php echo $row['categoria']; ?>">
                                                                    <i class="far fa-edit opacity-5 me-4 text-warning"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

       <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar de categoria</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/categoria-gasto-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id" id="edit_id" hidden>
                        <div class="modal-body ">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label>Categoria</label>
                                    <input class="form-control" type="text" required="" name="edit_categoria" id="edit_categoria">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer ">
                            <button type="submit" class="btn btn-secondary" name="eliminar" 
                                    onclick="if (!confirm('Seguro deseas eliminar este registro?')) {
                                                return false

                                            }">Eliminar</button>
                            <button type="submit" class="btn btn-info" name="editar" >Editar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var categoria = button.data('categoria')

                $('#edit_id').val(id)
                $('#edit_categoria').val(categoria)
            });

        </script>
        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>