<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario      = post('nombre_usuario'); // lo recibes, aquí no se usa, lo dejo por compatibilidad
$nombre_tercero      = post('nombre_tercero');
$fecha               = post('fecha');
$referencia_producto = post('referencia_producto');
$talla               = post('talla');
$cantidad            = post('cantidad'); // no se usa en el DELETE, lo dejo por compatibilidad

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_tercero === '')      $errores[] = 'Falta nombre_tercero';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';
if ($talla === '')               $errores[] = 'Falta talla';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* 1) Delete seguro */
    $stmt = $conn->prepare("
        DELETE FROM cierre_pedido_detalle
        WHERE nombre_tercero = ?
          AND referencia_producto = ?
          AND talla = ?
          AND fecha = ?
    ");
    if (!$stmt) throw new Exception("Prepare delete: " . $conn->error);

    $stmt->bind_param("ssss", $nombre_tercero, $referencia_producto, $talla, $fecha);
    if (!$stmt->execute()) throw new Exception("Execute delete: " . $stmt->error);
    $stmt->close();

    /* 2) Recalcular */
    $class_referencia = $referencia_producto;
    $class_talla = $talla;
    require '../../../clases/class-referencia.php';

    $class_nombre_tercero_cierre = $nombre_tercero;
    $class_referencia_cierre = $referencia_producto;
    $class_talla_cierre = $talla;
    require '../../../clases/class-cierre.php';

    $conn->commit();

    // PRG redirect (usa &)
    header("Location: ../cierre-tercero-detalle.php?nombre_tercero=" . urlencode($nombre_tercero) . "&fecha=" . urlencode($fecha));
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
