<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

// Recomendado: solo POST (evita ejecutar por URL)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

try {
    $conn->begin_transaction();

    /*
      Traer todas las combinaciones únicas (nombre_tercero, referencia_producto, talla)
      desde pedidos, despachos y cierres existentes.
      Esto reemplaza los 3 loops + queries repetidas.
    */
    $sql = "
        SELECT DISTINCT nombre_tercero, referencia_producto, talla
        FROM (
            SELECT p.nombre_tercero AS nombre_tercero, pd.referencia_producto AS referencia_producto, pd.talla AS talla
            FROM pedido p
            JOIN pedido_detalle pd ON pd.id_pedido = p.id
            WHERE p.estado <> 'Cancelado'
              AND p.nombre_tercero IS NOT NULL AND p.nombre_tercero <> ''
              AND pd.referencia_producto IS NOT NULL AND pd.referencia_producto <> ''
              AND pd.talla IS NOT NULL AND pd.talla <> ''

            UNION ALL

            SELECT d.nombre_tercero AS nombre_tercero, dd.referencia_producto AS referencia_producto, dd.talla AS talla
            FROM despacho d
            JOIN despacho_detalle dd ON dd.id_despacho = d.id
            WHERE d.estado <> 'Cancelado'
              AND d.nombre_tercero IS NOT NULL AND d.nombre_tercero <> ''
              AND dd.referencia_producto IS NOT NULL AND dd.referencia_producto <> ''
              AND dd.talla IS NOT NULL AND dd.talla <> ''

            UNION ALL

            SELECT cd.nombre_tercero AS nombre_tercero, cd.referencia_producto AS referencia_producto, cd.talla AS talla
            FROM cierre_detalle cd
            WHERE cd.nombre_tercero IS NOT NULL AND cd.nombre_tercero <> ''
              AND cd.referencia_producto IS NOT NULL AND cd.referencia_producto <> ''
              AND cd.talla IS NOT NULL AND cd.talla <> ''
        ) x
    ";

    $res = $conn->query($sql);
    if (!$res) {
        throw new Exception("Query combinaciones falló: " . $conn->error);
    }

    while ($r = $res->fetch_assoc()) {
        $class_nombre_tercero_cierre = $r['nombre_tercero'];
        $class_referencia_cierre     = $r['referencia_producto'];
        $class_talla_cierre          = $r['talla'];

        require '../../../clases/class-cierre.php';
    }

    $conn->commit();

    header("Location: ../sincronizar-tercero.php?ok=1");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
