<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_tercero = post('nombre_tercero');
$fecha          = post('fecha');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_tercero === '') $errores[] = 'Falta nombre_tercero';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* 1) Obtener combinaciones únicas (referencia,talla) a recalcular */
    $stmtSel = $conn->prepare("
        SELECT DISTINCT referencia_producto, talla
        FROM cierre_detalle
        WHERE nombre_tercero = ? AND fecha = ?
    ");
    if (!$stmtSel) throw new Exception("Prepare select: " . $conn->error);

    $stmtSel->bind_param("ss", $nombre_tercero, $fecha);
    $stmtSel->execute();
    $resSel = $stmtSel->get_result();

    $pares = [];
    while ($row = $resSel->fetch_assoc()) {
        $pares[] = [$row['referencia_producto'], $row['talla']];
    }
    $stmtSel->close();

    // Si no hay nada que borrar, redirige igual
    if (!$pares) {
        $conn->commit();
        header("Location: ../cierre-tercero.php?nombre_tercero=" . urlencode($nombre_tercero));
        exit;
    }

    /* 2) Borrar TODO de una sola vez */
    $stmtDel = $conn->prepare("DELETE FROM cierre_detalle WHERE nombre_tercero = ? AND fecha = ?");
    if (!$stmtDel) throw new Exception("Prepare delete: " . $conn->error);

    $stmtDel->bind_param("ss", $nombre_tercero, $fecha);
    if (!$stmtDel->execute()) throw new Exception("Execute delete: " . $stmtDel->error);
    $stmtDel->close();

    /* 3) Recalcular cierre por cada par afectado */
    foreach ($pares as $p) {
        [$referencia_producto, $talla] = $p;

        $class_nombre_tercero_cierre = $nombre_tercero;
        $class_referencia_cierre = $referencia_producto;
        $class_talla_cierre = $talla;

        require '../../../clases/class-cierre.php';
    }

    $conn->commit();

    // PRG redirect
    header("Location: ../cierre-tercero.php?nombre_tercero=" . urlencode($nombre_tercero));
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
