<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario = post('nombre_usuario');
$nombre_tercero = post('nombre_tercero');
$fecha = date('Y-m-d');

/* ---------------- Validaciones ---------------- */
$errores = [];
if ($nombre_usuario === '') $errores[] = 'Falta nombre_usuario';
if ($nombre_tercero === '') $errores[] = 'Falta nombre_tercero';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* -------------------------------------------------------
       1) Obtener todas las combinaciones (referencia, talla)
          relacionadas con este tercero (sin duplicar)
       ------------------------------------------------------- */
    $stmtPairs = $conn->prepare("
        SELECT DISTINCT ref, talla FROM (
            SELECT pd.referencia_producto AS ref, pd.talla AS talla
            FROM pedido p
            JOIN pedido_detalle pd ON p.id = pd.id_pedido
            WHERE p.nombre_tercero = ? AND p.estado <> 'Cancelado'

            UNION ALL

            SELECT dd.referencia_producto AS ref, dd.talla AS talla
            FROM despacho d
            JOIN despacho_detalle dd ON d.id = dd.id_despacho
            WHERE d.nombre_tercero = ? AND d.estado <> 'Cancelado'

            UNION ALL

            SELECT cd.referencia_producto AS ref, cd.talla AS talla
            FROM cierre_detalle cd
            WHERE cd.nombre_tercero = ?
        ) x
    ");
    if (!$stmtPairs) throw new Exception("Prepare pairs: " . $conn->error);

    $stmtPairs->bind_param("sss", $nombre_tercero, $nombre_tercero, $nombre_tercero);
    $stmtPairs->execute();
    $resPairs = $stmtPairs->get_result();

    while ($p = $resPairs->fetch_assoc()) {
        $class_nombre_tercero_cierre = $nombre_tercero;
        $class_referencia_cierre = $p['ref'];
        $class_talla_cierre = $p['talla'];

        require '../../../clases/class-cierre.php';
    }
    $stmtPairs->close();

    /* -------------------------------------------------------
       2) Evitar duplicar cierres del mismo día:
          borra los registros de cierre_detalle del tercero de HOY
          (así si ejecutan 2 veces, reemplaza y no duplica)
       ------------------------------------------------------- */
    $stmtDel = $conn->prepare("DELETE FROM cierre_detalle WHERE nombre_tercero = ? AND fecha = ?");
    if (!$stmtDel) throw new Exception("Prepare delete cierre_detalle: " . $conn->error);
    $stmtDel->bind_param("ss", $nombre_tercero, $fecha);
    $stmtDel->execute();
    $stmtDel->close();

    /* -------------------------------------------------------
       3) Insertar ajuste negativo desde referencia_cierre
       ------------------------------------------------------- */
    $stmtRC = $conn->prepare("
        SELECT referencia_producto, talla, cantidad
        FROM referencia_cierre
        WHERE nombre_tercero = ?
    ");
    if (!$stmtRC) throw new Exception("Prepare referencia_cierre: " . $conn->error);

    $stmtRC->bind_param("s", $nombre_tercero);
    $stmtRC->execute();
    $resRC = $stmtRC->get_result();

    $stmtIns = $conn->prepare("
        INSERT INTO cierre_detalle (nombre_usuario, nombre_tercero, fecha, referencia_producto, talla, cantidad)
        VALUES (?,?,?,?,?,?)
    ");
    if (!$stmtIns) throw new Exception("Prepare insert cierre_detalle: " . $conn->error);

    while ($row3 = $resRC->fetch_assoc()) {
        $referencia_producto = $row3['referencia_producto'];
        $talla = $row3['talla'];
        $cantidad_neg = ((int)$row3['cantidad']) * -1;

        $stmtIns->bind_param(
            "sssssi",
            $nombre_usuario,
            $nombre_tercero,
            $fecha,
            $referencia_producto,
            $talla,
            $cantidad_neg
        );

        if (!$stmtIns->execute()) {
            throw new Exception("Insert cierre_detalle falló: " . $stmtIns->error);
        }

        // Recalcular después de insertar el ajuste
        $class_nombre_tercero_cierre = $nombre_tercero;
        $class_referencia_cierre = $referencia_producto;
        $class_talla_cierre = $talla;
        require '../../../clases/class-cierre.php';
    }

    $stmtIns->close();
    $stmtRC->close();

    $conn->commit();

    // PRG redirect
    header("Location: ../cierre-tercero.php?nombre_tercero=" . urlencode($nombre_tercero));
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
