<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

/* Recomendado: SOLO POST para que no lo dispare cualquiera por URL */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

try {
    // Si tu class-cierre.php escribe en BD, mejor con transacción
    $conn->begin_transaction();

    /*
      1) Obtener todas las combinaciones únicas (tercero, referencia, talla)
         desde:
         - pedido/pedido_detalle (no cancelados)
         - despacho/despacho_detalle (no cancelados)
         - cierre_detalle
      Esto reemplaza los 3 loops + queries repetidas
    */
    $sql = "
        SELECT DISTINCT nombre_tercero, referencia_producto, talla
        FROM (
            SELECT p.nombre_tercero AS nombre_tercero, pd.referencia_producto AS referencia_producto, pd.talla AS talla
            FROM pedido p
            JOIN pedido_detalle pd ON pd.id_pedido = p.id
            WHERE p.estado <> 'Cancelado' AND p.nombre_tercero IS NOT NULL AND p.nombre_tercero <> ''

            UNION ALL

            SELECT d.nombre_tercero AS nombre_tercero, dd.referencia_producto AS referencia_producto, dd.talla AS talla
            FROM despacho d
            JOIN despacho_detalle dd ON dd.id_despacho = d.id
            WHERE d.estado <> 'Cancelado' AND d.nombre_tercero IS NOT NULL AND d.nombre_tercero <> ''

            UNION ALL

            SELECT cd.nombre_tercero AS nombre_tercero, cd.referencia_producto AS referencia_producto, cd.talla AS talla
            FROM cierre_detalle cd
            WHERE cd.nombre_tercero IS NOT NULL AND cd.nombre_tercero <> ''
        ) x
    ";

    $res = $conn->query($sql);
    if (!$res) {
        throw new Exception("Query combinaciones falló: " . $conn->error);
    }

    while ($r = $res->fetch_assoc()) {
        $class_nombre_tercero_cierre = $r['nombre_tercero'];
        $class_referencia_cierre     = $r['referencia_producto'];
        $class_talla_cierre          = $r['talla'];

        require '../../../clases/class-cierre.php';
    }

    $conn->commit();

    header("Location: ../sincronizar-tercero.php");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
