<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$id_despacho = $_GET['id_despacho'];

$sql1 = "SELECT * FROM despacho WHERE id='$id_despacho'";
$query1 = $conn->query($sql1);
$row1 = $query1->fetch_assoc();

if (isset($_GET['referencia_producto'])) {
    $autofocus_referencia = '';
    $autofocus_talla = 'autofocus';
} else {
    $autofocus_referencia = 'autofocus';
    $autofocus_talla = '';
}


/* ─── 1. Mapas de colores ─── */
$badgeClass = [
    'Proceso'  => 'badge alert-info',
    'Enviado'  => 'badge alert-warning',
    'Recibido' => 'badge alert-success',
    'Cancelado' => 'badge alert-secondary',
];
$iconClass = [
    'Proceso'  => 'text-info',
    'Enviado'  => 'text-warning',
    'Recibido' => 'text-success',
    'Cancelado' => 'text-secondary',
];
$badgeEstado = $badgeClass[$row1['estado']] ?? 'badge bg-light';

/* ─── 2. Opciones permitidas (según tercero) ─── */
$opciones = ($row1['nombre_tercero'] === 'INNOVASUELAS ALMACEN')
    ? ['Proceso', 'Enviado', 'Cancelado']                       // Sin “Recibido”
    : ['Proceso', 'Enviado', 'Recibido', 'Cancelado'];

?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</head>

<body>
    <!--start wrapper-->
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">



                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb small">
                        <li class="breadcrumb-item"><a href="../inicio/inicio.php"><ion-icon name="home-outline"></ion-icon></a></li>
                        <li class="breadcrumb-item"><a href="despacho.php">Despacho</a></li>
                        <li class="breadcrumb-item active">ODD-<?= $id_despacho ?> <?= $row1['nombre_tercero'] ?></li>
                    </ol>
                </nav>



                <!-- Cabecera -->
                <div class="card shadow-sm mb-4 border-0">
                    <div class="card-body bg-gradient-info bg-opacity-75 rounded-3">
                        <div class="d-flex flex-column flex-sm-row justify-content-between align-items-sm-center gap-3">
                            <h1 class="h4 mb-0 text-dark fw-bold">ODP-<?= $id_despacho ?></h1>

                            <!-- Estado -->
                            <div class="dropdown">
                                <button class="btn <?= $badgeEstado ?> dropdown-toggle py-2 px-3 text-uppercase"
                                    data-bs-toggle="dropdown">
                                    <?= $row1['estado'] ?>
                                </button>

                                <ul class="dropdown-menu dropdown-menu-end shadow-sm">
                                    <?php foreach ($opciones as $estado): ?>
                                        <?php
                                        // Si es INNOVASUELAS ALMACEN y ya está “Enviado” o “Recibido”, no mostrar más cambios
                                        if (
                                            $row1['nombre_tercero'] === 'INNOVASUELAS ALMACEN'
                                            && in_array($row1['estado'], ['Enviado', 'Recibido'])
                                            && $estado !== 'Cancelado'
                                        ) {
                                            continue;
                                        }
                                        ?>
                                        <li>
                                            <form action="script/despacho-estado-editar.php" method="post"
                                                class="dropdown-item p-0"
                                                <?= $estado === 'Cancelado'
                                                    ? 'onsubmit="return confirm(\'¿Cancelar este despacho?\')"' : '' ?>>
                                                <input type="hidden" name="id_despacho" value="<?= $id_despacho ?>">
                                                <input type="hidden" name="estado" value="<?= $estado ?>">
                                                <button class="w-100 border-0 bg-transparent py-2 text-start">
                                                    <i class="fas fa-circle <?= $iconClass[$estado] ?> me-2"></i><?= $estado ?>
                                                </button>
                                            </form>
                                        </li>
                                    <?php endforeach ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>




                <div class="card" id="areaImprimir">
                    <div class="card-body" style="">
                        <!-- CONTENIDO DE PAGINA-->

                        <div class="row">

                            <div class="col-sm-4 ">

                                <h4 class="text-uppercase ">
                                    <b class="text-dark"><?php echo $row1['nombre_tercero']; ?></b>
                                </h4>
                            </div>

                            <div class="col-sm-4 ">

                            </div>


                            <div class="col-sm-4 text-end">

                            </div>
                        </div>


                        <form class=" g-3 needs-validation" novalidate="" action="">
                            <input class="form-control inputcss" type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden readonly>

                            <div class="row">
                                <div class="col-md-2 ">
                                    <h6 class="mt-3">DATOS FACTURACION:</h6>
                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                    <style>
                                        .inputcss {
                                            color: brown;
                                            font-weight: 500;
                                        }
                                    </style>
                                    <div style="font-size: 12px;">
                                        <div class="row ">
                                            <div class="col-md-6 col-6">
                                                <strong class="text-secondary">Fecha:</strong>
                                            </div>
                                            <div class="col-md-6 col-6" style="text-align: right;">
                                                <b><?php echo $row1['fecha']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-6 col-6">
                                                <strong class="text-secondary">Quien registra:</strong>
                                            </div>
                                            <div class="col-md-6 col-6" style="text-align: right;">
                                                <b><?php echo $row1['nombre_usuario']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-6 col-6">
                                                <strong class="text-secondary">Id Despacho:</strong>
                                            </div>
                                            <div class="col-md-6 col-6" style="text-align: right;">
                                                <b><?php echo $id_despacho; ?></b>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-md-4">
                                    <h6 class="mt-3">DATOS DEL CLIENTE:</h6>
                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                    <div style="font-size: 12px;">
                                        <div class="row ">
                                            <div class="col-md-3 col-3 ">
                                                <strong class="text-secondary">Nombre:</strong>
                                            </div>
                                            <div class="col-md-9 col-9" style="text-align: right;">
                                                <b><?php echo $row1['nombre']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-3 col-4">
                                                <strong class="text-secondary">Cedula:</strong>
                                            </div>
                                            <div class="col-md-9 col-8" style="text-align: right;">
                                                <b><?php echo $row1['cedula']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-3 col-4">
                                                <strong class="text-secondary">Telefono:</strong>
                                            </div>
                                            <div class="col-md-9 col-8" style="text-align: right;">
                                                <b><?php echo $row1['telefono']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-3 col-3">
                                                <strong class="text-secondary">Correo:</strong>
                                            </div>
                                            <div class="col-md-9 col-9" style="text-align: right;">
                                                <b><?php echo $row1['correo']; ?></b>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <h6 class="mt-3">DATOS DE ENVIO:</h6>
                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                    <div style="font-size: 12px;">
                                        <div class="row ">
                                            <div class="col-md-3 col-3">
                                                <strong class="text-secondary">Destino:</strong>
                                            </div>
                                            <div class="col-md-9 col-9" style="text-align: right;">
                                                <b><?php echo $row1['destino']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-3 col-4">
                                                <strong class="text-secondary">Direcci��n:</strong>
                                            </div>
                                            <div class="col-md-9 col-8" style="text-align: right;">
                                                <b><?php echo $row1['direccion']; ?></b>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col-md-5 col-6">
                                                <strong class="text-secondary">Observacion</strong>
                                            </div>
                                            <div class="col-md-7 col-6" style="text-align: right;">
                                                <b><?php echo $row1['observacion']; ?></b>
                                            </div>
                                        </div>
                                        <?php
                                        $sql7 = "SELECT SUM(cantidad) AS cantidad FROM despacho_paquete WHERE id_despacho='$id_despacho'";
                                        $query7 = $conn->query($sql7);
                                        $row7 = $query7->fetch_assoc();
                                        ?>
                                        <div class="row ">
                                            <div class="col-md-5 col-6">
                                                <strong class="text-secondary">Paquetes</strong>
                                            </div>
                                            <div class="col-md-7 col-6" style="text-align: right;">
                                                <b><?php echo $row7['cantidad']; ?></b>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <h6 class="mt-3">No Despacho:</h6>
                                    <hr class="mt-0" style="border-top: 2px dotted black;">
                                    <div style="font-size: 12px;">

                                        <h2 class="text-uppercase ">
                                            <b class="text-primary "><?php echo $row1['numero_despacho']; ?></b>
                                        </h2>
                                    </div>
                                </div>


                            </div>
                        </form>

                        <hr class="mt-1 mb-0">

                        <div class="row d-print-none mt-2">
                            <div class="col-xl-6">
                            </div>
                            <div class="col-xl-6 text-end">

                                <?php
                                if ($row1['estado'] == 'Proceso') {
                                ?>

                                    <a class="btn btn-warning radius-10" href="#!" data-bs-toggle="modal" data-bs-target="#editar_venta">
                                        <i class="far fa-edit me-2"></i>Actualizar datos
                                    </a>

                                <?php
                                } else {
                                }
                                ?>

                                <div class="modal fade" id="editar_venta" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar orden</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form class=" g-3 needs-validation text-start" novalidate="" method="POST" action="script/despacho-editar.php">
                                                <input class="form-control" type="text" required="" name="id_despacho" value="<?php echo $id_despacho; ?>" hidden>
                                                <input class="form-control" type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>


                                                <div class="modal-body ">
                                                    <div class="row">
                                                        <div class="col-md-2">
                                                            <h6 class="mt-3"><b>Datos facturacion:</b></h6>
                                                            <hr class="mt-0" style="border-top: 2px dotted black;">
                                                            <style>
                                                                .inputcss {
                                                                    color: brown;
                                                                    font-weight: 500;
                                                                }
                                                            </style>


                                                            <?php
                                                            if ($row1['estado'] != 'Proceso') {
                                                                $readonly = '';
                                                            } else {
                                                                $readonly = '';
                                                            }
                                                            ?>


                                                            <div class="row ">
                                                                <div class="col-md-12">
                                                                    <label class="form-label" for="validationCustom01">Fecha:</label>
                                                                    <input class="form-control inputcss" type="date" name="fecha" value="<?php echo $row1['fecha']; ?>" <?php echo $readonly; ?> required="">
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, seleccione un fecha para el pedido.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom01">Nombre tercero:</label>


                                                                    <select class="form-select choices-1 " id="validationCustom04" required="" name="nombre_tercero" <?php echo $readonly; ?>>
                                                                        <option value="<?php echo $row1['nombre_tercero']; ?>"><?php echo $row1['nombre_tercero']; ?></option>
                                                                        <option disabled="" value="">Seleccione</option>
                                                                        <option value="VARIOS">VARIOS</option>
                                                                        <?php
                                                                        $sql6m = "SELECT * FROM tercero ORDER BY nombre asc";
                                                                        $query6m = $conn->query($sql6m);
                                                                        if ($query6m->num_rows > 0) {
                                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                        ?>

                                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                        <?php
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </select>


                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom02">No Despacho:</label>
                                                                    <input class="form-control inputcss " type="text" required="" name="numero_despacho" value="<?php echo $row1['numero_despacho']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite un numero de pedido.</div>
                                                                </div>

                                                            </div>
                                                        </div>


                                                        <div class="col-md-6">
                                                            <h6 class="mt-3"><b>Datos del cliente:</b></h6>
                                                            <hr class="mt-0" style="border-top: 2px dotted black;">
                                                            <div class="row ">
                                                                <div class="col-md-4">
                                                                    <label class="form-label" for="validationCustom01">Cedula o Nit:</label>
                                                                    <input class="form-control inputcss" type="text" required="" name="cedula" placeholder="**********" value="<?php echo $row1['cedula']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite una cedula valida de lo contrario rellene con "No aplica"</div>
                                                                </div>
                                                                <div class="col-md-8 ">
                                                                    <label class="form-label" for="validationCustom02">Nombre cliente:</label>
                                                                    <input class="form-control inputcss" type="text" required="" name="nombre" placeholder="Nombres y apellidos" value="<?php echo $row1['nombre']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite nombres y apellidos.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Direcci��n:</label>
                                                                    <textarea class="form-control inputcss" type="text" required="" name="direccion" placeholder="Cll, Av, Mz 0E-00E Barrio" <?php echo $readonly; ?>><?php echo $row1['direccion']; ?></textarea>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite la direccion del cliente.</div>
                                                                </div>
                                                                <div class="col-md-8 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Destino:</label>
                                                                    <input class="form-control inputcss" type="text" required="" name="destino" placeholder="Ciudad - Departamento" value="<?php echo $row1['destino']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite el destino.</div>
                                                                </div>
                                                                <div class="col-md-4 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Telefono:</label>
                                                                    <input class="form-control inputcss" type="text" required="" name="telefono" placeholder="5555555555 - 5555555555" value="<?php echo $row1['telefono']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite uno o dos numero de contacto.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Correo:</label>
                                                                    <input class="form-control inputcss" type="text" required="" name="correo" placeholder="alguien@example.com" value="<?php echo $row1['correo']; ?>" <?php echo $readonly; ?>>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite un correo valido de lo contrario rellene con "No aplica".</div>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="col-md-4">
                                                            <h6 class="mt-3"><b>Datos de envio:</b></h6>
                                                            <hr class="mt-0" style="border-top: 2px dotted black;">
                                                            <div class="row ">
                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Observaci��n:</label>
                                                                    <textarea class="form-control inputcss" type="text" required="" name="observacion" placeholder="Complemento para direccion u observacion" <?php echo $readonly; ?>><?php echo $row1['observacion']; ?></textarea>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, Digite una descripcion para la orden.</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-warning  radius-10">Guardar cambios</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>


                        <style>
                            .ancho {
                                width: 2.5%;
                                text-align: center;
                            }

                            #hover_enlace:hover {
                                color: orange;
                                border-radius: 10px;
                                border: lightcoral 1px solid;
                                box-shadow: 0px 0px 5px 0px lightcoral;
                            }
                        </style>



                        <div class="table-responsive mt-3">
                            <table class="table table-hover  table-sm table-striped table-bordered">
                                <thead>
                                    <tr class="bg-gradient-info text-white">
                                        <th class=" p-1 " style="width: 5%;">FOTO</th>
                                        <th class="text-center p-1 " style="width: 12%;">REFERENCIA</th>
                                        <?php
                                        $item = 0;
                                        $sqlt1 = "SELECT * FROM despacho_detalle WHERE id_despacho='$id_despacho' GROUP BY talla ORDER BY talla asc";
                                        $queryt1 = $conn->query($sqlt1);
                                        if ($queryt1->num_rows > 0) {
                                            while ($rowt1 = $queryt1->fetch_assoc()) {
                                        ?>
                                                <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                        <?php
                                                $item++;
                                            }
                                        }
                                        ?>
                                        <th class="text-center p-1" style="width: 3%;">T. PARES</th>
                                        <th class="text-center p-1" style="width: 3%;">VR. UNIT</th>
                                        <th class="text-center p-1" style="width: 3%;">PAQUETES</th>
                                        <th class="text-center p-1" style="width: 6%;">VR. TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $total_cantidad = 0;
                                    $total_venta = 0;
                                    $total_paquetes = 0;

                                    $sql3 = "SELECT * FROM despacho_detalle WHERE id_despacho='" . $row1['id'] . "' GROUP BY referencia_producto, precio_unidad";
                                    $query3 = $conn->query($sql3);
                                    if ($query3->num_rows > 0) {
                                        while ($row3 = $query3->fetch_assoc()) {

                                            $sql2 = "SELECT * FROM producto WHERE referencia='" . $row3['referencia_producto'] . "'";
                                            $query2 = $conn->query($sql2);
                                            $row2 = $query2->fetch_assoc();

                                            ////CANTIDAD POR REFERENCIA
                                            $sqlCANT = "SELECT SUM(cantidad) as cantidad_referencia FROM despacho_detalle WHERE id_despacho='" . $row1['id'] . "' AND referencia_producto='" . $row3['referencia_producto'] . "'  AND precio_unidad='" . $row3['precio_unidad'] . "'";
                                            $queryCANT = $conn->query($sqlCANT);
                                            $rowCANT = $queryCANT->fetch_assoc();
                                    ?>
                                            <tr class="align-middle">
                                                <td class="text-center">
                                                    <?php
                                                    if ($row2['foto1'] == 'NO APLICA') {
                                                    ?>
                                                        <img class="img-thumbnail" src="../../img/camara.jpg" width="40" alt="alt" />
                                                    <?php
                                                    } else {
                                                    ?>
                                                        <img class="" src="../../img-producto/<?php echo $row2['foto1']; ?>" width="40" height="40" alt="alt" />
                                                    <?php
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <strong class="text-primary"><?php echo $row2['referencia']; ?></strong> -
                                                    <span class="text-muted text-sm"><?php echo $row2['categoria']; ?></span><br>
                                                </td>

                                                <?php
                                                $queryt2 = $conn->query($sqlt1);
                                                if ($queryt2->num_rows > 0) {
                                                    while ($rowt2 = $queryt2->fetch_assoc()) {

                                                        $sqlt4 = "SELECT SUM(cantidad) as suma_talla FROM despacho_detalle WHERE id_despacho='" . $row1['id'] . "' AND referencia_producto='" . $row3['referencia_producto'] . "' AND talla='" . $rowt2['talla'] . "' AND precio_unidad='" . $row3['precio_unidad'] . "'";
                                                        $queryt4 = $conn->query($sqlt4);
                                                        $rowt4 = $queryt4->fetch_assoc();

                                                        $suma_talla = $rowt4['suma_talla'];
                                                ?>
                                                        <td class="ancho">

                                                            <?php
                                                            if ($row1['estado'] != "Proceso") {
                                                            ?>
                                                                <?php echo $suma_talla; ?>

                                                            <?php
                                                            } else {
                                                            ?>
                                                                <?php
                                                                // Genera el token una sola vez al iniciar sesión
                                                                if (empty($_SESSION['csrf'])) {
                                                                    $_SESSION['csrf'] = bin2hex(random_bytes(32));
                                                                }
                                                                $csrf = $_SESSION['csrf'];
                                                                ?>

                                                                <form action="script/despacho-talla-eliminar.php"
                                                                    method="post"
                                                                    class="d-inline"
                                                                    onsubmit="return confirm('¿Seguro deseas eliminar este registro?');">

                                                                    <input type="hidden" name="id_despacho" value="<?= $id_despacho ?>">
                                                                    <input type="hidden" name="referencia_producto" value="<?= $row3['referencia_producto'] ?>">
                                                                    <input type="hidden" name="talla" value="<?= $rowt2['talla'] ?>">
                                                                    <input type="hidden" name="precio_unidad" value="<?= $row3['precio_unidad'] ?>">
                                                                    <input type="hidden" name="csrf" value="<?= $csrf ?>">

                                                                    <button class="btn btn-link p-0 text-dark fw-semibold">
                                                                        <span id="hover_enlace"><?= $suma_talla ?></span>
                                                                    </button>
                                                                </form>



                                                            <?php
                                                            }
                                                            ?>

                                                            <br>
                                                            <?php
                                                            $sql8 = "SELECT SUM(cantidad) as cantidad FROM referencia_cierre WHERE nombre_tercero='" . $row1['nombre_tercero'] . "' AND referencia_producto='" . $row3['referencia_producto'] . "' AND talla='" . $rowt2['talla'] . "'";
                                                            $query8 = $conn->query($sql8);
                                                            $row8 = $query8->fetch_assoc();

                                                            if ($row8['cantidad'] < 0) {
                                                            ?>
                                                                <span class="badge bg-danger rounded-pill"><?php echo $row8['cantidad']; ?></span>
                                                            <?php
                                                            } else {
                                                            }
                                                            ?>

                                                        </td>
                                                <?php
                                                    }
                                                }
                                                ?>



                                                <td class="text-center"><b><?php echo $rowCANT['cantidad_referencia']; ?></b></td>
                                                <td class="" style="text-align: right;">


                                                    <?php
                                                    if ($row1['estado'] != "Proceso") {
                                                    ?>
                                                        $ <?php echo number_format($row3['precio_unidad'], 0, '.', ','); ?>

                                                    <?php
                                                    } else {
                                                    ?>
                                                        <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar_precio"
                                                            data-id_despacho="<?php echo $id_despacho; ?>"
                                                            data-referencia_producto="<?php echo $row3['referencia_producto']; ?>"
                                                            data-precio_unidad="<?php echo $row3['precio_unidad']; ?>">

                                                            <div id="hover_enlace" class="h6">
                                                                $ <?php echo number_format($row3['precio_unidad'], 0, '.', ','); ?>
                                                            </div>
                                                        </a>
                                                    <?php
                                                    }
                                                    ?>
                                                </td>

                                                <td class="text-center">
                                                    <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar_paquete"
                                                        data-id_despacho_pq="<?php echo $id_despacho; ?>"
                                                        data-referencia_producto_pq="<?php echo $row3['referencia_producto']; ?>"
                                                        data-precio_unidad_pq="<?php echo $row3['precio_unidad']; ?>">


                                                        <?php
                                                        $sql7 = "SELECT SUM(cantidad) AS cantidad FROM despacho_paquete WHERE id_despacho='$id_despacho' AND referencia_producto='" . $row3['referencia_producto'] . "' AND precio_unidad='" . $row3['precio_unidad'] . "'";
                                                        $query7 = $conn->query($sql7);
                                                        $row7 = $query7->fetch_assoc();
                                                        ?>

                                                        <span>
                                                            <h6>
                                                                <i class="fa-solid fa-bag-shopping me-2 float-start"></i>
                                                                <b><?php echo number_format($row7['cantidad'], 0); ?></b>
                                                            </h6>
                                                        </span>
                                                    </a>
                                                </td>

                                                <td class="" style="text-align: right; ">
                                                    <b class="float-start">$</b>
                                                    <b class="h6"><?php echo number_format($rowCANT['cantidad_referencia'] * $row3['precio_unidad'], 0, '.', ','); ?></b>
                                                </td>
                                            </tr>
                                    <?php
                                            $total_venta += $rowCANT['cantidad_referencia'] * $row3['precio_unidad'];
                                            $total_cantidad += $rowCANT['cantidad_referencia'];
                                            $total_paquetes += $row7['cantidad'];
                                        }
                                    }
                                    ?>
                                    <tr class="h5 bg-light-dark">
                                        <td class="text-end" colspan="<?php echo $item + 2; ?>"><b>TOTAL</b></td>
                                        <td class="text-center"><b><?php echo $total_cantidad; ?></b></td>
                                        <td></td>
                                        <td class="text-center">
                                            <b><?php echo $total_paquetes; ?></b>
                                        </td>
                                        <td class="text-end">
                                            <b class="float-start">$</b>
                                            <b><?php echo number_format($total_venta, 0); ?></b>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>



                        <?php
                        if ($row1['estado'] == 'Proceso') {
                        ?>



                            <script>
                                function fncdespacho() {
                                    caja = document.forms["despacho"].elements;

                                    var referencia_producto = caja["referencia_producto"].value;

                                    $.ajax({
                                        type: "POST",
                                        url: "./script/select-producto-precio.php",
                                        data: {
                                            referencia_producto: referencia_producto
                                        },
                                        dataType: "text",
                                        success: function(response) {
                                            res1 = response
                                            caja["precio_unidad"].value = res1;

                                            var precio_unidad = caja["precio_unidad"].value;

                                        }
                                    });
                                }
                            </script>



                            <form class=" g-3 needs-validation d-print-none" method="POST" action="script/despacho-referencia-guardar.php" name="despacho">
                                <input class="form-control inputcss " type="text" required="" name="id_despacho" value="<?php echo $id_despacho; ?>" hidden>
                                <input class="form-control inputcss " type="text" required="" name="estado" value="<?php echo $row1['estado']; ?>" hidden>

                                <div class="row">
                                    <div class="col-md-4">
                                        <label>Referencia:</label>
                                        <select class="single-select" required="" name="referencia_producto" <?php echo $autofocus_referencia; ?> onchange="fncdespacho()">

                                            <?php
                                            if (isset($_GET['referencia_producto'])) {
                                            ?>
                                                <option selected="" value="<?php echo $_GET['referencia_producto']; ?>"><?php echo $_GET['referencia_producto']; ?></option>
                                                <option value="">Referencias</option>
                                            <?php
                                            } else {
                                            ?>
                                                <option selected="" value="">Seleccione</option>
                                            <?php
                                            }
                                            ?>

                                            <?php
                                            $sql4 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                            $query4 = $conn->query($sql4);
                                            if ($query4->num_rows > 0) {
                                                while ($row4 = $query4->fetch_assoc()) {
                                            ?>

                                                    <option value="<?php echo $row4['referencia'] ?>"><?php echo $row4['referencia'] ?></option>
                                            <?php
                                                }
                                            }
                                            ?>
                                        </select>
                                        <div class="valid-feedback">Se ve bien!</div>
                                        <div class="invalid-feedback">Por favor, seleccione referencia.</div>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Talla:</label>
                                        <select class="form-select " id="single-select1" required="" name="talla" <?php echo $autofocus_talla; ?>>
                                            <option selected="" disabled="" value="">Tallas</option>
                                            <?php
                                            for ($i = 10; $i < 50; $i++) {
                                            ?>
                                                <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                            <?php
                                            }
                                            ?>
                                        </select>
                                        <div class="valid-feedback">Se ve bien!</div>
                                        <div class="invalid-feedback">Por favor, seleccione talla.</div>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Cantidad:</label>
                                        <input id="cantidad" class="form-control inputcss" type="number" required name="cantidad" placeholder="cant." min="1" oninput="validateInput(this)" onkeypress="preventMinus(event)">
                                    </div>

                                    <script>
                                        function preventMinus(event) {
                                            if (event.key === '-' || event.key === '0' && event.target.value === '') {
                                                event.preventDefault(); // Evita que se escriba el signo menos y evita ceros iniciales.
                                            }
                                        }

                                        function validateInput(input) {
                                            if (input.value < 1) {
                                                input.value = 1; // Reajusta a 1 si el valor es menor.
                                            }
                                        }
                                    </script>
                                    <div class="col-md-2">
                                        <label>Precio unidad:</label>
                                        <?php
                                        if (isset($_GET['precio'])) {
                                        ?>
                                            <input class="form-control inputcss " id="precio_unitario" type="text" required="" name="precio_unidad" placeholder="VR Unitario" value="<?php echo $_GET['precio']; ?>">

                                        <?php
                                        } else {
                                        ?>
                                            <input class="form-control inputcss " id="precio_unitario" type="text" required="" name="precio_unidad" placeholder="VR Unitario" value="0">
                                        <?php
                                        }
                                        ?>
                                    </div>
                                    <div class="col-md-2">
                                        <button class="btn btn-success radius-10" type="submit"><i class="fas fa-plus text-white"></i> Agregar Item</button>
                                    </div>
                                </div>
                            </form>
                            <!-- FIN TABA-->
                        <?php
                        } else {
                        }
                        ?>
                        <br>

                        <div class=" text-center">
                            <button class="btb btn-info radius-30 d-print-none" onclick="printDiv('areaImprimir')"><i class="fas fa-print fa-2x"></i></button>
                        </div>

                    </div>
                </div>



                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
    </div>
    <!--end wrapper-->
    <?php echo include '../general/libreria-js.php'; ?>

    <script>
        //Tabla producto
        $(document).ready(function() {
            var select1 = $('#single-select1').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),
            });


        });
    </script>

    <div class="modal fade" id="editar_precio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar precio</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/despacho-precio-editar.php">
                    <input class="form-control" type="text" required="" name="edit_id_pedido" id="edit_id_pedido" hidden="">
                    <input class="form-control" type="text" required="" name="edit_id_despacho" id="edit_id_despacho" hidden="">

                    <div class="modal-body ">
                        <div class="row ">
                            <div class="col-md-6">
                                <label class="form-label" for="validationCustom01">Referencia:</label>
                                <input class="form-control" type="text" required="" name="edit_referencia_producto" id="edit_referencia_producto" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite la referencia.</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="validationCustom01">Precio actual:</label>
                                <input class="form-control" type="text" required="" name="edit_precio_unidad" id="edit_precio_unidad" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite precio actual.</div>
                            </div>
                            <div class="col-md-12 mt-3">
                                <label class="form-label" for="validationCustom01">Precio unitario:</label>
                                <input class="form-control" type="text" required="" name="edit_precio_unidad_nuevo" id="precio_unitario_nuevo">
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite el precio nuevo.</div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary px-5 radius-30" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary px-5 radius-30">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#editar_precio').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var id_pedido = button.data('id_pedido')
            var id_despacho = button.data('id_despacho')
            var referencia_producto = button.data('referencia_producto')
            var precio_unidad = button.data('precio_unidad')


            $('#edit_id_pedido').val(id_pedido)
            $('#edit_id_despacho').val(id_despacho)
            $('#edit_referencia_producto').val(referencia_producto)
            $('#edit_precio_unidad').val(precio_unidad)
        });
    </script>



    <div class="modal fade" id="editar_paquete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title card-heading" id="exampleModalLabel">Paquetes por referencia</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/despacho-paquete.php">
                    <input class="form-control" type="text" required="" name="edit_id_despacho_pq" id="edit_id_despacho_pq" hidden="">
                    <div class="modal-body">
                        <div class="row ">
                            <div class="col-md-12">
                                <label class="form-label" for="validationCustom01">Referencia:</label>
                                <input class="form-control" type="text" required="" name="edit_referencia_producto_pq" id="edit_referencia_producto_pq" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite la referencia.</div>
                            </div>
                            <div class="col-md-4  mt-3">
                                <label class="form-label" for="validationCustom01">Precio unidad:</label>
                                <input class="form-control" type="text" required="" name="edit_precio_unidad_pq" id="edit_precio_unidad_pq" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite precio actual.</div>
                            </div>
                            <div class="col-md-8 mt-3">
                                <label class="form-label" for="validationCustom01">Cantidad paquetes:</label>
                                <input class="form-control" type="text" required="" name="edit_cantidad_pq">
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite el precio nuevo.</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-dark px-5 radius-30" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-warning px-5 radius-30">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#editar_paquete').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var id_despacho_pq = button.data('id_despacho_pq')
            var referencia_producto_pq = button.data('referencia_producto_pq')
            var precio_unidad_pq = button.data('precio_unidad_pq')


            $('#edit_id_despacho_pq').val(id_despacho_pq)
            $('#edit_referencia_producto_pq').val(referencia_producto_pq)
            $('#edit_precio_unidad_pq').val(precio_unidad_pq)
        });
    </script>


</body>

</html>