<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_despacho = post('id_despacho');
$estado      = post('estado');

/* Validaciones mínimas */
$errores = [];
if ($id_despacho === '' || !ctype_digit($id_despacho) || (int)$id_despacho <= 0) $errores[] = 'id_despacho inválido';
if ($estado === '') $errores[] = 'Falta estado';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_despacho;

/* Traer despacho (para nombre_tercero en class-cierre) */
$sqlt = "SELECT * FROM despacho WHERE id='$id_int'";
$queryt = $conn->query($sqlt);
$rowt = $queryt->fetch_assoc();

if (!$rowt) {
    http_response_code(400);
    exit('Error: El despacho no existe');
}

/* ----------- TU MISMA VALIDACIÓN DE INVENTARIO ----------- */
$contador = 0;

// agrupar por referencia/talla
$sql4 = "SELECT referencia_producto, talla
         FROM despacho_detalle
         WHERE id_despacho='$id_int'
         GROUP BY referencia_producto, talla";
$query4 = $conn->query($sql4);

if ($query4 && $query4->num_rows > 0) {
    while ($row4 = $query4->fetch_assoc()) {

        $co_referencia = $row4['referencia_producto'];
        $co_talla      = $row4['talla'];

        // total solicitado en el despacho
        $sql5 = "SELECT COALESCE(SUM(cantidad),0) as cantidad
                 FROM despacho_detalle
                 WHERE id_despacho='$id_int' AND referencia_producto='$co_referencia' AND talla='$co_talla'";
        $query5 = $conn->query($sql5);
        $row5 = $query5->fetch_assoc();

        // disponible en inventario
        $sql6 = "SELECT COALESCE(cantidad,0) as cantidad
                 FROM referencia_disponible
                 WHERE referencia_producto='$co_referencia' AND talla='$co_talla'
                 LIMIT 1";
        $query6 = $conn->query($sql6);
        $row6 = $query6->fetch_assoc();

        $cant_solicitada = (int)($row5['cantidad'] ?? 0);
        $cant_disponible = (int)($row6['cantidad'] ?? 0);

        // ✅ CORRECCIÓN: no resetear contador a 0 dentro del loop
        if ($cant_solicitada > $cant_disponible) {
            $contador++;
        }
    }
}

/* ----------- CAMBIAR ESTADO (MISMA LÓGICA TUYA) ----------- */
if ($contador <= 0 || $estado == 'Cancelado') {

    $sql1 = "UPDATE despacho SET estado='$estado' WHERE id='$id_int'";
    if ($conn->query($sql1) === TRUE) {

        $sql2 = "UPDATE despacho_detalle SET estado='$estado' WHERE id_despacho='$id_int'";
        if ($conn->query($sql2) === TRUE) {

            $sql3 = "SELECT * FROM despacho_detalle WHERE id_despacho='$id_int'";
            $query3 = $conn->query($sql3);
            if ($query3 && $query3->num_rows > 0) {
                while ($row3 = $query3->fetch_assoc()) {

                    $class_referencia = $row3['referencia_producto'];
                    $class_talla = $row3['talla'];
                    require '../../../clases/class-referencia.php';

                    $class_nombre_tercero_cierre = $rowt['nombre_tercero'];
                    $class_referencia_cierre = $row3['referencia_producto'];
                    $class_talla_cierre = $row3['talla'];
                    require '../../../clases/class-cierre.php';
                }
            }

            header("Location: ../despacho-detalle.php?id_despacho=" . $id_int);
            exit;

        } else {
            http_response_code(500);
            exit("Error: " . $sql2 . "<br>" . $conn->error);
        }
    } else {
        http_response_code(500);
        exit("Error: " . $sql1 . "<br>" . $conn->error);
    }

} elseif ($estado != 'Cancelado') {

    // (este bloque es el mismo que arriba en tu código, lo dejo igual)
    $sql1 = "UPDATE despacho SET estado='$estado' WHERE id='$id_int'";
    if ($conn->query($sql1) === TRUE) {

        $sql2 = "UPDATE despacho_detalle SET estado='$estado' WHERE id_despacho='$id_int'";
        if ($conn->query($sql2) === TRUE) {

            $sql3 = "SELECT * FROM despacho_detalle WHERE id_despacho='$id_int'";
            $query3 = $conn->query($sql3);
            if ($query3 && $query3->num_rows > 0) {
                while ($row3 = $query3->fetch_assoc()) {

                    $class_referencia = $row3['referencia_producto'];
                    $class_talla = $row3['talla'];
                    require '../../../clases/class-referencia.php';

                    $class_nombre_tercero_cierre = $rowt['nombre_tercero'];
                    $class_referencia_cierre = $row3['referencia_producto'];
                    $class_talla_cierre = $row3['talla'];
                    require '../../../clases/class-cierre.php';
                }
            }

            header("Location: ../despacho-detalle.php?id_despacho=" . $id_int);
            exit;

        } else {
            http_response_code(500);
            exit("Error: " . $sql2 . "<br>" . $conn->error);
        }
    }

} else {
    // mismo alert tuyo, solo con redirect limpio
    header("Location: ../despacho-detalle.php?id_despacho=" . $id_int . "&err=" . urlencode("Acción denegada debido a que podría comprometer la integridad del inventario."));
    exit;
}
