<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario      = post('nombre_usuario');
$nombre_tercero      = post('nombre_tercero');
$fecha               = post('fecha');
$referencia_producto = post('referencia_producto');
$talla               = post('talla');
$cantidad            = post('cantidad');
$precio_unidad       = post('precio_unidad');
$observacion         = post('observacion', 'No aplica');

$movimiento  = 'Entrada';
$tipo_novedad = 'Devolucion';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '')      $errores[] = 'Falta nombre_usuario';
if ($nombre_tercero === '')      $errores[] = 'Falta nombre_tercero';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';
if ($talla === '')               $errores[] = 'Falta talla';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($cantidad === '' || !is_numeric($cantidad) || (int)$cantidad <= 0) {
    $errores[] = 'Cantidad inválida';
}
$cantidad_int = (int)$cantidad;

if ($precio_unidad === '' || !is_numeric($precio_unidad) || (float)$precio_unidad < 0) {
    $errores[] = 'Precio unidad inválido';
}
$precio_num = (float)$precio_unidad;

// si en tu sistema manejas "No aplica" o "Vario", podrías guardar NULL:
if (in_array(strtolower($nombre_tercero), ['no aplica', 'vario'], true)) {
    $nombre_tercero_db = null;
} else {
    $nombre_tercero_db = $nombre_tercero;
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

/* ---------------- Insert seguro + actualización stock ---------------- */
try {
    $conn->begin_transaction();

    $stmt = $conn->prepare("
        INSERT INTO novedad
        (nombre_usuario, nombre_tercero, fecha, referencia_producto, talla, cantidad, precio_unidad, movimiento, observacion, tipo_novedad)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    if (!$stmt) throw new Exception("Prepare novedad: " . $conn->error);

    // types: s s s s s i d s s s
    $stmt->bind_param(
        "sssssids" . "ss",
        $nombre_usuario,
        $nombre_tercero_db,
        $fecha,
        $referencia_producto,
        $talla,
        $cantidad_int,
        $precio_num,
        $movimiento,
        $observacion,
        $tipo_novedad
    );

    if (!$stmt->execute()) throw new Exception("Execute novedad: " . $stmt->error);
    $stmt->close();

    // Actualización referencia/talla
    $class_referencia = $referencia_producto;
    $class_talla = $talla;
    require '../../../clases/class-referencia.php';

    $conn->commit();

    // PRG redirect (evita duplicado por refresh)
    header("Location: ../devolucion.php?nombre_tercero=" . urlencode((string)$nombre_tercero) . "&referencia_producto=" . urlencode($referencia_producto));
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error al guardar: " . $e->getMessage());
}
