<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $nombre_tercero = $_GET['nombre_tercero'];
} else {
    $nombre_tercero = '';
}
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>
</head>

<body>
    <!--start wrapper-->
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php">
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Mercancia por despachar</li>
                    </ol>
                </nav>

                <div class="card">
                    <div class="card-body text-center">
                        <h3><b> MERCANCIA POR DESPACHAR A CLIENTE</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-mercancia-despachar-cliente.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="custom-select" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                        ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled="">Seleccione</option>

                                                            <?php
                                                            } else {
                                                            ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                            <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>

                                                            <?php
                                                        }

                                                        $sql6m = "SELECT * FROM tercero ORDER BY nombre asc";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                            ?>
                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                        <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">


                        <style>
                            th,
                            td {
                                white-space: nowrap;
                            }

                            div.dataTables_wrapper {
                                width: 100%;
                                margin: 0 auto;
                            }
                        </style>




                        <div class=" mt-3">
                            <h5 class="mt-3 text-decoration-underline"><b><?php echo $nombre_tercero; ?></b></h5>

                            <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                <thead class="bg-gradient-info text-white">
                                    <tr class=" ">
                                        <th class="bg-gradient-info">REFERENCIAS</th>
                                        <?php
                                        $sql = "SELECT talla FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY talla ORDER BY talla asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                        ?>
                                                <th class="text-center"><?php echo $row['talla']; ?></th>
                                        <?php
                                            }
                                        }
                                        ?>


                                        <th class="text-center">TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $total = 0;
                                    $sql1 = "SELECT referencia_producto FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY referencia_producto ORDER BY referencia_producto asc";
                                    $query1 = $conn->query($sql1);
                                    if ($query1->num_rows > 0) {
                                        while ($row1 = $query1->fetch_assoc()) {
                                    ?>
                                            <tr class="">
                                                <td class="">
                                                    <b class="text-primary"><?php echo $row1['referencia_producto']; ?></b>
                                                </td>

                                                <?php
                                                $total_talla = 0;
                                                $sql2 = "SELECT talla FROM referencia_despacho WHERE nombre_tercero='$nombre_tercero' GROUP BY talla ORDER BY talla asc";
                                                $query2 = $conn->query($sql2);
                                                if ($query2->num_rows > 0) {
                                                    while ($row2 = $query2->fetch_assoc()) {

                                                        $sql3 = "SELECT SUM(cantidad) as cantidad FROM referencia_despacho WHERE referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $row2['talla'] . "' AND nombre_tercero='$nombre_tercero'";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        $talla = number_format($row3['cantidad'], 0);

                                                        if ($talla < 0) {
                                                            $bg_color_talla = 'bg-danger';
                                                            $text_color = 'text-white';
                                                        } elseif ($talla > 0) {
                                                            $bg_color_talla = 'bg-info';
                                                            $text_color = 'text-white';
                                                        } else {
                                                            $bg_color_talla = '';
                                                            $text_color = 'text-secondary';
                                                        }
                                                ?>
                                                        <td class="text-center <?php echo $bg_color_talla; ?>">
                                                            <?php
                                                            if ($talla <= 0) {
                                                            ?>
                                                                <b class="<?php echo $text_color; ?>"><?php echo $talla; ?></b>

                                                            <?php
                                                            } else {
                                                            ?>

                                                                <a href="#" style="text-decoration: underline;"
                                                                    data-bs-toggle="modal" data-bs-target="#cierre_pedido"
                                                                    data-nombre_usuario="<?php echo $rowusu['nombre']; ?>"
                                                                    data-nombre_tercero="<?php echo $nombre_tercero; ?>"
                                                                    data-referencia_producto="<?php echo $row1['referencia_producto']; ?>"
                                                                    data-talla="<?php echo $row2['talla']; ?>"
                                                                    data-cantidad="<?php echo $row3['cantidad']; ?>">
                                                                    <b class="<?php echo $text_color; ?>"><?php echo $talla; ?></b>
                                                                </a>


                                                            <?php
                                                            }
                                                            ?>



                                                        </td>
                                                <?php
                                                        $total_talla += $talla;
                                                    }
                                                }
                                                ?>
                                                <td class="text-center">
                                                    <?php
                                                    if ($total_talla < 0) {
                                                        $text_total_color = 'text-danger';
                                                    } elseif ($total_talla > 0) {
                                                        $text_total_color = 'text-info';
                                                    } else {
                                                        $text_total_color = '';
                                                    }
                                                    ?>

                                                    <h6><b class="<?php echo $text_total_color; ?>"><?php echo $total_talla; ?></b></h6>
                                                </td>

                                            </tr>
                                    <?php


                                            $total += $total_talla;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="text-center">
                            <h4><b><?= $total ?></b></h4>
                        </div>
                        <div class="text-end">
                            <span>Mercancia por despachar</span> <i class="fa-solid fa-square  text-info"></i>
                            <br>
                            <span>Mercancia que se despacho de mas</span> <i class="fa-solid fa-square  text-danger"></i>
                        </div>

                    </div>
                </div>
            </div>

            <?php echo include '../general/footer.php'; ?>

        </div>
    </div>

    <?php echo include '../general/libreria-js.php'; ?>



    <script>
        $(document).ready(function() {
            var table = $('#example').DataTable({
                scrollY: "500px",
                scrollX: true,
                scrollCollapse: true,
                paging: false,
                ordering: false,
                fixedColumns: {
                    left: 1,
                },

                language: {
                    search: 'Buscar',
                    zeroRecords: 'No hay registros para mostrar.',
                    emptyTable: 'La tabla está vacia.',
                    info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                    infoFiltered: "(Filtrados de _MAX_ Registros.)",
                    paginate: {
                        first: 'Primero',
                        previous: 'Anterior',
                        next: 'Siguiente',
                        last: 'Último'
                    }
                },

            });
            table.buttons().container()
                .appendTo('#example2_wrapper .col-md-6:eq(0)');
        });
    </script>


    <div class="modal fade text-start text-dark" id="cierre_pedido" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title card-heading" id="exampleModalLabel">Hacer cierre</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class="" method="POST" action="script/cierre-pedido.php">
                    <div class="modal-body row">

                        <div class="col-sm-12 mt-2">
                            <label class="form-label" for="validationCustom01">Usuario de registro</label>
                            <input type="text" name="nombre_usuario" id="nombre_usuario" parsley-trigger="change" required readonly=""
                                class="form-control">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label class="form-label" for="validationCustom01">Tercero</label>
                            <input type="text" name="nombre_tercero" id="nombre_tercero" parsley-trigger="change" required readonly=""
                                class="form-control">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label class="form-label" for="validationCustom01">Referencia</label>
                            <input type="text" name="referencia_producto" id="referencia_producto" parsley-trigger="change" required readonly=""
                                class="form-control">
                        </div>
                        <div class="col-sm-12 mt-2">
                            <label class="form-label" for="validationCustom01">Talla</label>
                            <input type="text" name="talla" id="talla" parsley-trigger="change" required readonly=""
                                class="form-control">
                        </div>

                        <div class="col-sm-12 mt-2">
                            <label class="form-label" for="validationCustom01">Cantidad</label>

                            <input class="form-control inputcss " type="number" required="" name="cantidad" id="cantidad" placeholder="cant." value="<?php echo $talla; ?>">
                            <div class="valid-feedback">Se ve bien!</div>
                            <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-warning" name="editar"
                            onclick="if (!confirm('Seguro deseas hacer cierre de este registro?')) {
                                                return false

                                            }">
                            Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#cierre_pedido').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var nombre_usuario = button.data('nombre_usuario')
            var nombre_tercero = button.data('nombre_tercero')
            var referencia_producto = button.data('referencia_producto')
            var talla = button.data('talla')
            var cantidad = button.data('cantidad')

            $('#nombre_usuario').val(nombre_usuario)
            $('#nombre_tercero').val(nombre_tercero)
            $('#referencia_producto').val(referencia_producto)
            $('#talla').val(talla)
            $('#cantidad').val(cantidad)
        });
    </script>
</body>

</html>