<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit('Método no permitido');
}

function post($k, $default = '') {
  return trim($_POST[$k] ?? $default);
}

$id_pedido      = post('id_pedido');
$nombre_usuario = post('nombre_usuario');
$fecha          = post('fecha');
$numero_pedido  = post('numero_pedido');
$nombre_tercero = post('nombre_tercero');
$observacion    = post('observacion');

/* Validaciones mínimas */
$errores = [];
if ($id_pedido === '' || !ctype_digit($id_pedido) || (int)$id_pedido <= 0) $errores[] = 'id_pedido inválido';
if ($nombre_usuario === '') $errores[] = 'Falta nombre_usuario';
if ($fecha === '' || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $fecha)) $errores[] = 'Fecha inválida';
if ($numero_pedido === '') $errores[] = 'Falta numero_pedido';
if ($nombre_tercero === '') $errores[] = 'Falta nombre_tercero';
if ($observacion === '') $observacion = 'No aplica';

if ($errores) {
  http_response_code(400);
  exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_pedido;

try {
  // 1) Traer pedido actual (para nombre_tercero anterior)
  $stmtT = $conn->prepare("SELECT nombre_tercero FROM pedido WHERE id = ? LIMIT 1");
  if (!$stmtT) throw new Exception("Prepare select pedido: " . $conn->error);

  $stmtT->bind_param("i", $id_int);
  $stmtT->execute();
  $rowt = $stmtT->get_result()->fetch_assoc();
  $stmtT->close();

  if (!$rowt) {
    http_response_code(400);
    exit("Error: El pedido no existe");
  }

  // 2) Update pedido
  $stmtU = $conn->prepare("
    UPDATE pedido
    SET nombre_usuario = ?, fecha = ?, nombre_tercero = ?, numero_pedido = ?, observacion = ?
    WHERE id = ?
  ");
  if (!$stmtU) throw new Exception("Prepare update: " . $conn->error);

  $stmtU->bind_param("sssssi", $nombre_usuario, $fecha, $nombre_tercero, $numero_pedido, $observacion, $id_int);

  if (!$stmtU->execute()) {
    throw new Exception("Execute update: " . $stmtU->error);
  }
  $stmtU->close();

  // 3) Recorrer detalle y recalcular cierres (igual a tu lógica original)
  $stmtD = $conn->prepare("SELECT referencia_producto, talla FROM pedido_detalle WHERE id_pedido = ?");
  if (!$stmtD) throw new Exception("Prepare detalle: " . $conn->error);

  $stmtD->bind_param("i", $id_int);
  $stmtD->execute();
  $resD = $stmtD->get_result();

  while ($row3 = $resD->fetch_assoc()) {

    // NUEVO tercero
    $class_nombre_tercero_cierre = $nombre_tercero;
    $class_referencia_cierre = $row3['referencia_producto'];
    $class_talla_cierre = $row3['talla'];
    require '../../../clases/class-cierre.php';

    // Tercero ANTERIOR
    $class_nombre_tercero_cierre = $rowt['nombre_tercero'];
    $class_referencia_cierre = $row3['referencia_producto'];
    $class_talla_cierre = $row3['talla'];
    require '../../../clases/class-cierre.php';
  }

  $stmtD->close();

  header("Location: ../pedido-detalle.php?id_pedido=" . $id_int);
  exit;

} catch (Exception $e) {
  http_response_code(500);
  exit("Error: " . $e->getMessage());
}
