<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Panel produccion</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body bg-gradient-purple text-white">
                            <h4 class="text-center"><b>PRODUCCION</b></h4>
                        </div>
                    </div>



                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <h5><b>MENU PRODUCCION</b></h5>
                                    <hr>


                                    <div class="row">

                                        <div class="col-12 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="produccion.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">CARGAR PRODUCCCION</h5>
                                                            <div class="ms-auto"><i class="fa-solid fa-arrow-right"></i></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-12 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="maquina.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">MAQUINAS</h5>
                                                            <div class="ms-auto"><i class="fa-solid fa-arrow-right"></i></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-12 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="molde.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">MOLDES</h5>
                                                            <div class="ms-auto"><i class="fa-solid fa-arrow-right"></i></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-12 mt-2">
                                            <div class="card radius-10 shadow-none mb-0 bg-gradient-purple">
                                                <a href="orden-trabajo-fecha.php">
                                                    <div class="card-body text-white p-4">
                                                        <div class="d-flex align-items-center gap-3">
                                                            <div class="fs-6">
                                                                <i class="far fa-hdd"></i>              
                                                            </div>
                                                            <h5 class="mb-0">ORDEN DE TRABAJO</h5>
                                                            <div class="ms-auto"><i class="fa-solid fa-arrow-right"></i></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                    </div> 
                                </div>
                            </div>
                        </div>

                        <style>
                            #hover_enlace:hover{
                                box-shadow: 0px 0px 20px 0px #3C3D6B;
                            }

                        </style>

                        <div class="col-sm-8">
                            <div class="card radius-10 w-100">
                                <div class="card-body">

                                    <h5><b>PENDIENTE POR PRODUCCION</b></h5>
                                    <hr>

                                    <div class="row">
                                        <?php
                                        $sql = "SELECT p.referencia, p.categoria 
                                                FROM referencia_produccion rp, producto p 
                                                WHERE p.referencia=rp.referencia_producto AND p.bloqueo='No' GROUP BY p.categoria ORDER BY p.categoria asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <div class="col-4 mt-2"  >
                                                    <div class="card radius-10  mb-0 " style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">
                                                        <a href="produccion-categoria.php?nombre_categoria=<?php echo $row['categoria']; ?>" id="hover_enlace" style="border-radius: 15px;">
                                                            <div class="card-body ">
                                                                <div class="d-flex align-items-center gap-3">

                                                                    <h5 class="mb-0 text-dark"><?php echo $row['categoria']; ?></h5>

                                                                    <div class="ms-auto"> </div>
                                                                </div>


                                                                <hr class="">

                                                                <ul class="list-unstyled mb-0 categories-list">

                                                                    <?php
                                                                    $pendiente_categoria = 0;

                                                                    $sql1 = "SELECT p.referencia, p.categoria, p.color, p.color2 
                                                                            FROM referencia_produccion rp, producto p 
                                                                            WHERE p.referencia=rp.referencia_producto AND p.categoria='" . $row['categoria'] . "' AND p.bloqueo='No' GROUP BY p.color, p.color2 ORDER BY p.color asc";
                                                                    $query1 = $conn->query($sql1);
                                                                    if ($query1->num_rows > 0) {
                                                                        while ($row1 = $query1->fetch_assoc()) {

                                                                            $sql2 = "SELECT SUM(rp.cantidad) as cantidad_produccion 
                                                                                    FROM referencia_produccion rp, producto p 
                                                                                    WHERE p.referencia=rp.referencia_producto AND p.categoria='" . $row['categoria'] . "' AND p.bloqueo='No' AND p.color='" . $row1['color'] . "' AND p.color2='" . $row1['color2'] . "'";
                                                                            $query2 = $conn->query($sql2);
                                                                            $row2 = $query2->fetch_assoc();
                                                                            ?>

                                                                            <li>
                                                                                <span>
                                                                                    <?php
                                                                                    if ($row1['color'] == $row1['color2']) {
                                                                                        echo $row1['color'];
                                                                                    } else {
                                                                                        echo $row1['color'] . " - " . $row1['color2']." <b class='text-secondary'>(BICOLOR)</b>";
                                                                                    }
                                                                                    ?>
                                                                                    <span class="float-end badge rounded-pill bg-primary"><?php echo $row2['cantidad_produccion']; ?></span>
                                                                                </span>
                                                                            </li>

                                                                            <?php
                                                                            $pendiente_categoria += $row2['cantidad_produccion'];
                                                                        }
                                                                    }
                                                                    ?>
                                                                </ul>

                                                                <hr>
                                                                <div class="">
                                                                    <ul class="list-unstyled mb-0 categories-list">
                                                                        <li>
                                                                            <span><b>TOTAL</b> <span class="float-end badge rounded-pill bg-primary"><?php echo $pendiente_categoria; ?></span></span>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>

                                                        </a>
                                                    </div>
                                                </div>

                                                <?php
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            $(document).ready(function () {
                var table = $('#example').DataTable({
                    scrollY: "500px",
                    scrollX: true,
                    scrollCollapse: true,
                    paging: false,
                    ordering: false,
                    fixedColumns: {
                        left: 1,
                    },

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    },

                    footerCallback: function (row, data, start, end, display) {
                        var api = this.api();

                        // Remove the formatting to get integer data for summation
                        var intVal = function (i) {
                            return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                        };



<?php
for ($i = 2; $i < $item_footer + 2; $i++) {
    ?>

                            // Total over all pages
                            total = api
                                    .column(<?php echo $i; ?>)
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                            // Total over this page
                            pageTotal = api
                                    .column(<?php echo $i; ?>, {page: 'current'})
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                            // Update footer
                            $(api.column(<?php echo $i; ?>).footer()).html(pageTotal);

    <?php
}
?>






                    },

                });
                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


    </body>
</html>