<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id                 = post('id');
$nombre_usuario     = post('nombre_usuario');
$nombre_empleado    = post('nombre_empleado');
$fecha              = post('fecha');
$numero_orden_trabajo = post('numero_orden_trabajo');
$hora_desde         = post('hora_desde');
$hora_hasta         = post('hora_hasta');
$observacion        = post('observacion');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id === '' || !ctype_digit($id) || (int)$id <= 0) $errores[] = 'ID inválido';
$id_int = (int)$id;

if ($nombre_usuario === '')  $errores[] = 'Falta nombre_usuario';
if ($nombre_empleado === '') $errores[] = 'Falta nombre_empleado';
if ($numero_orden_trabajo === '') $errores[] = 'Falta numero_orden_trabajo';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

/*
  horas típicas HTML5: "HH:MM" o "HH:MM:SS"
  (si permites vacío, quita estas validaciones)
*/
if ($hora_desde !== '' && !preg_match('/^\d{2}:\d{2}(:\d{2})?$/', $hora_desde)) $errores[] = 'hora_desde inválida';
if ($hora_hasta !== '' && !preg_match('/^\d{2}:\d{2}(:\d{2})?$/', $hora_hasta)) $errores[] = 'hora_hasta inválida';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    // Verificar que exista
    $stmtChk = $conn->prepare("SELECT id FROM orden_trabajo WHERE id = ? LIMIT 1");
    if (!$stmtChk) throw new Exception("Prepare check: " . $conn->error);

    $stmtChk->bind_param("i", $id_int);
    $stmtChk->execute();
    $existe = (bool)$stmtChk->get_result()->fetch_assoc();
    $stmtChk->close();

    if (!$existe) {
        throw new Exception("La orden de trabajo no existe");
    }

    // Update seguro
    $stmt = $conn->prepare("
        UPDATE orden_trabajo
        SET nombre_usuario = ?,
            nombre_empleado = ?,
            fecha = ?,
            numero_orden_trabajo = ?,
            hora_desde = ?,
            hora_hasta = ?,
            observacion = ?
        WHERE id = ?
        LIMIT 1
    ");
    if (!$stmt) throw new Exception("Prepare update: " . $conn->error);

    $stmt->bind_param(
        "sssssssi",
        $nombre_usuario,
        $nombre_empleado,
        $fecha,
        $numero_orden_trabajo,
        $hora_desde,
        $hora_hasta,
        $observacion,
        $id_int
    );

    if (!$stmt->execute()) throw new Exception("Execute update: " . $stmt->error);
    $stmt->close();

    $conn->commit();

    header("Location: ../orden-trabajo-detalle.php?id_orden_trabajo=" . $id_int);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
