<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_orden_trabajo = post('id_orden_trabajo');

/* ---------------- Validaciones ---------------- */
if ($id_orden_trabajo === '' || !ctype_digit($id_orden_trabajo) || (int)$id_orden_trabajo <= 0) {
    http_response_code(400);
    exit('Error: id_orden_trabajo inválido');
}

$id_ot = (int)$id_orden_trabajo;

try {
    $conn->begin_transaction();

    /* 1) Verificar que exista la OT (y opcionalmente bloquearla) */
    $stmtChk = $conn->prepare("SELECT id FROM orden_trabajo WHERE id = ? LIMIT 1 FOR UPDATE");
    if (!$stmtChk) throw new Exception("Prepare check OT: " . $conn->error);

    $stmtChk->bind_param("i", $id_ot);
    $stmtChk->execute();
    $existe = (bool)$stmtChk->get_result()->fetch_assoc();
    $stmtChk->close();

    if (!$existe) {
        throw new Exception("La orden de trabajo no existe");
    }

    /* 2) Obtener ids de orden_sugerencia de esa OT */
    $stmtOS = $conn->prepare("SELECT id FROM orden_sugerencia WHERE id_orden_trabajo = ?");
    if (!$stmtOS) throw new Exception("Prepare select orden_sugerencia: " . $conn->error);

    $stmtOS->bind_param("i", $id_ot);
    $stmtOS->execute();
    $resOS = $stmtOS->get_result();

    $ids = [];
    while ($r = $resOS->fetch_assoc()) {
        $ids[] = (int)$r['id'];
    }
    $stmtOS->close();

    /* 3) Si hay sugerencias, borrar todo lo asociado en lote */
    if (!empty($ids)) {
        // Construir placeholders (?, ?, ?)
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $types = str_repeat('i', count($ids));

        // Helper para ejecutar delete IN (...)
        $runDeleteIn = function($sql) use ($conn, $types, $ids) {
            $stmt = $conn->prepare($sql);
            if (!$stmt) throw new Exception("Prepare delete: " . $conn->error);
            $stmt->bind_param($types, ...$ids);
            if (!$stmt->execute()) throw new Exception("Execute delete: " . $stmt->error);
            $stmt->close();
        };

        $runDeleteIn("DELETE FROM separar_sugerencia WHERE id_orden_sugerencia IN ($placeholders)");
        $runDeleteIn("DELETE FROM orden_sugerencia_detalle WHERE id_orden_sugerencia IN ($placeholders)");
        $runDeleteIn("DELETE FROM orden_sugerencia_puestos WHERE id_orden_sugerencia IN ($placeholders)");
        $runDeleteIn("DELETE FROM orden_sugerencia WHERE id IN ($placeholders)");
    }

    /* 4) Borrar detalle OT */
    $stmtDelDet = $conn->prepare("DELETE FROM orden_trabajo_detalle WHERE id_orden_trabajo = ?");
    if (!$stmtDelDet) throw new Exception("Prepare delete detalle OT: " . $conn->error);

    $stmtDelDet->bind_param("i", $id_ot);
    if (!$stmtDelDet->execute()) throw new Exception("Execute delete detalle OT: " . $stmtDelDet->error);
    $stmtDelDet->close();

    /* 5) Borrar OT */
    $stmtDelOT = $conn->prepare("DELETE FROM orden_trabajo WHERE id = ?");
    if (!$stmtDelOT) throw new Exception("Prepare delete OT: " . $conn->error);

    $stmtDelOT->bind_param("i", $id_ot);
    if (!$stmtDelOT->execute()) throw new Exception("Execute delete OT: " . $stmtDelOT->error);
    $stmtDelOT->close();

    $conn->commit();

    header("Location: ../orden-trabajo-fecha.php?ok=1");
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
