<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_orden_trabajo    = post('id_orden_trabajo');
$referencia_producto = post('referencia_producto');
$talla               = post('talla');

/* Validaciones mínimas */
$errores = [];
if ($id_orden_trabajo === '' || !ctype_digit($id_orden_trabajo) || (int)$id_orden_trabajo <= 0) $errores[] = 'id_orden_trabajo inválido';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';
if ($talla === '') $errores[] = 'Falta talla';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_orden_trabajo;

/* Delete seguro */
$stmt = $conn->prepare("
    DELETE FROM orden_trabajo_detalle
    WHERE id_orden_trabajo = ? AND referencia_producto = ? AND talla = ?
");
if (!$stmt) {
    http_response_code(500);
    exit("Error prepare: " . $conn->error);
}

$stmt->bind_param("iss", $id_int, $referencia_producto, $talla);

if ($stmt->execute()) {
    header("Location: ../orden-trabajo-detalle.php?id_orden_trabajo=" . $id_int);
    exit;
} else {
    http_response_code(500);
    exit("Error execute: " . $stmt->error);
}
