<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Orden de pedido</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase">Lista de ventas por fecha</h6>
                            <hr/>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px; 
                                    box-shadow: 0px 0px 10px 0px purple;
                                }

                            </style>
                            <div class="table-responsive">
                                <table class="table table-hover table-striped" id="example2" >
                                    <thead>
                                        <tr class="bg-light-primary text-primary">
                                            <th class="text-center">Fecha</th>
                                            <th class="text-center">Cant. de ordenes</th>
                                            <th class="text-center">Cant. de pares</th>
                                            <th class="text-center">Monto</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM venta GROUP BY fecha Order by fecha desc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {



                                                $sql2 = "SELECT COUNT(id) as contar FROM venta WHERE fecha='" . $row['fecha'] . "'";
                                                $query2 = $conn->query($sql2);
                                                $row2 = $query2->fetch_assoc();

                                                $sql3 = "SELECT SUM(vd.cantidad) as cantidad
                                                    FROM venta v, venta_detalle vd
                                                    WHERE v.id=vd.id_venta AND  fecha='" . $row['fecha'] . "' ";
                                                $query3 = $conn->query($sql3);
                                                $row3 = $query3->fetch_assoc();

                                                $sql4 = "SELECT SUM(vd.cantidad * vd.precio_unidad) as total
                                                    FROM venta v, venta_detalle vd
                                                    WHERE v.id=vd.id_venta AND fecha='" . $row['fecha'] . "' ";
                                                $query4 = $conn->query($sql4);
                                                $row4 = $query4->fetch_assoc();
                                                ?>
                                                <tr class="align-middle" id="hover_enlace"
                                                    style="cursor: pointer;"

                                                    onclick=" window.location = 'venta-fecha.php?fecha=<?php echo $row['fecha']; ?>';">
                                                    <td class="text-center"><strong><?php echo $row['fecha']; ?></strong></td>
                                                    <td class="text-center"><?php echo number_format($row2['contar'], 0); ?></td>
                                                    <td class="text-center"><?php echo number_format($row3['cantidad'], 0); ?></td>
                                                    <td class="text-end"><strong> <?php echo number_format($row4['total'], 0); ?></strong></td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>