<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <?php include '../general/libreria-css.php'; ?>

    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Seguimiento por referencia y talla</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> SEGUIMIENTO POR REFERENCIA Y TALLA</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-seguimiento-referencia-talla.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="single-select form-control-sm" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {
                                                            ?>
                                                            <option value="<?php echo $_GET['nombre_tercero']; ?>"><?php echo $_GET['nombre_tercero']; ?></option>
                                                            <option value="" disabled="" >Seleccione</option>

                                                            <?php
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <?php
                                                        }

                                                        $sql1 = "SELECT * FROM tercero";
                                                        $query1 = $conn->query($sql1);
                                                        if ($query1->num_rows > 0) {
                                                            while ($row1 = $query1->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row1['nombre'] ?>"><?php echo $row1['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>REFERENCIA</label>
                                                    <select class="single-select form-control-sm" name="referencia_producto" required>

                                                        <?php
                                                        if (isset($_GET['filtro'])) {
                                                            ?>
                                                            <option value="<?php echo $_GET['referencia_producto']; ?>"><?php echo $_GET['referencia_producto']; ?></option>
                                                            <option value="" disabled="" >Seleccione</option>

                                                            <?php
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <?php
                                                        }



                                                        $sql2 = "SELECT * FROM producto";
                                                        $query2 = $conn->query($sql2);
                                                        if ($query2->num_rows > 0) {
                                                            while ($row2 = $query2->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row2['referencia'] ?>"><?php echo $row2['referencia'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>TALLA</label>
                                                    <select class="single-select form-control-sm" name="talla" required >

                                                        <?php
                                                        if (isset($_GET['filtro'])) {
                                                            ?>

                                                            <option value="<?php echo $_GET['talla']; ?>"><?php echo $_GET['talla']; ?></option>
                                                            <option value="" disabled="" >Seleccione</option>

                                                            <?php
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <?php
                                                        }
                                                        ?>

                                                        <?php
                                                        for ($i = 10; $i < 50; $i++) {
                                                            ?>
                                                            <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                            <?php
                                                        }
                                                        ?>


                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-2 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">






                        <?php
                        if (isset($_GET['filtro'])) {
                            $nombre_tercero = $_GET['nombre_tercero'];
                            $referencia_producto = $_GET['referencia_producto'];
                            $talla = $_GET['talla'];

                            $sql_nombre_tercerop = " AND p.nombre_tercero='$nombre_tercero' ";
                            $sql_referencia_productop = " AND pd.referencia_producto='$referencia_producto' ";
                            $sql_tallap = " AND pd.talla='$talla' ";

                            $sqlp = $sql_nombre_tercerop . $sql_referencia_productop . $sql_tallap;

                            $sql_nombre_tercerod = " AND d.nombre_tercero='$nombre_tercero' ";
                            $sql_referencia_productod = " AND dd.referencia_producto='$referencia_producto' ";
                            $sql_tallad = " AND dd.talla='$talla' ";

                            $sqld = $sql_nombre_tercerod . $sql_referencia_productod . $sql_tallad;

                            $sql_nombre_terceroc = "  nombre_tercero='$nombre_tercero' ";
                            $sql_referencia_productoc = " AND referencia_producto='$referencia_producto' ";
                            $sql_tallac = " AND talla='$talla' ";

                            $sqlc = $sql_nombre_terceroc . $sql_referencia_productoc . $sql_tallac;
                            ?>
                            <div class=" mt-3">



                                <?php
                                if ($nombre_tercero == 'TODO') {
                                    $nit = 'No aplica';
                                } else {
                                    $sqlter = "SELECT * FROM tercero WHERE nombre='$nombre_tercero'";
                                    $queryter = $conn->query($sqlter);
                                    $rowter = $queryter->fetch_assoc();

                                    $nit = $rowter['nit'];
                                }
                                ?>
                                <div class="p-2 rounded">




                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>REPORTE DE SEGUIMIENTO</b></h6>

                                            <h6 class="text-dark mt-0 mb-1"><b> <?php echo $nombre_tercero; ?></b></h6>  
                                            <h6 class="text-dark mt-0 mb-1"><b>REF: </b><?php echo $referencia_producto; ?></h6> 
                                            <h6 class="text-dark mt-0 mb-1"><b>TALLA: </b><?php echo $talla; ?></h6> 

                                            <h6 class="text-dark mt-0 mb-0"></h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px; 
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>


                                <div class="table-responsive"> 
                                    <table class="table table-bordered table-striped table-hover" id="example2">
                                        <thead>
                                            <tr class="bg-light-dark ">
                                                <th class="text-center ">FECHA</th> 
                                                <th class="text-center ">ORIGEN</th>                                          
                                                <th class="text-center ">REFERENCIA</th>
                                                <th class="text-center ">TALLA</th>
                                                <th class="text-center ">CANTIDAD</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $sql3 = "SELECT p.fecha, p.id "
                                                    . "FROM pedido_detalle pd, pedido p "
                                                    . "WHERE p.id=pd.id_pedido  $sqlp AND pd.estado!='Cancelado' GROUP BY p.id";
                                            $query3 = $conn->query($sql3);
                                            if ($query3->num_rows > 0) {
                                                while ($row3 = $query3->fetch_assoc()) {

                                                    $sql4 = "SELECT SUM(cantidad) as cantidad_pedido "
                                                            . "FROM pedido_detalle pd, pedido p "
                                                            . "WHERE p.id=pd.id_pedido  $sqlp AND pd.estado!='Cancelado' AND p.id='" . $row3['id'] . "'";
                                                    $query4 = $conn->query($sql4);
                                                    $row4 = $query4->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td> 
                                                            <b class=""><?php echo $row3['fecha']; ?></b>
                                                        </td>                                                     
                                                        <td class="text-end">
                                                            <b class="text-warning float-start">PEDIDO</b> 
                                                            <b>
                                                                <a href="#" >
                                                                    <?php echo $row3['id']; ?>
                                                                </a>
                                                            </b>
                                                        </td>  
                                                        <td class="">
                                                            <?php echo $referencia_producto; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <?php echo $talla; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <b class="text-warning"><?php echo number_format($row4['cantidad_pedido'], 0); ?></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>


                                            <?php
                                            $sql5 = "SELECT d.fecha, d.id "
                                                    . "FROM despacho_detalle dd, despacho d "
                                                    . "WHERE d.id=dd.id_despacho  $sqld AND dd.estado!='Cancelado'";
                                            $query5 = $conn->query($sql5);
                                            if ($query5->num_rows > 0) {
                                                while ($row5 = $query5->fetch_assoc()) {

                                                    $sql6 = "SELECT SUM(cantidad) as cantidad_despacho "
                                                            . "FROM despacho_detalle dd, despacho d "
                                                            . "WHERE d.id=dd.id_despacho  $sqld AND dd.estado!='Cancelado' AND d.id='" . $row5['id'] . "' GROUP BY d.id";
                                                    $query6 = $conn->query($sql6);
                                                    $row6 = $query6->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td> 
                                                            <b class=""><?php echo $row5['fecha']; ?></b>
                                                        </td>                                                     
                                                        <td class="text-end">
                                                            <b class="text-info float-start">DESPACHO</b> 
                                                            <b>
                                                                <a href="#">
                                                                    <?php echo $row5['id']; ?>
                                                                </a>
                                                            </b>
                                                        </td>  
                                                        <td class="" >
                                                            <?php echo $referencia_producto; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <?php echo $talla; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <b class="text-info">- <?php echo number_format($row6['cantidad_despacho'], 0); ?></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>



                                            <?php
                                            $sql7 = "SELECT fecha FROM cierre_detalle WHERE $sqlc GROUP BY fecha";
                                            $query7 = $conn->query($sql7);
                                            if ($query7->num_rows > 0) {
                                                while ($row7 = $query7->fetch_assoc()) {

                                                    $sql8 = "SELECT SUM(cantidad) as cantidad_cierre FROM cierre_detalle WHERE  $sqlc AND fecha='" . $row7['fecha'] . "'";
                                                    $query8 = $conn->query($sql8);
                                                    $row8 = $query8->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td> 
                                                            <b class=""><?php echo $row7['fecha']; ?></b>
                                                        </td>                                                     
                                                        <td class="text-end">
                                                            <b class="text-warning float-start">CIERRE</b> 
                                                            <b>
                                                      
                                                            </b>
                                                        </td>  
                                                        <td class="" >
                                                            <?php echo $referencia_producto; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <?php echo $talla; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <b class="text-warning"><?php echo number_format($row8['cantidad_cierre'], 0); ?></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>


                                            <?php
                                            $sql9 = "SELECT fecha FROM cierre_pedido_detalle WHERE $sqlc GROUP BY fecha";
                                            $query9 = $conn->query($sql9);
                                            if ($query9->num_rows > 0) {
                                                while ($row9 = $query9->fetch_assoc()) {

                                                    $sql10 = "SELECT SUM(cantidad) as cantidad_cierre_pedido FROM cierre_pedido_detalle WHERE  $sqlc AND fecha='" . $row9['fecha'] . "'";
                                                    $query10 = $conn->query($sql10);
                                                    $row10 = $query10->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td> 
                                                            <b class=""><?php echo $row9['fecha']; ?></b>
                                                        </td>                                                     
                                                        <td class="text-end">
                                                            <b class="text-info float-start">CIERRE PEDIDO</b> 
                                                            <b>
                                                                <a href="../cierre-pedido/cierre-tercero-detalle.php?nombre_tercero=<?php echo $nombre_tercero; ?>&&fecha=<?php echo $row9['fecha']; ?>" style="text-decoration: underline;" target="_blank">
                                                                    Ver
                                                                </a>
                                                            </b>
                                                        </td>  
                                                        <td class="" >
                                                            <?php echo $referencia_producto; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <?php echo $talla; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <b class="text-info">- <?php echo number_format($row10['cantidad_cierre_pedido'], 0); ?></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            }
                                            ?>


                                        </tbody>
                                    </table>
                                </div>



                            </div>
                            <?php
                        } else {
                            
                        }
                        ?>


                    </div>
                </div>
            </div>

        </div>




        <?php echo include '../general/libreria-js.php'; ?>

        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>




        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    'pageLength': 25,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": [[0, 'desc']],
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>